/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.index.IndexFieldDesc;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ElementAndScreener {
    private final Map<String, IndexFieldDesc> keyFields;
    private final Map<String, IndexFieldDesc> includedFields;
    private final Stack<ConditionBlock> cStack = new Stack();
    private final HashSet<String> illegalFields = new HashSet();

    public ElementAndScreener(List<IndexFieldDesc> keyFields, Collection<IndexFieldDesc> includedFields) {
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (IndexFieldDesc ifd : keyFields) {
            keyMapBuilder.put((Object)ifd.getFieldPath().toString(), (Object)ifd);
        }
        this.keyFields = keyMapBuilder.build();
        ImmutableMap.Builder includedMapBuilder = ImmutableMap.builder();
        for (IndexFieldDesc ifd : includedFields) {
            includedMapBuilder.put((Object)ifd.getFieldPath().toString(), (Object)ifd);
        }
        this.includedFields = includedMapBuilder.build();
    }

    public void pushElementAnd(ConditionBlock cBlock) {
        Preconditions.checkNotNull((Object)cBlock);
        this.cStack.push(cBlock);
    }

    public void popElementAnd(ConditionBlock cBlock) {
        Preconditions.checkNotNull((Object)cBlock);
        ConditionBlock poppedBlock = this.cStack.pop();
        assert (poppedBlock == cBlock) : "mismatched pop";
    }

    public void requireField(String fieldPathStr) {
        if (this.cStack.isEmpty()) {
            return;
        }
        if (!this.includedFields.containsKey(fieldPathStr)) {
            this.illegalFields.add(fieldPathStr);
        }
    }

    public boolean isSafeForIndex() {
        return this.illegalFields.size() == 0;
    }
}

