/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;

@Category(value={SimpleTest.class})
public class DBDocumentTest
extends BaseTest {
    public static final String docStrWithoutTags = "{\"map\":{\"null\":null,\"boolean\":true,\"string\":\"eureka\",\"byte\":127,\"short\":32767,\"int\":2147483647,\"long\":9223372036854775807,\"float\":3.4028235,\"double\":1.7976931348623157E308,\"decimal\":123456789012345678901234567890123456789012345678901.23456789,\"date\":\"2012-10-20\",\"time\":\"07:42:46\",\"timestamp\":\"2012-10-20T14:42:46.123Z\",\"interval\":172800000,\"binary\":\"YWJjZA==\",\"array\":[42,\"open sesame\",3.14,\"2015-01-21\"]}}";
    private static final String docStrWithTags = "{\"map\":{\"null\":null,\"boolean\":true,\"string\":\"eureka\",\"byte\":{\"$numberLong\":127},\"short\":{\"$numberLong\":32767},\"int\":{\"$numberLong\":2147483647},\"long\":{\"$numberLong\":9223372036854775807},\"float\":3.4028235,\"double\":1.7976931348623157E308,\"decimal\":{\"$decimal\":\"123456789012345678901234567890123456789012345678901.23456789\"},\"date\":{\"$dateDay\":\"2012-10-20\"},\"time\":{\"$time\":\"07:42:46\"},\"timestamp\":{\"$date\":\"2012-10-20T14:42:46.123Z\"},\"interval\":{\"$interval\":172800000},\"binary\":{\"$binary\":\"YWJjZA==\"},\"array\":[42,\"open sesame\",3.14,{\"$dateDay\":\"2015-01-21\"}]}}";

    @Test
    public void setFromJsonStringTest() throws Exception {
        Document doc = MapRDBImpl.newDocument((String)docStrWithTags);
        Assert.assertEquals((Object)docStrWithoutTags, (Object)doc.toString());
        Assert.assertEquals((Object)docStrWithoutTags, (Object)doc.asJsonString());
        Assert.assertEquals((Object)docStrWithTags, (Object)doc.asJsonString(JsonOptions.WITH_TAGS));
    }

    @Test
    public void testJson_AsJsonStringNonDocument() throws Exception {
        Document doc = MapRDBImpl.newDocument((String)docStrWithTags);
        Assert.assertEquals((Object)"null", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.null").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"true", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.boolean").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"\"eureka\"", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.string").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$numberLong\":127}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.byte").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$numberLong\":32767}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.short").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$numberLong\":2147483647}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.int").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$numberLong\":9223372036854775807}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.long").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"3.4028235", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.float").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"1.7976931348623157E308", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.double").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$decimal\":\"123456789012345678901234567890123456789012345678901.23456789\"}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.decimal").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$dateDay\":\"2012-10-20\"}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.date").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$time\":\"07:42:46\"}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.time").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$date\":\"2012-10-20T14:42:46.123Z\"}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.timestamp").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"{\"$binary\":\"YWJjZA==\"}", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.binary").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
        Assert.assertEquals((Object)"[42,\"open sesame\",3.14,{\"$dateDay\":\"2015-01-21\"}]", (Object)Json.toJsonString((DocumentReader)doc.getValue("map.array").asReader(), (JsonOptions)JsonOptions.WITH_TAGS));
    }
}

