/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.ojai.DBDocumentReaderIterable;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.jni.MapRResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.exceptions.StreamInUseException;
import org.ojai.store.QueryResult;

public class DBDocumentStream
implements QueryResult,
OjaiQueryProperties {
    MapRResultScanner scanner_;
    boolean excludeId_;
    BaseJsonTable table_ = null;
    private volatile boolean iteratorOpened_;
    private volatile boolean closed_;
    private volatile boolean docStreamIteratorOpened_;
    private final String priTablePath;
    private final String indexName;
    Set<FieldPath> conditionPaths_;
    String[] projPaths_;
    String[] projIndexPaths_;
    FieldPath[] projIndexFieldPaths_;
    Map<String, FieldPath> fieldPathMap_;

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, BaseJsonTable table) {
        this.priTablePath = table.getPath().toString();
        this.indexName = null;
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = table;
        this.iteratorOpened_ = false;
        this.conditionPaths_ = null;
        this.projPaths_ = null;
        this.projIndexPaths_ = null;
        this.projIndexFieldPaths_ = null;
        this.fieldPathMap_ = null;
        this.closed_ = false;
        this.docStreamIteratorOpened_ = false;
    }

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, BaseJsonTable table, Set<FieldPath> condPaths, String ... projPaths) {
        this.priTablePath = table.getPath().toString();
        this.indexName = null;
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = table;
        this.iteratorOpened_ = false;
        this.conditionPaths_ = condPaths;
        this.projPaths_ = projPaths;
        this.projIndexPaths_ = null;
        this.projIndexFieldPaths_ = null;
        this.fieldPathMap_ = null;
        this.closed_ = false;
        this.docStreamIteratorOpened_ = false;
    }

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, MapRDBIndexImpl index, Set<FieldPath> condPaths, String ... projPaths) {
        this.priTablePath = index.getTablePath().toString();
        this.indexName = index.getIndexName();
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = index;
        this.iteratorOpened_ = false;
        this.conditionPaths_ = condPaths;
        this.projPaths_ = projPaths;
        this.projIndexPaths_ = null;
        this.projIndexFieldPaths_ = null;
        this.fieldPathMap_ = null;
        this.closed_ = false;
        this.docStreamIteratorOpened_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamTo(DocumentListener l) {
        Exception failure = null;
        try {
            Iterator<Document> iterator = this.iterator();
            while (iterator.hasNext()) {
                Document doc = iterator.next();
                if (l.documentArrived(doc)) continue;
                break;
            }
        }
        catch (Exception e) {
            failure = e;
        }
        finally {
            block15: {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (failure != null) break block15;
                    failure = e;
                }
            }
        }
        if (failure == null) {
            l.eos();
        } else {
            l.failed(failure);
        }
    }

    public synchronized void close() {
        if (!this.closed_) {
            this.scanner_.close();
            this.closed_ = true;
        }
    }

    private Document next() throws IOException {
        MapRResult res = null;
        try {
            res = this.scanner_.nextRow();
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "findAll.next()");
        }
        ByteBuffer keyBuf = res.getKey();
        if (keyBuf == null) {
            return null;
        }
        Map cfbufs = res.getJsonByteBufs();
        if (cfbufs == null) {
            return null;
        }
        if (this.fieldPathMap_ == null) {
            this.fieldPathMap_ = new HashMap<String, FieldPath>();
        }
        boolean shouldPrunePaths = this.conditionPaths_ != null && this.conditionPaths_.size() != 0;
        DBDocumentImpl doc = null;
        if (this.table_.getTableType() == BaseJsonTable.TableType.TABLE_PRIMARY) {
            doc = RowcolCodec.decode(cfbufs, this.table_.sortedByPath(), this.table_.idToCFNameMap(), keyBuf, this.excludeId_, true, this.table_.isKeepInsertionOrder(), this.table_.decodeTimestamp(), false, shouldPrunePaths ? this.projPaths_ : null, this.fieldPathMap_);
        } else {
            if (this.projIndexPaths_ == null && shouldPrunePaths && this.projPaths_ != null) {
                this.projIndexPaths_ = Arrays.copyOf(this.projPaths_, this.projPaths_.length);
                for (int i = 0; i < this.projPaths_.length; ++i) {
                    MapRDBIndexImpl idxTable = (MapRDBIndexImpl)this.table_;
                    String projPath = idxTable.isArrayIndex() ? idxTable.fieldPathToCFIdQual(this.projPaths_[i]) : idxTable.fieldPathToIdQual(this.projPaths_[i]);
                    this.projIndexPaths_[i] = projPath == null ? "$" : projPath;
                }
                this.projIndexFieldPaths_ = SerializationContext.getFieldPaths(this.projIndexPaths_);
            }
            doc = RowcolCodec.decodeIndexData(cfbufs, this.table_.sortedByPath(), this.table_.idToCFNameMap(), ((MapRDBIndexImpl)this.table_).getFpIdxTofpMap(), keyBuf, this.excludeId_, this.table_.getIndexedFieldList(), this.table_.isKeepInsertionOrder(), this.table_.decodeTimestamp(), false, shouldPrunePaths ? this.projIndexFieldPaths_ : null, (MapRDBIndexImpl)this.table_, this.fieldPathMap_);
        }
        if (shouldPrunePaths) {
            doc.getDOMFromCachedBuffer();
            if (doc.size() == 0 && doc.getId() == null) {
                return this.next();
            }
        }
        return doc;
    }

    public void makeIteratorNotOpen() {
        this.docStreamIteratorOpened_ = false;
    }

    private void checkDocStreamIteratorOpened() {
        if (this.docStreamIteratorOpened_) {
            throw new StreamInUseException("An iterator has already been opened on this document stream.");
        }
    }

    private synchronized void checkDocStreamClosed() {
        if (this.closed_) {
            throw new IllegalStateException("DocumentStream already closed.");
        }
    }

    public Iterator<Document> iterator() {
        this.checkDocStreamIteratorOpened();
        this.checkDocStreamClosed();
        this.docStreamIteratorOpened_ = true;
        return new Iterator<Document>(){
            Document next = null;
            boolean done = false;

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                DBDocumentStream.this.checkDocStreamClosed();
                if (this.next == null) {
                    try {
                        this.next = DBDocumentStream.this.next();
                        if (this.next == null) {
                            this.done = true;
                            try {
                                DBDocumentStream.this.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw ExceptionHandler.handle(e, "findNext()");
                    }
                }
                return true;
            }

            @Override
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called after hasNext() returned false.");
                }
                Document temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<DocumentReader> documentReaders() {
        this.checkStateForIteration();
        this.iteratorOpened_ = true;
        return new DBDocumentReaderIterable(this);
    }

    private void checkStateForIteration() {
        if (this.iteratorOpened_) {
            throw new StreamInUseException("An iterator has already been opened on this document stream.");
        }
    }

    @Override
    public OjaiQueryProperties.QueryPath getQueryPath() {
        return OjaiQueryProperties.QueryPath.DIRECT;
    }

    @Override
    public String getIndexUsed() {
        return this.table_ instanceof MapRDBIndexImpl ? ((MapRDBIndexImpl)this.table_).getIndexName() : this.table_.getName();
    }

    @Override
    public void getQueryPlan(List<Map<String, Object>> planList) {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (this.priTablePath != null) {
            valueMap.put("primaryTable", this.priTablePath);
        }
        if (this.indexName != null) {
            valueMap.put("indexName", this.indexName);
        }
        if (this.conditionPaths_ != null) {
            valueMap.put("queryConditionPath", new ArrayList<FieldPath>().addAll(this.conditionPaths_));
        }
        if (this.projPaths_ != null) {
            valueMap.put("projectionPath", new ArrayList<String>(Arrays.asList(this.projPaths_)));
        }
        if (this.projIndexPaths_ != null) {
            valueMap.put("indexProjectionPath", new ArrayList<String>(Arrays.asList(this.projIndexPaths_)));
        }
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    public Document getQueryPlan() {
        ArrayList<Map<String, Object>> queryPlan = new ArrayList<Map<String, Object>>();
        this.getQueryPlan(queryPlan);
        DBDocumentImpl res = new DBDocumentImpl();
        res.setArray("QueryPlan", new Object[]{queryPlan});
        return res;
    }
}

