/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import org.apache.commons.lang.mutable.MutableInt;

public class ErrorComponent
extends IndexRowKeyComponent {
    private static final int ERROR_WITH_NO_PARAMETERS_ENCODING_SIZE = 2;
    private static final int valueSize = 4;
    private Error value_;
    private int encodingSize_;

    public ErrorComponent(Error value) {
        super((byte)16, false);
        this.value_ = value;
    }

    @Override
    public byte getMarker(boolean biggest) {
        return -1;
    }

    @Override
    public int getEncodingSizeEstimate() {
        return 5;
    }

    @Override
    public int calculateEncodingSize(ByteReader encodedData, int offset) {
        if (encodedData.getByte(offset) != -1) {
            return 0;
        }
        switch (encodedData.getByte(offset + 1)) {
            case 1: {
                this.encodingSize_ = 2;
                break;
            }
            case -2: 
            case -1: 
            case 2: {
                this.encodingSize_ = 3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.encodingSize_;
    }

    @Override
    public int getEncodingSize() {
        return this.encodingSize_;
    }

    @Override
    public Error getError() {
        return this.value_;
    }

    @Override
    public String getErrorMessage() {
        switch (this.value_.id) {
            case 1: {
                return "Index rowkey encoding exceeded 32K.";
            }
            case 2: {
                return "Cast failed during index rowkey encoding. Index component " + this.value_.idx;
            }
            case -2: {
                return "Arrays are not supported by index rowkey encoder. Index component " + this.value_.idx;
            }
            case -1: {
                return "Maps are not supported by index rowkey encoder. Index component " + this.value_.idx;
            }
        }
        return "Unknown index rowkey encoding error.";
    }

    @Override
    public int encode(ByteBuffer dst) {
        int i = 0;
        dst.put((byte)-1);
        dst.put(this.value_.id);
        switch (this.value_.id) {
            case 1: {
                break;
            }
            case -2: 
            case -1: 
            case 2: {
                i = 1;
                dst.put(this.value_.idx);
                break;
            }
        }
        return 2 + i;
    }

    @Override
    public int decode(ByteReader buf, int offset, int encodedDataSize, MutableInt origTypeIndex) {
        if (buf.getByte(offset) != -1) {
            return -1;
        }
        int i = 0;
        int j = 1 + offset;
        this.value_.id = buf.getByte(j++);
        switch (this.value_.id) {
            case 1: {
                break;
            }
            case -2: 
            case -1: 
            case 2: {
                i = 1;
                this.value_.idx = buf.getByte(j);
                break;
            }
            default: {
                return -1;
            }
        }
        this.setOrigType(buf.getByte(origTypeIndex.intValue()));
        origTypeIndex.increment();
        this.setIsDecoded();
        return 2 + i;
    }
}

