/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang.mutable.MutableInt;

public class ByteArrayComponent
extends IndexRowKeyComponent {
    protected byte[] value_;
    private int valueSize_;
    private int encodingSize_;

    ByteArrayComponent(boolean descendingOrder) {
        super((byte)4, descendingOrder);
        this.value_ = null;
        this.valueSize_ = 0;
    }

    ByteArrayComponent(boolean descendingOrder, byte type) {
        super(type, descendingOrder);
        this.value_ = null;
        this.valueSize_ = 0;
    }

    ByteArrayComponent(byte[] value, int valueSize, boolean descendingOrder) {
        super((byte)4, descendingOrder);
        this.value_ = value;
        this.valueSize_ = valueSize;
    }

    ByteArrayComponent(byte[] value, int valueSize, boolean descendingOrder, byte type) {
        super(type, descendingOrder);
        this.value_ = value;
        this.valueSize_ = valueSize;
    }

    public byte getMarker() {
        if (this.getType() == 4) {
            return this.descendingOrder_ ? (byte)-10 : 9;
        }
        return this.descendingOrder_ ? (byte)-9 : 8;
    }

    @Override
    public byte getMarker(boolean biggest) {
        return this.getMarker();
    }

    @Override
    public int getEncodingSizeEstimate() {
        return (int)(1.0 + (double)this.value_.length * 1.1428571428571428 + 2.0);
    }

    @Override
    public int calculateEncodingSize(ByteReader buf, int offset) {
        this.separator_ = this.descendingOrder_ ? (byte)-1 : 0;
        this.encodingSize_ = this.findIdx(buf, offset, this.separator_);
        return this.encodingSize_;
    }

    @Override
    public int getEncodingSize() {
        return this.encodingSize_;
    }

    @Override
    public byte[] getByteArray() {
        return this.value_;
    }

    @Override
    public int encode(ByteBuffer dst) {
        dst.put(this.getMarker());
        if (this.descendingOrder_) {
            if (this.valueSize_ > 0) {
                int encodedSize = this.encodeByteArrayOnesComplement(this.value_, this.valueSize_, dst);
                if (encodedSize == 0) {
                    return -1;
                }
                this.encodingSize_ = 1 + encodedSize;
            } else {
                this.encodingSize_ = 1;
            }
            this.separator_ = -1;
        } else {
            if (this.valueSize_ > 0) {
                int encodedSize = this.encodeByteArray(this.value_, this.valueSize_, dst);
                if (encodedSize == 0) {
                    return -1;
                }
                this.encodingSize_ = 1 + encodedSize;
            } else {
                this.encodingSize_ = 1;
            }
            this.separator_ = 0;
        }
        return this.encodingSize_;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeIndex) {
        int encSize = bufSize - 1;
        ByteBuffer bb = ByteBuffer.allocate(bufSize);
        if (buf.getByte(offset) != this.getMarker()) {
            return -1;
        }
        this.encodingSize_ = 1;
        this.encodingSize_ = this.descendingOrder_ ? (this.encodingSize_ += this.decodeByteArrayOnesComplement(buf, offset + 1, encSize, bb)) : (this.encodingSize_ += this.decodeByteArray(buf, offset + 1, encSize, bb));
        this.value_ = Arrays.copyOfRange(bb.array(), 0, bb.position());
        this.valueSize_ = bb.position();
        if (origTypeIndex != null) {
            this.setOrigType(buf.getByte(origTypeIndex.intValue()));
            origTypeIndex.increment();
        }
        this.setIsDecoded();
        return this.valueSize_;
    }
}

