/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.tests;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.types.ODate;
import org.ojai.types.OTimestamp;
import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.CommandResult;
import org.springframework.shell.core.JLineShellComponent;

@Category(value={ClusterTest.class})
public class TestUpdateCommand
extends BaseTest {
    private static final String TABLE_NAME = "testtable-DeleteCommand";
    private static Table table;
    private static JLineShellComponent shell;
    private String putMutation = "{\"$put\":[{\"a.b\":{\"$date\":\"2002-02-11T02:13:00\"}},{\"x.y\":{\"$numberLong\":255}}]}";
    private String mergeMutation = "{\"$merge\":{\"a.c\":{\"k\":\"abracadabra\"}}}";
    private String appendAndIncrement = "{\"$increment\":\"a.b.c\",\"$append\":[{\"k\":[\"s1\",\"s2\"]}]}";
    private String putComponent = "\"$put\":[{\"a.b\":[false,{\"$dateDay\":\"2014-01-11\"}]},{\"a.c.d\":25}]";
    private String decrementComponent = "\"$decrement\":\"p.q.r\"";
    private String mergeComponent = "\"$merge\":{\"m\":{\"z1\":{\"$numberLong\":123456789},\"z2\":\"how\"}}";
    private String appendOneString = "{\"$append\":{\"a.b\":\"world\"}}";

    @BeforeClass
    public static void setUp() throws Exception {
        table = DBTests.createOrReplaceTable((String)TABLE_NAME);
        Bootstrap bootstrap = new Bootstrap();
        shell = bootstrap.getJLineShellComponent();
    }

    @AfterClass
    public static void cleanUp() {
        table.close();
    }

    @Test
    public void testUpdateWithSetOrReplace() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "Hello").set("a.c", 111).set("x.y", true);
        table.insertOrReplace("id1", doc);
        table.flush();
        String updateCommand = "update " + DBTests.getTablePath((String)TABLE_NAME).toString() + " --id id1 --m " + this.putMutation;
        CommandResult result = shell.executeCommand(updateCommand);
        Assert.assertTrue((boolean)result.isSuccess());
        Document returnedDoc = table.findById("id1");
        Assert.assertEquals((Object)OTimestamp.parse((String)"2002-02-11T02:13:00"), (Object)returnedDoc.getTimestamp("a.b"));
        Assert.assertEquals((long)255L, (long)returnedDoc.getShort("x.y"));
    }

    @Test
    public void testUpdateWithMerge() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b.p", "Hello").set("a.c.d", 111);
        table.insertOrReplace("id1", doc);
        table.flush();
        String mergeCommand = "update " + DBTests.getTablePath((String)TABLE_NAME).toString() + " --id id1 --m " + this.mergeMutation;
        CommandResult result = shell.executeCommand(mergeCommand);
        Assert.assertTrue((boolean)result.isSuccess());
        Document returnedDoc = table.findById("id1");
        Assert.assertEquals((Object)"abracadabra", (Object)returnedDoc.getString("a.c.k"));
        Assert.assertEquals((long)111L, (long)returnedDoc.getInt("a.c.d"));
    }

    @Test
    public void testUpdateWithAppendAndIncrement() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b.c", 35).set("k[0]", "day");
        table.insertOrReplace("id1", doc);
        String appendAndIncrementCommand = "update " + DBTests.getTablePath((String)TABLE_NAME).toString() + " --id id1 --m " + this.appendAndIncrement;
        CommandResult result = shell.executeCommand(appendAndIncrementCommand);
        Assert.assertTrue((boolean)result.isSuccess());
        Document returnedDoc = table.findById("id1");
        Assert.assertEquals((long)36L, (long)returnedDoc.getByte("a.b.c"));
        Assert.assertEquals((Object)"s1", (Object)returnedDoc.getString("k[1]"));
    }

    @Test
    public void testSetupComplexMutation() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "Hello").set("a.c", 111).set("m.x", true);
        table.insertOrReplace("id4", doc);
        table.flush();
        String mutationString = "{" + this.putComponent + "," + this.decrementComponent + "," + this.mergeComponent + "}";
        String updateCommand = "update " + DBTests.getTablePath((String)TABLE_NAME) + " --id id4 --m " + mutationString;
        CommandResult result = shell.executeCommand(updateCommand);
        Assert.assertTrue((boolean)result.isSuccess());
        Document r = table.findById("id4");
        Assert.assertEquals((double)-1.0, (double)r.getDouble("p.q.r"), (double)0.0);
        Assert.assertEquals((Object)ODate.parse((String)"2014-01-11"), (Object)r.getDate("a.b[1]"));
        Assert.assertTrue((boolean)r.getBoolean("m.x"));
        Assert.assertEquals((long)123456789L, (long)r.getLong("m.z1"));
    }

    @Test
    public void testAppendOne() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "Hello").set("a.k", ODate.parse((String)"2015-11-22"));
        table.insertOrReplace("k5", doc);
        table.flush();
        String updateCmd = "update " + DBTests.getTablePath((String)TABLE_NAME) + " --id k5 --m " + this.appendOneString;
        CommandResult result = shell.executeCommand(updateCmd);
        Assert.assertTrue((boolean)result.isSuccess());
        Document r = table.findById("k5");
        Assert.assertEquals((Object)"Helloworld", (Object)r.getString("a.b"));
    }

    @Test
    public void testUpdateCommandWithDuplicateId() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 10).set("b", true);
        table.insertOrReplace("id10", doc);
        doc.set("a", 12);
        table.insertOrReplace("id11", doc);
        table.flush();
        String updateCmd = "update " + DBTests.getTablePath((String)TABLE_NAME) + " --id id10  --m {\"$set\":{\"a\":2234}} --c {\"$eq\":{\"_id\":\"id11\"}";
        CommandResult result = shell.executeCommand(updateCmd);
        Throwable t = result.getException();
        Assert.assertEquals((Object)"ID field can not be in condition if already present in command line", (Object)t.getMessage());
    }
}

