/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.impl;

import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class DocEmptySerialization
extends Configured
implements Serialization<ByteBufWritableComparable> {
    public boolean accept(Class<?> c) {
        return ByteBufWritableComparable.class.isAssignableFrom(c);
    }

    public Serializer<ByteBufWritableComparable> getSerializer(Class<ByteBufWritableComparable> c) {
        return new DocEmptySerializer();
    }

    public Deserializer<ByteBufWritableComparable> getDeserializer(Class<ByteBufWritableComparable> c) {
        return new DocEmptyDeserializer();
    }

    private static class DocEmptySerializer
    implements Serializer<ByteBufWritableComparable> {
        OutputStream out;

        private DocEmptySerializer() {
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(ByteBufWritableComparable t) throws IOException {
            t.write(new DataOutputStream(this.out));
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class DocEmptyDeserializer
    implements Deserializer<ByteBufWritableComparable> {
        DataInputStream d;

        private DocEmptyDeserializer() {
        }

        public void open(InputStream in) throws IOException {
            this.d = new DataInputStream(in);
        }

        public ByteBufWritableComparable deserialize(ByteBufWritableComparable t) throws IOException {
            ByteBufWritableComparable buffer = new ByteBufWritableComparable();
            buffer.readFields(this.d);
            return buffer;
        }

        public void close() throws IOException {
            this.d.close();
        }
    }
}

