/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Table;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRecordReaderImpl {
    static final Logger LOG = LoggerFactory.getLogger(TableRecordReaderImpl.class);
    private Value key = null;
    private Document value = null;
    private Table jTable = null;
    private TaskAttemptContext context = null;
    DocumentStream rs = null;
    Iterator<Document> recordIterator = null;
    private QueryCondition cond = null;
    private String[] fieldPaths = null;

    public void close() {
        try {
            this.jTable.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing table " + e.getMessage());
        }
    }

    public Value getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Document getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.key = null;
        this.value = null;
        if (this.recordIterator.hasNext()) {
            this.value = this.recordIterator.next();
            this.key = this.value.getId();
            return true;
        }
        return false;
    }

    public void initialize(InputSplit inputsplit, TaskAttemptContext cntxt) throws IOException, InterruptedException {
        if (cntxt != null) {
            this.context = cntxt;
        }
        this.rs = this.cond != null ? (this.fieldPaths != null ? this.jTable.find(this.cond, this.fieldPaths) : this.jTable.find(this.cond)) : (this.fieldPaths != null ? this.jTable.find(this.fieldPaths) : this.jTable.find());
        if (this.rs != null) {
            this.recordIterator = this.rs.iterator();
        }
    }

    public void setTable(Table t) {
        this.jTable = t;
    }

    public void setCondition(QueryCondition c) {
        this.cond = c;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPaths = fieldPath.split(",");
    }
}

