/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mapr.client.exceptions.InvalidConfigurationException;
import com.mapr.client.impl.Cluster;
import com.mapr.utils.OSInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConf {
    private static final Logger logger = LoggerFactory.getLogger(ClusterConf.class);
    private static final ClusterConf DEFAULT_CLUSTER_CONF = new ClusterConf(Cluster.DEFAULT_CLUSTER);
    private static final String CLUSTER_CONF_FILE_NAME = "/conf/mapr-clusters.conf";
    private final List<Cluster> clusters;

    private ClusterConf(Cluster cluster) {
        this.clusters = ImmutableList.of((Object)cluster);
    }

    private ClusterConf(List<Cluster> clusters) {
        this.clusters = clusters;
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    @VisibleForTesting
    public static ClusterConf parseClusterConfEntries(BufferedReader br) throws IOException {
        String line;
        ImmutableList.Builder builder = ImmutableList.builder();
        while ((line = br.readLine()) != null) {
            if ((line = line.replaceAll("\\s+", " ").trim()).length() == 0 || line.charAt(0) == '#') continue;
            builder.add((Object)Cluster.parseLine(line));
        }
        ImmutableList clusterList = builder.build();
        return clusterList.size() == 0 ? null : new ClusterConf((List<Cluster>)clusterList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClusterConf getClusterConf() {
        File clusterConfFile;
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            maprHome = OSInfo.getOSName().equals("Windows") ? "C:/opt/mapr" : "/opt/mapr";
        }
        if (!(clusterConfFile = new File(maprHome + CLUSTER_CONF_FILE_NAME)).exists() || !clusterConfFile.isFile()) {
            logger.debug(clusterConfFile.getAbsolutePath() + "not found or is not a regular file");
            return DEFAULT_CLUSTER_CONF;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(clusterConfFile));){
            ClusterConf cc = ClusterConf.parseClusterConfEntries(br);
            if (cc == null) {
                ClusterConf clusterConf = DEFAULT_CLUSTER_CONF;
                return clusterConf;
            }
            ClusterConf clusterConf = cc;
            return clusterConf;
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    public static ClusterConf getClusterConf(String serviceAddresses) {
        return new ClusterConf(new Cluster(serviceAddresses));
    }

    public static ClusterConf getClusterConf(String clusterName, String serviceAddresses) {
        return new ClusterConf(new Cluster(clusterName, serviceAddresses, false));
    }

    public static ClusterConf getClusterConf(String clusterName, String serviceAddresses, boolean isSecure) {
        return new ClusterConf(new Cluster(clusterName, serviceAddresses, isSecure));
    }

    public Cluster getDefaultCluster() {
        return this.clusters.get(0);
    }

    public String asClusterConfFileString() {
        StringBuilder sb = new StringBuilder();
        for (Cluster cluster : this.clusters) {
            sb.append(cluster.asClusterConfFileString()).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return "{\"clusters\":" + this.clusters + "}";
    }
}

