/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import mapr.fs.Rpcheader;

public class RpcResponse {
    private Rpcheader.RpcHeader hdr;
    private final ByteBuf respBuf;
    private final ByteBuf payloadBuf;
    private final ByteBuf ticketBuf;

    public RpcResponse(ByteBuf ticketBuf, ByteBuf hdrBuf, ByteBuf respBuf, ByteBuf payloadBuf) throws IOException {
        this.respBuf = this.retain(respBuf);
        this.ticketBuf = this.retain(ticketBuf);
        this.payloadBuf = this.retain(payloadBuf);
        this.hdr = Rpcheader.RpcHeader.parseFrom((InputStream)new ByteBufInputStream(hdrBuf));
    }

    public Rpcheader.RpcHeader getHdr() throws IOException {
        return this.hdr;
    }

    public long getSequenceId() {
        return this.hdr.getSequence();
    }

    public ByteBuf getRespBuf() {
        return this.respBuf;
    }

    public ByteBuf getPayloadBuf() {
        return this.payloadBuf;
    }

    public ByteBuf getTicketBuf() {
        return this.ticketBuf;
    }

    private ByteBuf retain(ByteBuf in) {
        return in != null ? in.retain() : null;
    }

    private boolean release(ByteBuf in) {
        return in != null ? in.release() : false;
    }

    void release() {
        this.release(this.respBuf);
        this.release(this.ticketBuf);
        this.release(this.payloadBuf);
    }
}

