/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.mapr.client.Config;
import com.mapr.client.impl.rpc.NamedThreadFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHelper {
    private static final Logger logger = LoggerFactory.getLogger(NettyHelper.class);
    public static final ChannelInboundHandlerAdapter DEFAULT_INBOUND_HANDLER = new ChannelInboundHandlerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ByteBuf buff = (ByteBuf)msg;
            try {
                logger.debug("buff.readableBytes = {}", (Object)buff.readableBytes());
            }
            finally {
                buff.release();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.error(cause.getMessage(), cause);
            ctx.close();
        }
    };

    public static ServerBootstrap newServerBootstrap(EventLoopGroup eventLoopGroup, ChannelInitializer<SocketChannel> channelInitializer) {
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NettyHelper.getServerSocketChannel())).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)131072)).option(ChannelOption.SO_SNDBUF, (Object)131072)).childHandler(channelInitializer);
    }

    public static Bootstrap newClientBootstrap(EventLoopGroup eventLoopGroup, ChannelInitializer<SocketChannel> channelInitializer) {
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NettyHelper.getClientSocketChannel())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)131072)).option(ChannelOption.SO_SNDBUF, (Object)131072)).handler(channelInitializer);
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        return Config.isUseEpoll() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        return Config.isUseEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(String prefix, int nThreads) {
        NamedThreadFactory factory = new NamedThreadFactory(prefix);
        return Config.isUseEpoll() ? new EpollEventLoopGroup(nThreads, (ThreadFactory)factory) : new NioEventLoopGroup(nThreads, (ThreadFactory)factory);
    }
}

