/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mapr.client.exceptions.InvalidConfigurationException;
import com.mapr.client.impl.rpc.HostAndPort;
import com.mapr.client.impl.rpc.ServiceHosts;
import java.util.List;

public class Cluster {
    private static final int DEFAULT_CLDB_PORT = 7222;
    private static final String DEFAULT_CLDB_ADDRESS = "localhost:7222";
    private static final String DEFAULT_CLUSTER_NAME = "default";
    static final Cluster DEFAULT_CLUSTER = new Cluster("localhost:7222");
    private final boolean isSecure;
    private final String clusterName;
    private final ServiceHosts cldbHosts;

    public Cluster(String serviceAddresses) {
        this(DEFAULT_CLUSTER_NAME, serviceAddresses, false);
    }

    public Cluster(String clusterName, String serviceAddresses, boolean isSecure) {
        this(clusterName, ServiceHosts.parseFrom(serviceAddresses), isSecure);
    }

    public Cluster(String clusterName, ServiceHosts serviceAddresses, boolean isSecure) {
        this.clusterName = clusterName;
        this.cldbHosts = serviceAddresses;
        this.isSecure = isSecure;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ServiceHosts getCldbHosts() {
        return this.cldbHosts;
    }

    public static Cluster parseLine(String clusterLine) {
        Preconditions.checkNotNull((Object)clusterLine);
        String[] tokens = clusterLine.split(" ");
        if (tokens.length < 2) {
            throw new InvalidConfigurationException("Invalid cluster line: " + clusterLine);
        }
        String clusterNamePart = tokens[0];
        int hostTokenIdx = 1;
        boolean isSecure = false;
        if (tokens[1].startsWith("secure=")) {
            if (tokens[1].endsWith("=true")) {
                isSecure = true;
            }
            hostTokenIdx = 2;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        while (hostTokenIdx < tokens.length) {
            String cldbHostAndPort = tokens[hostTokenIdx];
            String[] parts = cldbHostAndPort.split(":");
            String host = parts[0];
            if (host.equals("") || parts.length > 2) {
                throw new InvalidConfigurationException("Invalid CLDB host address string: " + cldbHostAndPort);
            }
            int port = parts.length == 1 ? 7222 : Integer.valueOf(parts[1].trim());
            builder.add((Object)new HostAndPort(host, port));
            ++hostTokenIdx;
        }
        ImmutableList hostAndPortList = builder.build();
        if (hostAndPortList.size() == 0) {
            throw new InvalidConfigurationException("No addresses specified for the cluster: " + clusterNamePart);
        }
        return new Cluster(clusterNamePart, ServiceHosts.createServiceHosts((List<HostAndPort>)hostAndPortList), isSecure);
    }

    public String asClusterConfFileString() {
        StringBuilder sb = new StringBuilder().append(this.clusterName).append(' ').append("secure=").append(this.isSecure);
        for (HostAndPort hostAndPort : this.cldbHosts) {
            sb.append(' ').append(hostAndPort.getHost()).append(':').append(hostAndPort.getPort());
        }
        return sb.toString();
    }

    public String toString() {
        return "{\"isSecure\":" + this.isSecure + ", \"clusterName\":\"" + this.clusterName + "\", \"cldbHosts\":" + this.cldbHosts + "}";
    }
}

