/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.memory;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;

public class Allocator {
    public static ByteBuf order(ByteBuf buffer) {
        return buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuf buffer(int initialCapacity) {
        return Allocator.order(Unpooled.buffer((int)initialCapacity));
    }

    public static ByteBuf directBuffer(int initialCapacity) {
        return Allocator.order(Unpooled.directBuffer((int)initialCapacity));
    }

    public static ByteBuf wrappedBuffer(byte[] array) {
        return Allocator.order(Unpooled.wrappedBuffer((byte[])array));
    }

    public static ByteBuf wrappedBuffer(ByteBuf ... buffers) {
        return Allocator.order(Unpooled.wrappedBuffer((ByteBuf[])buffers));
    }

    public static ByteBuf buffer(ByteBufAllocator alloc) {
        return Allocator.order(alloc.buffer());
    }

    public static ByteBuf buffer(ByteBufAllocator alloc, int initialCapacity) {
        return Allocator.order(alloc.buffer(initialCapacity));
    }
}

