/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.protobuf.ByteString;
import com.mapr.client.Config;
import com.mapr.client.Connection;
import com.mapr.client.db.Table;
import com.mapr.client.exceptions.MapRClientException;
import com.mapr.client.impl.Cluster;
import com.mapr.client.impl.Constant;
import com.mapr.client.impl.Fid;
import com.mapr.client.impl.LifeCycle;
import com.mapr.client.impl.MfsServerInfo;
import com.mapr.client.impl.clients.CldbClient;
import com.mapr.client.impl.clients.MfsClient;
import com.mapr.client.impl.db.TableImpl;
import com.mapr.client.impl.db.TabletScanner;
import com.mapr.client.impl.msgs.PutWrapper;
import com.mapr.client.impl.msgs.TableSchemaEntry;
import com.mapr.client.impl.msgs.TabletMapEntry;
import com.mapr.client.impl.rpc.NettyHelper;
import com.mapr.client.impl.util.ByteBufReader;
import com.mapr.client.impl.util.Cleanup;
import com.mapr.client.impl.util.Misc;
import com.mapr.db.impl.IdCodec;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.utils.ByteReader;
import com.mapr.utils.Crypto;
import com.stumbleupon.async.Deferred;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoopGroup;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRClient
implements Connection,
LifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(MapRClient.class);
    private final AtomicInteger rpcBindingEpoh;
    private final CldbClient cldbClient;
    private boolean isStarted;
    private EventLoopGroup clientEventLoopGroup;
    private EventLoopGroup serverEventLoopGroup;
    protected Security.CredentialsMsg myCreds;
    protected Common.SetattrMsg myAttr;
    private HashMap<MfsServerInfo, MfsClient> mfsClientCache;
    private LoadingCache<Integer, MfsClient> cidCache;
    private LoadingCache<String, Fid> fidCache;
    private LoadingCache<Fid, RangeMap<ByteBuf, Fid>> tabletMapCache;
    private ConcurrentHashMap<Fid, Fid> reverseTabletMap;
    private LoadingCache<Fid, TableSchemaEntry> tableSchemaCache;
    private ConcurrentHashMap<Fid, TabletMapEntry> tabletInfo;
    private Timer flushTimer;
    private Lock flushLock;
    private Condition flushComplete;

    public MapRClient(Cluster cluster) {
        long sysTime = System.currentTimeMillis();
        long numSecs = sysTime / 1000L;
        long numUSecs = sysTime % 1000L * 1000L;
        this.rpcBindingEpoh = new AtomicInteger((int)(numSecs * 100L + numUSecs));
        this.myCreds = Security.CredentialsMsg.newBuilder().setUid(0).addGids(0).build();
        this.myAttr = Common.SetattrMsg.newBuilder().setUid(0).setGid(0).setMode(493).build();
        this.cldbClient = new CldbClient(this, cluster);
        this.flushTimer = new Timer();
        this.tabletInfo = new ConcurrentHashMap();
        this.reverseTabletMap = new ConcurrentHashMap();
        this.flushLock = new ReentrantLock();
        this.flushComplete = this.flushLock.newCondition();
        this.mfsClientCache = new HashMap();
        this.cidCache = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<Integer, MfsClient>(){

            public MfsClient load(Integer containerId) throws Exception {
                CLDBProto.ContainerLookupResponse cresp = (CLDBProto.ContainerLookupResponse)MapRClient.this.cldbClient.containerLookup(containerId).join();
                Common.Server mfsServer = cresp.getContainers(0).getMServer();
                MfsServerInfo mfsServerInfo = new MfsServerInfo(mfsServer);
                MfsClient mc = MapRClient.this.mfsClientCache.get(mfsServerInfo);
                if (mc == null) {
                    mc = new MfsClient(MapRClient.this, mfsServer, MapRClient.this.isSecure());
                    mc.start();
                    while (!mc.isStarted()) {
                    }
                    MapRClient.this.mfsClientCache.put(mfsServerInfo, mc);
                }
                return mc;
            }
        });
        this.fidCache = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<String, Fid>(){

            public Fid load(String path) throws Exception {
                Fid pathFid = MapRClient.this.doPathWalk(path, null);
                return pathFid;
            }
        });
        this.tabletMapCache = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<Fid, RangeMap<ByteBuf, Fid>>(){

            public RangeMap<ByteBuf, Fid> load(Fid tableFidWrapper) throws Exception {
                TreeRangeMap tabletMap = TreeRangeMap.create();
                TabletScanner.populateTabletMap(MapRClient.this, tableFidWrapper, (RangeMap<ByteBuf, Fid>)tabletMap, null, MapRClient.this.reverseTabletMap);
                return tabletMap;
            }
        });
        this.tableSchemaCache = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<Fid, TableSchemaEntry>(){

            public TableSchemaEntry load(Fid tableFid) throws Exception {
                Dbserver.GetTableSchemaResponse tableSchema = MapRClient.this.getTableSchema(tableFid);
                TableSchemaEntry schemaEntry = new TableSchemaEntry(tableSchema);
                return schemaEntry;
            }
        });
    }

    @Override
    public Deferred<Object> start() {
        this.cldbClient.start();
        this.flushTimer.scheduleAtFixedRate((TimerTask)new TimedFlush(), 0L, (long)Constant.FLUSH_INTERVAL_MILLISECONDS);
        logger.debug("MapRClient started.");
        this.isStarted = true;
        return null;
    }

    @Override
    public Deferred<Object> stop() {
        this.flushLock.lock();
        try {
            this.flushComplete.await();
            TimeUnit.MILLISECONDS.sleep(Constant.FLUSH_INTERVAL_MILLISECONDS);
            this.flushComplete.await();
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
        this.flushLock.unlock();
        this.flushTimer.cancel();
        this.cidCache.invalidateAll();
        Collection<MfsClient> mfsClientList = this.mfsClientCache.values();
        for (MfsClient mc : mfsClientList) {
            if (!mc.isStarted()) continue;
            mc.stop();
        }
        this.mfsClientCache.clear();
        this.fidCache.invalidateAll();
        this.tabletMapCache.invalidateAll();
        this.tableSchemaCache.invalidateAll();
        Cleanup.Cleaner.stop(this.cldbClient).shutdownGracefully(this.clientEventLoopGroup).shutdownGracefully(this.serverEventLoopGroup);
        this.isStarted = false;
        return null;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public CldbClient getCldbClient() {
        return this.cldbClient;
    }

    public Security.CredentialsMsg getCredentials() {
        return this.myCreds;
    }

    public Common.SetattrMsg getAttributes() {
        return this.myAttr;
    }

    public int nextEpoh() {
        return this.rpcBindingEpoh.incrementAndGet();
    }

    public synchronized EventLoopGroup getClientEventLoopGroup() {
        if (this.clientEventLoopGroup == null) {
            this.clientEventLoopGroup = NettyHelper.createEventLoopGroup("MapRRpcClient-", Config.getRpcClientNumThreads());
        }
        return this.clientEventLoopGroup;
    }

    public synchronized EventLoopGroup getServerEventLoopGroup() {
        if (this.serverEventLoopGroup == null) {
            this.serverEventLoopGroup = NettyHelper.createEventLoopGroup("MapRRpcServer-", Config.getRpcServerNumThreads());
        }
        return this.serverEventLoopGroup;
    }

    public boolean isSecure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTable(Fid tableFid) throws Exception {
        MapRClient mapRClient = this;
        synchronized (mapRClient) {
            this.tabletMapCache.get((Object)tableFid);
            this.tableSchemaCache.get((Object)tableFid);
        }
    }

    @Override
    public Table getTable(String tablePath) throws MapRClientException {
        try {
            Fid tableFid = this.doPathWalk(tablePath, null);
            this.initializeTable(tableFid);
            return new TableImpl(this, tableFid);
        }
        catch (Exception e) {
            throw new MapRClientException(e);
        }
    }

    @Override
    public Table createTable(String tablePath) throws MapRClientException {
        try {
            Dbserver.TableCreateResponse tresp = this.tableCreate(tablePath, true);
            Fid tableFid = new Fid(tresp.getChild());
            this.createColumnFamily("default", tableFid);
            this.initializeTable(tableFid);
            return new TableImpl(this, tableFid);
        }
        catch (Exception e) {
            throw new MapRClientException(e);
        }
    }

    public MfsClient getMfsClientFromContainerId(int containerId) throws Exception {
        return (MfsClient)this.cidCache.get((Object)containerId);
    }

    public Fid getRootFid() throws Exception {
        CLDBProto.ContainerRootLookupResponse cresp = (CLDBProto.ContainerRootLookupResponse)this.cldbClient.containerRootLookup("mapr.cluster.root").join();
        int containerId = cresp.getContainer().getContainerId();
        Common.FidMsg rootFid = Common.FidMsg.newBuilder().setCid(containerId).setCinum(16).setUniq(2).build();
        return new Fid(rootFid);
    }

    public Fid doPathWalk(String filePath, Fid startFid) throws Exception {
        MfsClient mc;
        Fileserver.PathWalkPlusResponse presp;
        Fid reqFid = startFid;
        if (startFid == null) {
            reqFid = this.getRootFid();
        }
        if ((presp = (Fileserver.PathWalkPlusResponse)(mc = this.getMfsClientFromContainerId(reqFid.getCid())).pathWalkPlus(filePath, reqFid).join()).getPstatus() == Fileserver.PathWalkStatus.WalkDone) {
            return new Fid(presp.getPresult(0).getNode());
        }
        throw new UnsupportedOperationException("Unable to complete path walk");
    }

    public Fileserver.UnlinkResponse unlink(String filePath) throws Exception {
        Fid parentFid = this.getParentFid(filePath);
        MfsClient mc = this.getMfsClientFromContainerId(parentFid.getCid());
        String fileName = Misc.getNameFromPath(filePath);
        Fileserver.UnlinkResponse uresp = (Fileserver.UnlinkResponse)mc.unlink(fileName, parentFid).join();
        return uresp;
    }

    private Fid getParentFid(String filePath) throws Exception {
        String parentPath = Misc.getParentPath(filePath);
        Fid parentFid = (Fid)this.fidCache.get((Object)Paths.get(parentPath, new String[0]).normalize().toString());
        return parentFid;
    }

    public Fileserver.GetattrResponse getAttr(Fid fileFid) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(fileFid.getCid());
        Fileserver.GetattrResponse resp = (Fileserver.GetattrResponse)mc.getattr(fileFid).join();
        return resp;
    }

    private Dbserver.TableCreateResponse tableCreate(String tablePath, boolean isJson) throws Exception {
        String tableName = Misc.getNameFromPath(tablePath);
        Fid parentFid = this.getParentFid(tablePath);
        MfsClient mc = this.getMfsClientFromContainerId(parentFid.getCid());
        Dbserver.TableCreateResponse tresp = (Dbserver.TableCreateResponse)mc.tableCreate(tableName, parentFid, isJson).join();
        return tresp;
    }

    public Dbserver.ColumnFamilyScanResponse columnFamilyScan(Fid tableFid) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(tableFid.getCid());
        Dbserver.ColumnFamilyScanResponse cfResp = (Dbserver.ColumnFamilyScanResponse)mc.columnFamilyScan(tableFid).join();
        return cfResp;
    }

    private Dbserver.GetTableSchemaResponse getTableSchema(Fid tableFid) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(tableFid.getCid());
        Dbserver.GetTableSchemaResponse scResp = (Dbserver.GetTableSchemaResponse)mc.getTableSchema(tableFid).join();
        return scResp;
    }

    private Dbserver.ColumnFamilyCreateResponse createColumnFamily(String cfName, Fid tableFid) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(tableFid.getCid());
        return (Dbserver.ColumnFamilyCreateResponse)mc.columnFamilyCreate(cfName, tableFid).join();
    }

    public Dbserver.TabletLookupResponse lookupTablet(String key, Fid tableFid, int numTablets) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(tableFid.getCid());
        Dbserver.TabletLookupResponse tresp = (Dbserver.TabletLookupResponse)mc.tabletLookup(tableFid, Unpooled.wrappedBuffer((ByteBuffer)IdCodec.encode((String)key)), numTablets).join();
        return tresp;
    }

    private Deferred<Dbserver.PutResponse> putRequest(Fid tabletFid, long schemaVersion, Iterable<Dbserver.CompressedRow> compRowList, ByteBuf payload) throws Exception {
        MfsClient mc = this.getMfsClientFromContainerId(tabletFid.getCid());
        return mc.put(tabletFid, schemaVersion, compRowList, payload);
    }

    private PutWrapper buildPutWrapper(int cfId, ByteBuf putKey, ByteBuf rowValue, ByteString tableUuid) {
        CompositeByteBuf payLoadBuf = Unpooled.compositeBuffer().addComponents(new ByteBuf[]{putKey, rowValue});
        payLoadBuf.writerIndex(putKey.writerIndex() + rowValue.writerIndex());
        ByteReader payLoad = ByteBufReader.wrap((ByteBuf)payLoadBuf).setOrder(ByteOrder.LITTLE_ENDIAN);
        Dbserver.CompressedRow crow = Dbserver.CompressedRow.newBuilder().setTimestamp(System.currentTimeMillis()).addUuids(tableUuid).setCompressedKeyLength(putKey.readableBytes()).setPayloadLength(payLoadBuf.readableBytes()).setCrc(Crypto.computeXorCrc32Unalign((ByteReader)payLoad)).addFamilies(cfId - 1, Dbserver.FamilyValueIndex.newBuilder().setId(cfId).setLength(rowValue.readableBytes()).build()).build();
        PutWrapper putWrapper = new PutWrapper(crow, payLoadBuf);
        return putWrapper;
    }

    private void addPutReqToQueue(Fid tabletFid, ByteBuf rowKey, PutWrapper putWrapper) {
        TabletMapEntry tmEntry = null;
        if (this.tabletInfo.containsKey(tabletFid)) {
            tmEntry = this.tabletInfo.get(tabletFid);
        } else {
            tmEntry = new TabletMapEntry();
            this.tabletInfo.put(tabletFid, tmEntry);
        }
        tmEntry.acquireReadLock();
        ConcurrentSkipListMap<ByteBuf, PutWrapper> putQueue = tmEntry.getPutQueue();
        putQueue.put(rowKey, putWrapper);
        tmEntry.releaseReadLock();
    }

    public Deferred<Dbserver.PutResponse> submitPutReq(Fid tableFid, String columnFamilyName, ByteBuf rowKey, ByteBuf rowValue) throws Exception {
        Fid tabletFid = (Fid)((RangeMap)this.tabletMapCache.get((Object)tableFid)).get((Comparable)rowKey);
        int columnFamilyId = ((TableSchemaEntry)this.tableSchemaCache.get((Object)tableFid)).getColumnFamilyId(columnFamilyName);
        PutWrapper putWrapper = this.buildPutWrapper(columnFamilyId, rowKey, rowValue, ((TableSchemaEntry)this.tableSchemaCache.get((Object)tableFid)).getTableSchema().getUuid());
        this.addPutReqToQueue(tabletFid, rowKey, putWrapper);
        return putWrapper.getDeferred();
    }

    private void flushPutQueue(Fid tabletFid) throws Exception {
        TabletMapEntry tmEntry = this.tabletInfo.get(tabletFid);
        if (tmEntry.getPutQueue().size() == 0) {
            return;
        }
        tmEntry.swapFlushSkipLists();
        CompositeByteBuf payload = Unpooled.compositeBuffer();
        ArrayList<Dbserver.CompressedRow> compRowList = new ArrayList<Dbserver.CompressedRow>();
        ConcurrentSkipListMap<ByteBuf, PutWrapper> putQueue = tmEntry.getFlushQueue();
        Collection<PutWrapper> putWrapperList = putQueue.values();
        int writeIndex = 0;
        for (PutWrapper putWrapper : putWrapperList) {
            CompositeByteBuf buf = putWrapper.getPutPayload();
            writeIndex += buf.writerIndex();
            payload.addComponent((ByteBuf)buf);
            compRowList.add(putWrapper.getCompressedRow());
        }
        payload.writerIndex(writeIndex);
        Fid tableFid = this.reverseTabletMap.get(tabletFid);
        long schemaVersion = ((TableSchemaEntry)this.tableSchemaCache.get((Object)tableFid)).getTableSchema().getVersion();
        Deferred<Dbserver.PutResponse> deferred = this.putRequest(tabletFid, schemaVersion, compRowList, (ByteBuf)payload.retain());
        for (PutWrapper putWrapper : putWrapperList) {
            deferred.chain(putWrapper.getDeferred());
        }
        putQueue.clear();
    }

    private class TimedFlush
    extends TimerTask {
        private TimedFlush() {
        }

        @Override
        public void run() {
            MapRClient.this.flushLock.lock();
            Set tableFidList = MapRClient.this.tabletInfo.keySet();
            for (Fid tabletFidWrapper : tableFidList) {
                try {
                    MapRClient.this.flushPutQueue(tabletFidWrapper);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            MapRClient.this.flushComplete.signal();
            MapRClient.this.flushLock.unlock();
        }
    }
}

