/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.clients;

import com.mapr.client.impl.Cluster;
import com.mapr.client.impl.MapRClient;
import com.mapr.client.impl.msgs.ContainerLookupMsg;
import com.mapr.client.impl.msgs.ContainerRootLookupMsg;
import com.mapr.client.impl.msgs.IsCldbMasterMsg;
import com.mapr.client.impl.rpc.RpcClient;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.stumbleupon.async.Deferred;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CldbClient
extends RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(CldbClient.class);

    public CldbClient(MapRClient mapRClient, Cluster cluster) {
        super(mapRClient, cluster.getCldbHosts(), cluster.isSecure());
    }

    @Override
    public Deferred<Object> startClient() {
        return null;
    }

    @Override
    public Deferred<Object> stopClient() {
        logger.debug("{} stopped", (Object)this.getClass().getSimpleName());
        return null;
    }

    public Deferred<CLDBProto.isCLDBMasterResponse> getCLDBMaster() throws InterruptedException, Exception {
        return this.sendRequest(new IsCldbMasterMsg());
    }

    public Deferred<CLDBProto.ContainerRootLookupResponse> containerRootLookup(String rootPath) throws InterruptedException, Exception {
        return this.sendRequest(new ContainerRootLookupMsg(rootPath, this.mapRClient.getCredentials()));
    }

    public Deferred<CLDBProto.ContainerLookupResponse> containerLookup(int containerId) throws InterruptedException, Exception {
        return this.sendRequest(new ContainerLookupMsg(containerId, this.mapRClient.getCredentials()));
    }
}

