/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.google.common.base.Preconditions;
import com.mapr.client.impl.MapRClient;
import com.mapr.client.impl.rpc.RpcBinding;
import com.mapr.client.impl.rpc.RpcConnection;
import com.mapr.client.impl.rpc.RpcMessage;
import com.mapr.client.impl.rpc.ServiceHosts;
import com.stumbleupon.async.Deferred;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcClient
extends RpcBinding {
    private static final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    protected final ServiceHosts serviceHosts;
    protected RpcConnection connection;

    protected RpcClient(MapRClient maprClient, ServiceHosts serviceHosts, boolean isSecure) {
        super(maprClient);
        this.serviceHosts = serviceHosts;
        this.connection = new RpcConnection(this);
        logger.debug("{} created.", (Object)this.getClass().getSimpleName());
    }

    @Override
    public final void startBinding() {
        this.connection.connect(this.serviceHosts);
        this.startClient();
    }

    @Override
    protected void stopBinding() {
        this.stopClient();
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected Deferred<Object> startClient() {
        return null;
    }

    protected Deferred<Object> stopClient() {
        return null;
    }

    public Deferred<? extends Object> sendRequest(RpcMessage msg) {
        Preconditions.checkState((!msg.isBuilt() ? 1 : 0) != 0, (Object)"Attempt to resend a message!!!");
        msg.setEpoch(this.epoch).setCallId(this.nextCallId()).setConnId(this.connection.getConnId()).setSequenceId(this.connection.nextSequenceId()).build();
        return this.connection.send(msg);
    }
}

