/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.mapr.client.impl.memory.Allocator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.ByteOrder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMsgLengthDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RpcMsgLengthDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isOpen()) {
            if (in.readableBytes() > 0) {
                logger.info("Channel is closed, discarding remaining {} byte(s) in buffer.", (Object)in.readableBytes());
            }
            in.skipBytes(in.readableBytes());
            return;
        }
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        ByteBuf buff = in.order(ByteOrder.BIG_ENDIAN);
        int length = buff.readInt();
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        ByteBuf outBuf = Allocator.buffer(length);
        outBuf.writeBytes(in, in.readerIndex(), length);
        in.skipBytes(length);
        out.add(outBuf);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }
}

