/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.util;

import com.mapr.client.impl.LifeCycle;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cleanup {
    private static final Logger logger = LoggerFactory.getLogger(Cleanup.class);
    public static final Cleanup Cleaner = new Cleanup();

    private Cleanup() {
    }

    public Cleanup stop(LifeCycle object) {
        if (object != null) {
            try {
                object.stop();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public Cleanup close(AutoCloseable object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public Cleanup close(Channel object) {
        if (object != null) {
            try {
                object.close().sync();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public Cleanup shutdownGracefully(EventLoopGroup object) {
        if (object != null) {
            try {
                object.shutdownGracefully(0L, Long.MAX_VALUE, TimeUnit.MILLISECONDS).sync();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }
}

