/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl;

import com.mapr.fs.proto.Common;

public class MfsServerInfo {
    private Common.Server mfsServer;

    public MfsServerInfo(Common.Server mfsServer) {
        this.mfsServer = mfsServer;
    }

    public static boolean ipBelongsToServer(Common.Server server1, Common.Server server2) {
        for (Common.IPAddress ip1 : server1.getIpsList()) {
            for (Common.IPAddress ip2 : server2.getIpsList()) {
                if (ip1.getHost() != ip2.getHost()) continue;
                if (ip1.getPort() == ip2.getPort()) {
                    return true;
                }
                for (Integer sport : server2.getSecondaryPortsList()) {
                    if (ip1.getPort() != sport.intValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MfsServerInfo)) {
            return false;
        }
        MfsServerInfo s = (MfsServerInfo)o;
        return MfsServerInfo.ipBelongsToServer(this.mfsServer, s.mfsServer);
    }

    public int hashCode() {
        int serverId = (int)this.mfsServer.getServerId();
        return serverId;
    }
}

