/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class SimpleConsumer {
    public static String streamName = null;
    public static KafkaConsumer<byte[], byte[]> consumer;
    public static int waitBetweenScr;
    public static String consumerGroupId;

    public static void usage() {
        System.err.println("DemoConsumer -path <topic-full-name> [-groupid <group.id>]");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        Properties props;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                if (++i >= args.length) {
                    SimpleConsumer.usage();
                }
                streamName = args[i];
                System.out.println("Starting consumer on " + args[i]);
                continue;
            }
            if (args[i].equals("-groupid")) {
                if (++i >= args.length) {
                    SimpleConsumer.usage();
                }
                consumerGroupId = args[i];
                continue;
            }
            SimpleConsumer.usage();
        }
        if (streamName == null || streamName.length() == 0) {
            SimpleConsumer.usage();
        }
        if ((props = new Properties()).getProperty("bootstrap.servers") == null) {
            props.put("bootstrap.servers", "localhost:9092");
        }
        if (props.getProperty("key.deserializer") == null) {
            props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        }
        if (props.getProperty("value.deserializer") == null) {
            props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        }
        if (props.getProperty("auto.offset.reset") == null) {
            props.put("auto.offset.reset", "earliest");
        }
        if (consumerGroupId != null && props.getProperty("group.id") == null) {
            props.put("group.id", consumerGroupId);
        }
        System.out.println("starting consumer on topic " + streamName + " group.id " + consumerGroupId);
        consumer = new KafkaConsumer(props);
        SimpleConsumer.consumeTransactions();
    }

    public static void consumeTransactions() {
        ArrayList<String> streamNames = new ArrayList<String>();
        streamNames.add(streamName);
        try {
            consumer.subscribe(streamNames);
            long total = 0L;
            block2: while (true) {
                ConsumerRecords crecs = consumer.poll(1000L);
                Iterator iter = crecs.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    ConsumerRecord crec = (ConsumerRecord)iter.next();
                    byte[] key = (byte[])crec.key();
                    byte[] value = (byte[])crec.value();
                    String keyStr = new String(key);
                    String valStr = new String(value);
                    System.out.println("rec " + total + " key " + keyStr + " value " + valStr);
                    ++total;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Consumer failed");
            return;
        }
    }

    static {
        waitBetweenScr = 60000;
        consumerGroupId = null;
    }
}

