/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.demo;

import com.mapr.baseutils.BinaryString;
import com.mapr.db.cdc.impl.ChangeDataReaderImpl;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeDataRecord;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.types.OTimestamp;

public class TestChgLogConsumerJson {
    public static List<String> streamNames = new ArrayList<String>();
    public static KafkaConsumer<byte[], ChangeDataRecord> consumer;
    public static String consumerConfig;
    public static String consumerType;
    public static int waitBetweenScr;

    public static void usage() {
        System.err.println("TestChgLogConsumerJson -path <topic-full-name> -consumerConfig <configfile>");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                String[] tmp;
                if (++i >= args.length) {
                    TestChgLogConsumerJson.usage();
                }
                for (String oneName : tmp = args[i].split(",")) {
                    streamNames.add(oneName);
                }
                System.out.println("Starting consumer on " + args[i]);
                continue;
            }
            if (args[i].equals("-type")) {
                if (++i >= args.length) {
                    TestChgLogConsumerJson.usage();
                }
                consumerType = args[i];
                continue;
            }
            if (args[i].equals("-consumerConfig")) {
                if (++i >= args.length) {
                    TestChgLogConsumerJson.usage();
                }
                consumerConfig = args[i];
                continue;
            }
            TestChgLogConsumerJson.usage();
        }
        if (streamNames.size() == 0) {
            TestChgLogConsumerJson.usage();
        }
        if (consumerType == null) {
            consumerType = new String("chglog");
        }
        System.out.println("starting a " + consumerType + " consumer");
        Properties props = new Properties();
        if (consumerConfig != null) {
            props.load(new FileInputStream(consumerConfig));
        }
        if (props.getProperty("bootstrap.servers") == null) {
            props.put("bootstrap.servers", "localhost:9092");
        }
        if (props.getProperty("key.deserializer") == null) {
            props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        }
        if (props.getProperty("value.deserializer") == null) {
            props.put("value.deserializer", "com.mapr.streams.ChangeDataRecordDeserializer");
        }
        consumer = new KafkaConsumer(props);
        TestChgLogConsumerJson.consumeTransactions();
    }

    public static void printChangeDataThroughIter(ChangeDataRecord cdr) {
        Iterator cdrItr = cdr.iterator();
        int count = 0;
        while (cdrItr.hasNext()) {
            Map.Entry cdEntry = (Map.Entry)cdrItr.next();
            FieldPath fpName = (FieldPath)cdEntry.getKey();
            ChangeNode cd = (ChangeNode)cdEntry.getValue();
            System.out.println("node" + count + ": field:" + fpName + ", value:" + cd.toString());
            ++count;
        }
    }

    public static void printChangeDataThroughReader(ChangeDataRecord cdr) {
        ChangeDataReaderImpl reader = (ChangeDataReaderImpl)cdr.getReader();
        ChangeNodeImpl cd = null;
        int count = 0;
        while (reader.next() != null) {
            cd = reader.getChangeNode();
            System.out.println("node" + count + ":" + cd.toStringWithArrayIndexTime());
            ++count;
        }
    }

    public static void consumeTransactions() {
        try {
            consumer.subscribe(streamNames);
            int totalnum = 0;
            block2: while (true) {
                ConsumerRecords crecs = consumer.poll(1000L);
                Iterator iter = crecs.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    ConsumerRecord crec = (ConsumerRecord)iter.next();
                    byte[] key = (byte[])crec.key();
                    ChangeDataRecordImpl value = (ChangeDataRecordImpl)crec.value();
                    System.out.println("---" + (value.isJson() ? "Json" : "Binary") + " record" + totalnum + "\nkey(" + (Value.Type.STRING == value.getId().getType() ? "STRING" : "BINARY") + ":" + (Value.Type.STRING == value.getId().getType() ? value.getId().getString() : BinaryString.toStringBinary((byte[])value.getId().getBinary().array())) + ")  type(" + value.getType().name() + ") optime(" + value.getOpTimestamp() + " " + new OTimestamp(value.getOpTimestamp()) + ")");
                    System.out.println("--- print changenode through reader ---");
                    TestChgLogConsumerJson.printChangeDataThroughReader((ChangeDataRecord)value);
                    System.out.println("--- print changenode through iterator---");
                    TestChgLogConsumerJson.printChangeDataThroughIter((ChangeDataRecord)value);
                    ++totalnum;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Consumer failed");
            return;
        }
    }

    static {
        consumerConfig = null;
        consumerType = null;
        waitBetweenScr = 60000;
    }
}

