/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.demo;

import com.mapr.baseutils.BinaryString;
import com.mapr.fs.proto.Dbserver;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ChgLogConsumer {
    public static List<String> streamNames = new ArrayList<String>();
    public static KafkaConsumer consumer;
    public static String consumerConfig;
    public static String consumerType;
    public static int waitBetweenScr;

    public static void usage() {
        System.err.println("ChgLogConsumer -path <topic-full-name> -consumerConfig <configfile>");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                String[] tmp;
                if (++i >= args.length) {
                    ChgLogConsumer.usage();
                }
                for (String oneName : tmp = args[i].split(",")) {
                    streamNames.add(oneName);
                }
                System.out.println("Starting consumer on " + args[i]);
                continue;
            }
            if (args[i].equals("-type")) {
                if (++i >= args.length) {
                    ChgLogConsumer.usage();
                }
                consumerType = args[i];
                continue;
            }
            if (args[i].equals("-consumerConfig")) {
                if (++i >= args.length) {
                    ChgLogConsumer.usage();
                }
                consumerConfig = args[i];
                continue;
            }
            ChgLogConsumer.usage();
        }
        if (streamNames.size() == 0) {
            ChgLogConsumer.usage();
        }
        if (consumerType == null) {
            consumerType = new String("chglog");
        }
        System.out.println("starting a " + consumerType + " consumer");
        Properties props = new Properties();
        if (consumerConfig != null) {
            props.load(new FileInputStream(consumerConfig));
        }
        if (props.getProperty("bootstrap.servers") == null) {
            props.put("bootstrap.servers", "localhost:9092");
        }
        if (props.getProperty("key.deserializer") == null) {
            props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        }
        if (props.getProperty("value.deserializer") == null) {
            props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        }
        consumer = new KafkaConsumer(props);
        ChgLogConsumer.consumeTransactions();
    }

    public static void consumeTransactions() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss,SSS");
        int numStreams = streamNames.size();
        int currentStream = 0;
        try {
            consumer.subscribe(streamNames);
            currentStream = numStreams;
            int totalnum = 0;
            block2: while (true) {
                ConsumerRecords crecs = consumer.poll(1000L);
                Iterator iter = crecs.iterator();
                long currentTime = System.currentTimeMillis();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    ConsumerRecord crec = (ConsumerRecord)iter.next();
                    byte[] key = (byte[])crec.key();
                    byte[] value = (byte[])crec.value();
                    ByteBuffer recvecbuf = ByteBuffer.wrap(value);
                    recvecbuf.order(ByteOrder.LITTLE_ENDIAN);
                    int rawChangeDataLength = recvecbuf.getInt();
                    int iovectorLength = recvecbuf.getInt();
                    if (recvecbuf.position() + rawChangeDataLength + iovectorLength != value.length) {
                        throw new Exception("Wrong value length. It should be " + (recvecbuf.position() + rawChangeDataLength + iovectorLength) + ", but received " + value.length);
                    }
                    byte[] rawChangeDataBytes = Arrays.copyOfRange(value, recvecbuf.position(), recvecbuf.position() + rawChangeDataLength);
                    ByteBuffer valueBuf = ByteBuffer.wrap(value, recvecbuf.position() + rawChangeDataLength, iovectorLength);
                    Dbserver.RawChangeData rdata = Dbserver.RawChangeData.parseFrom((byte[])rawChangeDataBytes);
                    if (rdata.hasIsJson() && rdata.getIsJson()) {
                        System.out.println(totalnum + ": Json key(" + BinaryString.toStringBinary((byte[])key) + ") value(" + BinaryString.toStringBinary((byte[])value) + ")");
                    } else {
                        System.out.println(totalnum + ": Binary key(" + BinaryString.toStringBinary((byte[])key) + ") value(" + BinaryString.toStringBinary((byte[])value) + ")");
                    }
                    ++totalnum;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Consumer failed");
            return;
        }
    }

    static {
        consumerConfig = null;
        consumerType = null;
        waitBetweenScr = 60000;
    }
}

