/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.proto.Dbserver;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDataUtil {
    public static final long LATEST_TIMESTAMP = Long.MAX_VALUE;
    public static final long OLDEST_TIMESTAMP = Long.MIN_VALUE;
    public static final int ALL_VERSIONS = Integer.MAX_VALUE;
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataUtil.class);

    public static MapRResult genMapRResult(ByteBuffer valuebuf, Dbserver.CompressedRow crow, boolean isJson) throws IllegalArgumentException {
        MapRResult result = new MapRResult();
        int nFamilies = crow.getFamiliesCount();
        int fOffset = crow.getCompressedKeyLength();
        result.keyLength = crow.getCompressedKeyLength();
        if (!crow.hasTimestamp()) {
            throw new IllegalArgumentException("Missing row default timestamp!");
        }
        result.rowTs = crow.getTimestamp();
        if (crow.hasIsDelete() && crow.getIsDelete()) {
            result.isDelete = true;
            result.familyOffsets = null;
            if (!crow.hasRowdelEntryTimestamp()) {
                throw new IllegalArgumentException("Missing row delete timestamp!");
            }
            result.deleteTs = crow.getRowdelEntryTimestamp();
        } else {
            result.familyOffsets = new int[nFamilies];
            result.cfIds = new int[nFamilies];
            List fviList = crow.getFamiliesList();
            for (int f = 0; f < nFamilies; ++f) {
                Dbserver.FamilyValueIndex fvi = (Dbserver.FamilyValueIndex)fviList.get(f);
                result.familyOffsets[f] = fOffset;
                fOffset += fvi.getLength();
                result.cfIds[f] = fvi.getId();
            }
        }
        ByteBuffer iovecBuf = valuebuf.slice();
        if (fOffset != iovecBuf.remaining()) {
            throw new IllegalArgumentException("Invalid offset in deserialize family offset fOffset(" + fOffset + ") should be same as iovecBuf.remaining(" + iovecBuf.remaining() + ")");
        }
        result.bufSize = iovecBuf.remaining();
        result.bufBytes = new byte[iovecBuf.remaining()];
        iovecBuf.get(result.bufBytes, 0, iovecBuf.remaining());
        return result;
    }
}

