/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.tests;

import com.mapr.db.JsonTable;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.cdc.tests.TestCDPSCLIWithCluster;
import com.mapr.db.cdc.tests.TestCDPSUtil;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.KeyValue;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeDataRecord;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.ojai.store.exceptions.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestCDPSMisc
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCDPSMisc.class);
    private static AdminImpl testAdmin = null;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        System.out.println("--- On single node cluster without other workload, these tests takes total about 3 minutes, please wait ---\nTestCDPSMisc#testNull          ------ 3 minutes\nTestCDPSMisc#testJsonMutation  ------ 3 minutes\nTestCDPSMisc#testRecreatedChangelog ------ 5 minutes\nTestCDPSMisc#testLargeSrcRow  ------ 3 minutes\nTestCDPSMisc#testCtUtDt        ------ 3 minutes\n");
        testAdmin = (AdminImpl)MapRDBImpl.newAdmin();
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        testAdmin.close();
        System.out.println("Done!");
    }

    public static void verifyL1NullArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL2NullArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL1NullFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        System.out.println("-----input rec " + rec);
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL2NullFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname1, String fieldname2, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, fieldname1, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, fieldname2, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, fieldname1, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyL1DeleteArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, com.mapr.db.rowcol.KeyValue rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "c", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.MERGE, opTime, "c", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "c[0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, "c[1]", null);
        Assert.assertNull((Object)cd.getValue());
    }

    public static void verifyL2DeleteArrayThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, com.mapr.db.rowcol.KeyValue rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, "d", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.LessEqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.MERGE, opTime, "d", isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[1][0]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "d[1][1]", (Value)rec);
        Assert.assertTrue((cd.getType() == Value.Type.NULL ? 1 : 0) != 0);
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.LargerEqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, "d[1][2]", null);
        Assert.assertNull((Object)cd.getValue());
    }

    public static void verifyL1DeleteFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname, null);
        Assert.assertNull((Object)cd.getValue());
        Assert.assertNull((Object)cd.getType());
    }

    public static void verifyL2DeleteFieldThroughReader1(String strRowId, ChangeDataRecord cdr, String fieldname1, String fieldname2, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.MERGE, opTime, fieldname1, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname2, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.MERGE, opTime, fieldname1, isDebug);
        Assert.assertNull((Object)reader.getType());
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.MERGE, opTime, null, isDebug);
        Assert.assertNull((Object)reader.getType());
        Iterator cdrItr = cdr.iterator();
        cd = (ChangeNode)((KeyValue)cdrItr.next()).getValue();
        TestCDPSUtil.assertNodeEquals(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, opTime, fieldname1 + "." + fieldname2, null);
        Assert.assertNull((Object)cd.getValue());
        Assert.assertNull((Object)cd.getType());
    }

    public static void verifyInitNullDataThroughReader1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        ChangeDataReader reader = cdr.getReader();
        Object ndVal = null;
        long opTime = cdr.getOpTimestamp();
        ChangeNode cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "a0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_MAP, ChangeOp.SET, opTime, "b0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, "b1", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, "b0", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, "c", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.START_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsOjaiNull(reader, cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, null, isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_ARRAY, ChangeOp.SET, opTime, "d", isDebug);
        cd = TestCDPSUtil.moveToNextNodeReader(reader);
        TestCDPSUtil.assertNodeIsJavaNull(cd, TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.END_MAP, ChangeOp.SET, opTime, null, isDebug);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyInitDataThroughItr1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static void verifyMixedLegalIllegalFieldThroughItr1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.MERGE);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, "IntArray1[0]", null);
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "IntArray1[1]", rec.getValue("IntArray1[1]"));
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.SET, 0L, "IntArray1[2]", rec.getValue("IntArray1[2]"));
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, ChangeEvent.NODE, ChangeOp.DELETE, 0L, "L1FieldInt.noPath[0]", null);
    }

    public static void verifyInitLargeRowThroughItr1(String strRowId, ChangeDataRecord cdr, Document rec, boolean isDebug) throws IOException {
        if (isDebug) {
            TestCDPSUtil.printCDRec(cdr);
        }
        long opTime = cdr.getOpTimestamp();
        TestCDPSUtil.verifyHead(cdr, true, strRowId, TestCDPSUtil.OpTimeVerifyMethod.LargerThanGivenValue, 0L, ChangeOp.SET);
        Iterator cdrItr = cdr.iterator();
        TestCDPSUtil.assertNodeEquals((ChangeNode)((KeyValue)cdrItr.next()).getValue(), TestCDPSUtil.OpTimeVerifyMethod.EqualGivenValue, ChangeEvent.NODE, ChangeOp.SET, opTime, null, (Value)rec);
    }

    public static DocumentMutation getMutOfAppendField(String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.append(fpname, "dummy1");
        return mutation;
    }

    public static DocumentMutation getMutOfAppendArray(String fpname) throws IOException {
        ArrayList<String> listaddition = new ArrayList<String>();
        listaddition.add("dummy2");
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.append(fpname, listaddition);
        return mutation;
    }

    public static Document setFieldNull(Table jsonTable, String rowid, String fpname) throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        jsonTable.insertOrReplace(rowid, (Document)rec);
        return rec;
    }

    public static Document updateFieldNull(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setNull(fpname);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static Document setFieldBool(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.set(fpname, true);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static Document replaceFieldInt(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.setOrReplace(fpname, 111);
        jsonTable.update(rowid, mutation);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setNull(fpname);
        return rec;
    }

    public static void deleteField(Table jsonTable, String rowid, String fpname) throws IOException {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete(fpname);
        jsonTable.update(rowid, mutation);
    }

    public static void printChangeRec(ChangeDataRecord cdr) throws IOException {
        TestCDPSUtil.printChangeRecHeader(cdr);
        TestCDPSUtil.printChangeDataThroughReader(cdr);
        TestCDPSUtil.printChangeDataThroughIter(cdr);
    }

    public static void waitForBucketRepl(String tableName, String topicFullName) throws Exception {
        String[] colToVerify = new String[]{"replicaState"};
        String[] valToVerify = new String[]{"REPLICA_STATE_REPLICATING"};
        boolean inBucketReplication = false;
        int waitCount = 10;
        for (int i = 0; i < waitCount; ++i) {
            String listret = TestCDPSMisc.listCLG(tableName);
            _logger.info(listret);
            inBucketReplication = TestCDPSUtil.FindValueInCmdOutput(listret, topicFullName, colToVerify, valToVerify);
            if (inBucketReplication) break;
            Thread.sleep(3000L);
        }
        Assert.assertTrue((boolean)inBucketReplication);
    }

    @Test
    public void testNull() throws Exception {
        int RowCount = 10;
        String jsrc1 = "/tmp/jnullsrc1";
        String chglogdst1 = "/tmp/chglognulldst1";
        String topicFullName = chglogdst1 + ":jnullsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        DBDocumentImpl rec0 = new DBDocumentImpl();
        Object rowid = "row0";
        rec0 = new DBDocumentImpl();
        rec0.setNull("a0").setNull("b0.b1").setNull("c[1]").setNull("d[1][2]");
        jsonTable.insertOrReplace((String)rowid, (Document)rec0);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        for (int i = 1; i < RowCount; ++i) {
            rowid = "row" + i;
            rec1 = new DBDocumentImpl();
            rec1.set("a0", "a0val").set("b0.b1", "b0b1val").set("c[1]", "c1").set("d[1][2]", "d1d2");
            jsonTable.insertOrReplace((String)rowid, (Document)rec1);
        }
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = true;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            rowid = "row" + i;
            if (i == 0) {
                TestCDPSMisc.verifyInitNullDataThroughReader1((String)rowid, cdr, (Document)rec0, isDebug);
                continue;
            }
            TestCDPSMisc.verifyInitDataThroughItr1((String)rowid, cdr, (Document)rec1, isDebug);
        }
        ArrayList<Document> presetValues = new ArrayList<Document>();
        rowid = "row1";
        Document rec = TestCDPSMisc.setFieldNull((Table)jsonTable, (String)rowid, "a0");
        presetValues.add(rec);
        rowid = "row2";
        rec = TestCDPSMisc.setFieldNull((Table)jsonTable, (String)rowid, "b0.b1");
        presetValues.add(rec);
        rowid = "row3";
        rec = TestCDPSMisc.setFieldNull((Table)jsonTable, (String)rowid, "c[1]");
        presetValues.add(rec);
        rowid = "row4";
        rec = TestCDPSMisc.setFieldNull((Table)jsonTable, (String)rowid, "d[1][2]");
        presetValues.add(rec);
        rowid = "row5";
        rec = new DBDocumentImpl();
        rec.setNull("a0").setNull("b0.b1").setNull("c[1]").setNull("d[1][2]");
        presetValues.add(rec);
        jsonTable.insertOrReplace((String)rowid, rec);
        jsonTable.flush();
        rowid = "row1";
        TestCDPSMisc.deleteField((Table)jsonTable, (String)rowid, "a0");
        rowid = "row2";
        TestCDPSMisc.deleteField((Table)jsonTable, (String)rowid, "b0.b1");
        rowid = "row3";
        TestCDPSMisc.deleteField((Table)jsonTable, (String)rowid, "c[1]");
        rowid = "row4";
        TestCDPSMisc.deleteField((Table)jsonTable, (String)rowid, "d[1][2]");
        rowid = "row5";
        DocumentMutation mutation = MapRDBImpl.newMutation();
        mutation.delete("a0").delete("b0.b1").delete("c[1]").delete("d[1][2]");
        jsonTable.update((String)rowid, mutation);
        jsonTable.flush();
        int i = 0;
        getListScf = TestCDPSUtil.fetchChangeData(10, consumerScf);
        crec = getListScf.get(i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1NullFieldThroughReader1("row1", cdr, "a0", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2NullFieldThroughReader1("row2", cdr, "b0", "b1", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1NullArrayThroughReader1("row3", cdr, "c", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2NullArrayThroughReader1("row4", cdr, "d", rec, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        rec = (Document)presetValues.get(i);
        System.out.println("Expected Rec:" + rec + "\n Got:");
        TestCDPSMisc.printChangeRec(cdr);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1DeleteFieldThroughReader1("row1", cdr, "a0", isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2DeleteFieldThroughReader1("row2", cdr, "b0", "b1", isDebug);
        com.mapr.db.rowcol.KeyValue recval = new com.mapr.db.rowcol.KeyValue(Value.Type.NULL);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL1DeleteArrayThroughReader1("row3", cdr, "c[1]", recval, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        TestCDPSMisc.verifyL2DeleteArrayThroughReader1("row4", cdr, "d[1][2]", recval, isDebug);
        crec = getListScf.get(++i);
        cdr = (ChangeDataRecord)crec.value();
        TestCDPSMisc.printChangeRec(cdr);
        ++i;
        jsonTable.close();
    }

    public void putCDCThroughIter(String rowid, Table jsonTable, ChangeDataRecord cdrec) throws Exception {
        ChangeDataRecordImpl cdr = (ChangeDataRecordImpl)cdrec;
        Iterator cdrItr = cdr.iterator();
        int count = 0;
        while (cdrItr.hasNext()) {
            Map.Entry cdEntry = (Map.Entry)cdrItr.next();
            String fpName = ((FieldPath)cdEntry.getKey()).asPathString();
            ChangeNodeImpl cd = (ChangeNodeImpl)cdEntry.getValue();
            Document document = MapRDB.newDocument();
            document.set("cdcValueType", cd.getType().name());
            Value value = cd.getValue();
            if (value != null) {
                System.out.println("cdcValue: " + value.asJsonString());
                Document dA = MapRDB.newDocument();
                dA.set("value", value);
                Map mA = dA.asMap();
                document.set("cdcValue", dA);
            } else {
                document.set("cdcValue", "null");
            }
            DBDocumentImpl docimpl = (DBDocumentImpl)document;
            jsonTable.insertOrReplace(rowid + "-" + count, document);
            jsonTable.flush();
            ++count;
        }
    }

    public void verifyTimeThroughIter(List<Long> timelist, ChangeDataRecord cdrec) throws Exception {
        ChangeDataRecordImpl cdr = (ChangeDataRecordImpl)cdrec;
        Iterator cdrItr = cdr.iterator();
        int count = 0;
        while (cdrItr.hasNext()) {
            Map.Entry cdEntry = (Map.Entry)cdrItr.next();
            String fpName = ((FieldPath)cdEntry.getKey()).asPathString();
            ChangeNodeImpl cd = (ChangeNodeImpl)cdEntry.getValue();
            if (count < timelist.size()) {
                Assert.assertEquals((long)timelist.get(count), (long)cd.getServerTimestamp());
            } else {
                int index = timelist.size() - 1;
                long lasttimestamp = index > 0 ? timelist.get(index) : 0L;
                System.out.println(index + ":" + lasttimestamp + ", " + count + ":" + cd.getServerTimestamp());
                Assert.assertTrue((lasttimestamp <= cd.getServerTimestamp() ? 1 : 0) != 0);
                timelist.add(cd.getServerTimestamp());
            }
            ++count;
        }
    }

    public void verifyOrderThroughIter(String field, String val, ChangeDataRecord cdrec) throws Exception {
        ChangeDataRecordImpl cdr = (ChangeDataRecordImpl)cdrec;
        Iterator cdrItr = cdr.iterator();
        int count = 0;
        while (cdrItr.hasNext()) {
            Map.Entry cdEntry = (Map.Entry)cdrItr.next();
            String fpName = ((FieldPath)cdEntry.getKey()).asPathString();
            ChangeNodeImpl cd = (ChangeNodeImpl)cdEntry.getValue();
            String valStr = cd.getString();
            if (!fpName.equals(field) || !valStr.equals(valStr)) {
                System.out.println("Expecting field " + field + ", get " + fpName + ", value " + val + ", get " + valStr);
            }
            ++count;
        }
    }

    public static String listCLG(String tableName) throws Exception {
        String cmd = "maprcli table changelog list -refreshnow true -path " + tableName;
        return TestCluster.runCommand((String)cmd).getStdOut();
    }

    @Test
    public void testCopyRegion() throws Exception {
        int i;
        int i2;
        Object rowid;
        int RowCount1 = 400;
        int RowCount2 = 800;
        String jsrc1 = "/tmp/jcpsrc1";
        String chglogdst1 = "/tmp/chglogcpdst1";
        String topicFullName = chglogdst1 + ":jcpsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        boolean[] foundRow = new boolean[RowCount2];
        for (int i3 = 0; i3 < RowCount1; ++i3) {
            rowid = "row" + i3;
            rec1 = new DBDocumentImpl();
            rec1.set("field0", "value1-" + i3);
            jsonTable.insertOrReplace((String)rowid, (Document)rec1);
            foundRow[i3] = false;
        }
        jsonTable.flush();
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithPropagateexistingdata(jsrc1, chglogdst1, topicFullName, false, false);
        String[] colToVerify = new String[]{"replicaState"};
        String[] valToVerify = new String[]{"REPLICA_STATE_REPLICATING"};
        boolean inBucketReplication = false;
        int waitCount = 10;
        for (i2 = 0; i2 < waitCount; ++i2) {
            String listret = TestCDPSMisc.listCLG(jsrc1);
            _logger.info(listret);
            inBucketReplication = TestCDPSUtil.FindValueInCmdOutput(listret, topicFullName, colToVerify, valToVerify);
            if (inBucketReplication) break;
            Thread.sleep(3000L);
        }
        Assert.assertTrue((boolean)inBucketReplication);
        rec1 = new DBDocumentImpl();
        for (i2 = RowCount1; i2 < RowCount2; ++i2) {
            rowid = "row" + i2;
            rec1 = new DBDocumentImpl();
            rec1.set("field1", "value1-" + i2);
            jsonTable.insertOrReplace((String)rowid, (Document)rec1);
            foundRow[i2] = false;
        }
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        int bucketReplCount = RowCount2 - RowCount1;
        getListScf = TestCDPSUtil.fetchChangeData(bucketReplCount, consumerScf);
        Assert.assertEquals((long)bucketReplCount, (long)getListScf.size());
        for (i = 0; i < bucketReplCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            rowid = cdr.getId().getString();
            int ridx = Integer.parseInt(((String)rowid).substring(3));
            foundRow[ridx] = true;
        }
        for (i = 0; i < RowCount1; ++i) {
            Assert.assertEquals((Object)false, (Object)foundRow[i]);
        }
        for (i = RowCount1; i < RowCount2; ++i) {
            Assert.assertEquals((Object)true, (Object)foundRow[i]);
        }
        jsonTable.close();
    }

    @Test
    public void testRecreatedChangelog() throws Exception {
        int secs;
        String rowid;
        int RowCount1 = 4;
        int RowCount2 = 8;
        String jsrc1 = "/tmp/jsonRecreate1";
        String jsrc2 = "/tmp/jsonRecreate2";
        String chglogdst1 = "/tmp/chgRecreate1";
        String chglogdstNew1 = "/tmp/chgRecreateNew1";
        String topic1 = "jsonRecreate1";
        String topicFullName = chglogdst1 + ":" + topic1;
        Assert.assertEquals((Object)true, (Object)TestCDPSUtil.deleteStreamTable(jsrc1));
        Assert.assertEquals((Object)true, (Object)TestCDPSUtil.deleteStreamTable(jsrc2));
        Assert.assertEquals((Object)true, (Object)TestCDPSUtil.deleteStreamTable(chglogdst1));
        Assert.assertEquals((Object)true, (Object)TestCDPSUtil.deleteStreamTable(chglogdstNew1));
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        boolean[] foundRow = new boolean[RowCount2];
        for (int i = 0; i < RowCount1; ++i) {
            rowid = "row" + i;
            rec1 = new DBDocumentImpl();
            rec1.set("field0", "value1-" + i);
            jsonTable.insertOrReplace(rowid, (Document)rec1);
            foundRow[i] = false;
        }
        jsonTable.flush();
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithPropagateexistingdata(jsrc1, chglogdst1, topicFullName, false, true);
        String[] colToVerify = new String[]{"replicaState"};
        String[] valToVerify = new String[]{"REPLICA_STATE_REPLICATING"};
        boolean inBucketReplication = false;
        int waitCount = 20;
        for (int i = 0; i < waitCount; ++i) {
            String listret = TestCDPSMisc.listCLG(jsrc1);
            _logger.info(listret);
            inBucketReplication = TestCDPSUtil.FindValueInCmdOutput(listret, topicFullName, colToVerify, valToVerify);
            if (inBucketReplication) break;
            Thread.sleep(3000L);
        }
        Assert.assertTrue((boolean)inBucketReplication);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount1, consumerScf);
        Assert.assertEquals((long)RowCount1, (long)getListScf.size());
        Assert.assertEquals((long)0L, (long)TestCDPSCLIWithCluster.mvFile(chglogdst1, chglogdstNew1));
        Object cmd = null;
        String[] cmds = new String[]{"/bin/bash", "-c", "echo password | sudo -u mapr -S /opt/mapr/initscripts/mapr-gateway restart"};
        Process pb = Runtime.getRuntime().exec(cmds);
        pb.waitFor();
        int retcode = pb.exitValue();
        Assert.assertEquals((long)0L, (long)retcode);
        cmd = "/opt/mapr/initscripts/mapr-gateway status";
        retcode = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        _logger.info((String)cmd + " ==> return " + retcode);
        Assert.assertTrue((retcode == 0 ? 1 : 0) != 0);
        Thread.sleep(5000L);
        rec1 = new DBDocumentImpl();
        for (int i = RowCount1; i < RowCount2; ++i) {
            rowid = "row" + i;
            rec1 = new DBDocumentImpl();
            rec1.set("field1", "value1-" + i);
            jsonTable.insertOrReplace(rowid, (Document)rec1);
            foundRow[i] = false;
        }
        jsonTable.flush();
        boolean hasErr = false;
        String retstr = null;
        for (secs = 0; secs < 30; ++secs) {
            cmd = "maprcli table changelog list -refreshnow true -path " + jsrc1 + " -json";
            retstr = DBTests.ExecuteShellCmd((String)cmd);
            _logger.info(retstr);
            hasErr = retstr.contains("error");
            if (hasErr) break;
            Thread.sleep(5000L);
        }
        Assert.assertTrue((boolean)hasErr);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        hasErr = false;
        for (secs = 0; secs < 20; ++secs) {
            cmd = new String("maprcli table changelog list -refreshnow true -path " + jsrc1 + " -json");
            retstr = DBTests.ExecuteShellCmd((String)cmd);
            _logger.info(retstr);
            hasErr = retstr.contains("failed to get topic meta");
            if (hasErr) break;
            Thread.sleep(5000L);
        }
        Assert.assertTrue((boolean)hasErr);
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc2);
        TestCDPSUtil.setupCDPSReplicaWithPropagateexistingdata(jsrc2, chglogdst1, topicFullName, false, true);
        hasErr = false;
        for (secs = 0; secs < 20; ++secs) {
            cmd = new String("maprcli table changelog list -refreshnow true  -path " + jsrc1 + " -json");
            retstr = DBTests.ExecuteShellCmd((String)cmd);
            _logger.info(retstr);
            hasErr = retstr.contains("src differs");
            if (hasErr) break;
            Thread.sleep(5000L);
        }
        Assert.assertTrue((boolean)hasErr);
        consumerScf.close();
        jsonTable.close();
    }

    @Test
    public void testCtUtDt() throws Exception {
        int i;
        String rowid;
        int RowCount = 1;
        String jsrc1 = "/tmp/jctutdtsrc1";
        String chglogdst1 = "/tmp/chglogctutdtdst1";
        String topicFullName = chglogdst1 + ":jctutdtsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        TestCDPSMisc.waitForBucketRepl(jsrc1, topicFullName);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        int OpCount = 400;
        DBDocumentImpl rec1 = new DBDocumentImpl();
        for (int i2 = 0; i2 < RowCount; ++i2) {
            rowid = "row" + i2;
            rec1 = new DBDocumentImpl();
            rec1.set("ary1", Arrays.asList("a"));
            jsonTable.insertOrReplace(rowid, (Document)rec1);
        }
        ArrayList presetValues = new ArrayList();
        DocumentMutation mutation = null;
        for (int i3 = 0; i3 < RowCount; ++i3) {
            for (int j = 0; j < OpCount; ++j) {
                rowid = "row" + i3;
                mutation = MapRDBImpl.newMutation().append("ary1", Arrays.asList("b" + j));
                jsonTable.update(rowid, mutation);
            }
        }
        getListScf = TestCDPSUtil.fetchChangeData(RowCount * OpCount + RowCount, consumerScf);
        ArrayList<Long> timelist = new ArrayList<Long>();
        System.out.println("Inserted Rec:" + mutation + "\n Got:");
        for (i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            this.verifyTimeThroughIter(timelist, cdr);
        }
        System.out.println("Updated Rec:" + mutation + "\n Got:");
        for (i = 0; i < RowCount; ++i) {
            for (int j = 0; j < OpCount; ++j) {
                rowid = "row" + i;
                crec = getListScf.get(i * OpCount + j);
                cdr = (ChangeDataRecord)crec.value();
                this.verifyTimeThroughIter(timelist, cdr);
            }
        }
        jsonTable.close();
    }

    @Test
    public void testPutCDC2DB() throws Exception {
        int RowCount = 2;
        String jsrc1 = "/tmp/jputcdc1";
        String jsrc2 = "/tmp/jputcdc2";
        String chglogdst1 = "/tmp/chgputcdc1";
        String topicFullName = chglogdst1 + ":jputcdc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc2);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        JsonTable jsonTable2 = MapRDBImpl.getTable((String)jsrc2);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        String rowid = "row1";
        rec1 = new DBDocumentImpl();
        rec1.set("ary1", Arrays.asList("a"));
        jsonTable.insertOrReplace(rowid, (Document)rec1);
        rowid = "row2";
        rec1 = new DBDocumentImpl();
        rec1.set("field1", "value1");
        jsonTable.insertOrReplace(rowid, (Document)rec1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        TestCDPSMisc.waitForBucketRepl(jsrc1, topicFullName);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        ArrayList timelist = new ArrayList();
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            this.putCDCThroughIter("row" + i, (Table)jsonTable2, cdr);
        }
        rec1 = new DBDocumentImpl();
        rowid = "row3";
        rec1 = new DBDocumentImpl();
        rec1.set("ary1", Arrays.asList("a"));
        jsonTable.insertOrReplace(rowid, (Document)rec1);
        rowid = "row4";
        rec1 = new DBDocumentImpl();
        rec1.set("field1", "value1");
        jsonTable.insertOrReplace(rowid, (Document)rec1);
        ArrayList presetValues = new ArrayList();
        DocumentMutation mutation = null;
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        System.out.println("Updated Rec:" + mutation + "\n Got:");
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            this.putCDCThroughIter("row" + (2 + i), (Table)jsonTable2, cdr);
        }
        _logger.info("readback:");
        DocumentStream docStream = jsonTable2.find();
        for (Document document : docStream) {
            String id = document.getIdString();
            _logger.info(document.toString());
        }
        jsonTable.close();
        jsonTable2.close();
    }

    public static Document readPrint(String msg, Table jTable, String row) throws Exception {
        Document retdoc = jTable.findById(row);
        if (retdoc == null) {
            System.out.println(row + ":" + msg + "=> null");
        } else {
            System.out.println(row + ": " + msg + "=>\n" + retdoc.asJsonString());
        }
        return retdoc;
    }

    public static void compareAndPrint(String msg1, Table jTable1, String msg2, Table jTable2, String row) throws Exception {
        Document retdoc2;
        com.mapr.db.rowcol.KeyValue kv2;
        Document retdoc1 = TestCDPSMisc.readPrint(msg1, jTable1, row);
        com.mapr.db.rowcol.KeyValue kv1 = (com.mapr.db.rowcol.KeyValue)retdoc1;
        if (!kv1.equals((Object)(kv2 = (com.mapr.db.rowcol.KeyValue)(retdoc2 = TestCDPSMisc.readPrint(msg2, jTable2, row))))) {
            System.out.println(row + ": ERROR! => doc does not match!!!\n");
        }
    }

    public static ErrCodeMsg noThrowUpdate(Table jTable, String row, DocumentMutation mutation, ErrCodeMsg ecm) {
        ecm.set(0, null);
        try {
            jTable.update(row, mutation);
        }
        catch (StoreException e) {
            ecm.set(1, e.getMessage());
        }
        return ecm;
    }

    @Test
    public void testJsonMutation() throws Exception {
        int RowCount = 100;
        String jtbl1 = "/tmp/jmuttbl1";
        String jsrc1 = "/tmp/jmutsrc1";
        String chglogdst1 = "/tmp/chglogmutdst1";
        String topicFullName = chglogdst1 + ":jmutsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jtbl1);
        JsonTable jmutTable = MapRDBImpl.getTable((String)jtbl1);
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("L1FieldInt", 10).set("L1FieldStr", "L1FieldVal").set("Map1.L2FieldInt", 100).set("Map1.L2FieldStr", "L2FieldStrVal").setArray("IntArray1", new int[]{1, 2, 3}).setArray("StrArray1", new Object[]{"S1", "S2"});
        Object rowid = "row0";
        for (int i = 0; i < RowCount; ++i) {
            rowid = "row" + i;
            jmutTable.insertOrReplace((String)rowid, (Document)rec);
            jsonTable.insertOrReplace((String)rowid, (Document)rec);
        }
        jmutTable.flush();
        jsonTable.flush();
        System.out.println("====== Inserted " + (String)rowid + " to table " + jtbl1 + " and " + jsrc1 + "======");
        DocumentStream dstream1 = jmutTable.find();
        DocumentStream dstream2 = jsonTable.find();
        Iterator docs1 = dstream1.iterator();
        Iterator docs2 = dstream2.iterator();
        int count = 0;
        while (docs1.hasNext() && docs2.hasNext()) {
            Document doc2;
            Document doc1 = (Document)docs1.next();
            if (!doc1.equals(doc2 = (Document)docs2.next())) {
                System.out.println("==> ERROR: mismatch doc between table " + jtbl1 + " and " + jsrc1);
                System.out.println(doc1.asJsonString());
                System.out.println(doc2.asJsonString());
            } else {
                System.out.println(doc1.asJsonString());
            }
            ++count;
        }
        System.out.println("====== Readed " + count + " rows ======");
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        ChangeDataRecord cdr = null;
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        ArrayList timelist = new ArrayList();
        System.out.println("Expect " + RowCount + " inserted Rec:");
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
        }
        boolean isDebug = false;
        ErrCodeMsg retmsg1 = new ErrCodeMsg(0, null);
        ErrCodeMsg retmsg2 = new ErrCodeMsg(0, null);
        int succeedCount = 0;
        DocumentMutation mutation = MapRDBImpl.newMutation();
        rowid = "row1";
        mutation.set("L1FieldInt", 11);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set L1Field=11 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set L1Field=11 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row2";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("L1FieldInt", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: inc L1Field+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: inc L1Field+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row3";
        mutation = MapRDBImpl.newMutation();
        mutation.set("L1FieldInt", "abc");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set L1Field=abc " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set L1Field=abc " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row4";
        mutation = MapRDBImpl.newMutation();
        DBDocumentImpl mutmap = new DBDocumentImpl();
        mutmap.set("Field1", "Val1").set("Field2", "Val2");
        mutation.set("L1FieldInt", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal set L1Field={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal set L1Field={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row5";
        mutation = MapRDBImpl.newMutation();
        ArrayList<Integer> mutInts = new ArrayList<Integer>();
        mutInts.add(11);
        mutInts.add(22);
        mutation.set("L1FieldInt", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal set L1Field=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal set L1Field=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row6";
        mutation = MapRDBImpl.newMutation();
        mutation.append("L1FieldInt", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append L1Field+=[11,22]" + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append L1Field+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row7";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("L1FieldInt", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge L1Field+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge L1Field+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row8";
        mutation = MapRDBImpl.newMutation();
        mutation.set("IntArray1[1]", 11);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set IntArray1[1]=11 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set IntArray1[1]=11 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row9";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("IntArray1[1]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: inc IntArray1[1]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: inc IntArray1[1]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row10";
        mutation = MapRDBImpl.newMutation();
        mutation.set("IntArray1[1]", "abc");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: IntArray1[1]=abc " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: IntArray1[1]=abc " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row11";
        mutation = MapRDBImpl.newMutation();
        mutation.set("IntArray1[1]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal set IntArray1[1]={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal set IntArray1[1]={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row12";
        mutation = MapRDBImpl.newMutation();
        mutation.set("IntArray1[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal set IntArray1[1]=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal set IntArray1[1]=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row13";
        mutation = MapRDBImpl.newMutation();
        mutation.append("IntArray1[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append IntArray1[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append IntArray1[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row14";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("IntArray1[1]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge IntArray1[1]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge IntArray1[1]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row15";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set Map1={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set Map1={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row16";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set Map1+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set Map1+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row17";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row18";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set StrArray1=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set StrArray1=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row19";
        mutation = MapRDBImpl.newMutation();
        mutation.append("StrArray1", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal: set StrArray1+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal: set StrArray1+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row20";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set StrArray1={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set StrArray1={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row21";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1", 999);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1=999 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1=999 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row22";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: inc Map1+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: inc Map1+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row23";
        mutation = MapRDBImpl.newMutation();
        mutation.set("IntArray1", "abc");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: IntArray1=abc " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: IntArray1=abc " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row24";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("IntArray1", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal set IntArray1+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal set IntArray1+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row25";
        mutation = MapRDBImpl.newMutation();
        mutation.set("noPath", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set noPath=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set noPath=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row26";
        mutation = MapRDBImpl.newMutation();
        mutation.append("noPath", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append noPath+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append noPath+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row27";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("noPath", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row28";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("noPath", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set noPath+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set noPath+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row29";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("noPath");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete noPath " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete noPath " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row30";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1.noPath", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set Map1.noPath=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set Map1.noPath=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row31";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1.noPath", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append Map1.noPath+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append Map1.noPath+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row32";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1.noPath", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge Map1.noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge Map1.noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row33";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("Map1.noPath", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1.noPath+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1.noPath+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row34";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("Map1.noPath");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete Map1.noPath " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete Map1.noPath " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row35";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1.noPath", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set StrArray1.noPath=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set StrArray1.noPath=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row36";
        mutation = MapRDBImpl.newMutation();
        mutation.append("StrArray1.noPath", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append StrArray1.noPath+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append StrArray1.noPath+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row37";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("StrArray1.noPath", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge StrArray1.noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge StrArray1.noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row38";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("StrArray1.noPath", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set StrArray1.noPath+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set StrArray1.noPath+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row39";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("StrArray1.noPath");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete StrArray1.noPath " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete StrArray1.noPath " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row40";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1[5]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set StrArray1[5]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set StrArray1[5]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row41";
        mutation = MapRDBImpl.newMutation();
        mutation.append("StrArray1[5]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append StrArray1[5]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append StrArray1[5]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row42";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("StrArray1[5]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge StrArray1[5]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge StrArray1[5]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row43";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("StrArray1[5]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set StrArray1[5]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set StrArray1[5]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row44";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("StrArray1[5]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete StrArray1[5] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete StrArray1[5] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row45";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set Map1[1]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set Map1[1]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row46";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append Map1[0]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append Map1[0]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row47";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge Map1[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge Map1[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row48";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("Map1[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 != retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row49";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("Map1[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete Map1[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete Map1[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row50";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1.noPath[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set Map1.noPath[1]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set Map1.noPath[1]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row51";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1.noPath[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append Map1.noPath[0]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append Map1.noPath[0]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row52";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1.noPath[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge Map1.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge Map1.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row53";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("Map1.noPath[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1.noPath[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1.noPath[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row54";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("Map1.noPath[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete Map1.noPath[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete Map1.noPath[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row55";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1[5].noPath", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set StrArray1[5].noPath=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set StrArray1[5].noPath=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row56";
        mutation = MapRDBImpl.newMutation();
        mutation.append("StrArray1[5].noPath", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append StrArray1[5].noPath+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append StrArray1[5].noPath+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row57";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("StrArray1[5].noPath", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge StrArray1[5].noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge StrArray1[5].noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row58";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("StrArray1[5].noPath", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set StrArray1[5].noPath+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set StrArray1[5].noPath+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row59";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("StrArray1[5].noPath");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete StrArray1[5].noPath " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete StrArray1[5].noPath " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row60";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1.noPath[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set Map1.noPath[0]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set Map1.noPath[0]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row61";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1.L2FieldInt[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append Map1.L2FieldInt[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append Map1.L2FieldInt[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row62";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1.L2FieldInt[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge Map1.L2FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge Map1.L2FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row63";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("Map1.L2FieldInt[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1.L2FieldInt[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1.L2FieldInt[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row64";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("Map1.L2FieldInt[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete Map1.L2FieldInt[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete Map1.L2FieldInt[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row65";
        mutation = MapRDBImpl.newMutation();
        mutation.set("Map1.noPath[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set Map1.noPath[0]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set Map1.noPath[0]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row66";
        mutation = MapRDBImpl.newMutation();
        mutation.append("Map1.L2FieldInt[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append Map1.L2FieldInt[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append Map1.L2FieldInt[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row67";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("Map1.L2FieldInt[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge Map1.L2FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge Map1.L2FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row68";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("Map1.L2FieldInt[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set Map1.L2FieldInt[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set Map1.L2FieldInt[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row69";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("Map1.L2FieldInt[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete Map1.L2FieldInt[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete Map1.L2FieldInt[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row70";
        mutation = MapRDBImpl.newMutation();
        mutation.set("L1FieldInt.noPath[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set L1FieldInt.noPath[0]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set L1FieldInt.noPath[0]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row71";
        mutation = MapRDBImpl.newMutation();
        mutation.append("L1FieldInt.noPath[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append L1FieldInt.noPath[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append L1FieldInt.noPath[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row72";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("L1FieldInt.noPath[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row73";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("L1FieldInt.noPath[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set L1FieldInt.noPath[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set L1FieldInt.noPath[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row74";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("L1FieldInt.noPath[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete L1FieldInt.noPath[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete L1FieldInt.noPath[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row75";
        mutation = MapRDBImpl.newMutation();
        mutation.set("L1FieldInt[0]", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set L1FieldInt[0]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set L1FieldInt[0]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row76";
        mutation = MapRDBImpl.newMutation();
        mutation.append("L1FieldInt[1]", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append L1FieldInt[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append L1FieldInt[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row77";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("L1FieldInt[2]", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge L1FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge L1FieldInt[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row78";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("L1FieldInt[3]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set L1FieldInt[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set L1FieldInt[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row79";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("L1FieldInt[4]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete L1FieldInt[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete L1FieldInt[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row80";
        mutation = MapRDBImpl.newMutation();
        mutation.set("StrArray1[0].noPath", "noVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set StrArray1[0].noPath=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set StrArray1[0].noPath=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row81";
        mutation = MapRDBImpl.newMutation();
        mutation.append("StrArray1[0].noPath", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append StrArray1[0].noPath+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append StrArray1[0].noPath+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row82";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("StrArray1[0].noPath", (Document)mutmap);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge StrArray1[0].noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge StrArray1[0].noPath+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row83";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("StrArray1[0].noPath", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set StrArray1[0].noPath+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set StrArray1[0].noPath+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row84";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("StrArray1[0].noPath");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete StrArray1[0].noPath " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete StrArray1[0].noPath " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row85";
        mutation = MapRDBImpl.newMutation();
        mutation.set("L1FieldInt.noPath[0]", "noVal").set("L1FieldStr", "L1FieldValNew");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set L1FieldInt.noPath[0]=noVal, L1FieldStr=L1FieldValNew " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set L1FieldInt.noPath[0]=noVal, L1FieldStr=L1FieldValNew " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row86";
        mutation = MapRDBImpl.newMutation();
        mutation.append("L1FieldInt.noPath[1]", mutInts).append("L1FieldStr", "New");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append L1FieldInt.noPath[1]+=[11,22], L1FieldStr+=New " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append L1FieldInt.noPath[1]+=[11,22], L1FieldStr+=New " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row87";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("L1FieldInt.noPath[2]", (Document)mutmap).set("L1FieldStr", "NewVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2}, set L1FieldStr=NewVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2}, set L1FieldStr=NewVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row88";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("L1FieldInt.noPath[3]", 2).set("L1FieldStr", "NewVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set L1FieldInt.noPath[3]+=2, set L1FieldStr=NewVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set L1FieldInt.noPath[3]+=2, set L1FieldStr=NewVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row89";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("L1FieldInt.noPath[4]").set("L1FieldStr", "NewVal");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete L1FieldInt.noPath[4], set L1FieldStr=NewVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete L1FieldInt.noPath[4], set L1FieldStr=NewVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row90";
        mutation = MapRDBImpl.newMutation();
        mutation.set("L1FieldInt.noPath[0]", "noVal").set("IntArray1[0]", 111);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("legal set L1FieldInt.noPath[0]=noVal " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "legal set L1FieldInt.noPath[0]=noVal " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row91";
        mutation = MapRDBImpl.newMutation();
        mutation.append("L1FieldInt.noPath[1]", mutInts).append("IntArray1", mutInts);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal append L1FieldInt.noPath[1]+=[11,22] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal append L1FieldInt.noPath[1]+=[11,22] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row92";
        mutation = MapRDBImpl.newMutation();
        mutation.merge("L1FieldInt.noPath[2]", (Document)mutmap).set("IntArray1[0]", 111);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal merge L1FieldInt.noPath[2]+={Field1:Val1, Field2:Val2} " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row93";
        mutation = MapRDBImpl.newMutation();
        mutation.increment("L1FieldInt.noPath[3]", 2).increment("IntArray1[0]", 2);
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: set L1FieldInt.noPath[3]+=2 " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: set L1FieldInt.noPath[3]+=2 " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        rowid = "row94";
        mutation = MapRDBImpl.newMutation();
        mutation.delete("L1FieldInt.noPath[4]").delete("IntArray1[0]");
        retmsg1 = TestCDPSMisc.noThrowUpdate((Table)jmutTable, (String)rowid, mutation, retmsg1);
        retmsg2 = TestCDPSMisc.noThrowUpdate((Table)jsonTable, (String)rowid, mutation, retmsg2);
        TestCDPSMisc.compareAndPrint("illegal: delete L1FieldInt.noPath[4] " + (String)(retmsg1.ecode == 0 ? " succeed" : " failed with " + retmsg1), (Table)jmutTable, "illegal: delete L1FieldInt.noPath[4] " + (String)(retmsg2.ecode == 0 ? " succeed" : " failed with " + retmsg2), (Table)jsonTable, (String)rowid);
        succeedCount += retmsg1.ecode == 0 ? 1 : 0;
        Assert.assertTrue((0 == retmsg1.ecode ? 1 : 0) != 0);
        Assert.assertTrue((retmsg1.ecode == retmsg2.ecode ? 1 : 0) != 0);
        System.out.println("====== Done mutation: " + (String)rowid + " to table " + jtbl1 + " and " + jsrc1 + "======");
        dstream1 = jmutTable.find();
        dstream2 = jsonTable.find();
        docs1 = dstream1.iterator();
        docs2 = dstream2.iterator();
        count = 0;
        while (docs1.hasNext() && docs2.hasNext()) {
            Document doc2;
            Document doc1 = (Document)docs1.next();
            if (!doc1.equals(doc2 = (Document)docs2.next())) {
                System.out.println("==> ERROR: mismatch doc between table " + jtbl1 + " and " + jsrc1);
                System.out.println(doc1.asJsonString());
                System.out.println(doc2.asJsonString());
            } else {
                System.out.println(doc1.asJsonString());
            }
            ++count;
        }
        System.out.println("====== Readed " + count + " rows ======");
        getListScf = TestCDPSUtil.fetchChangeData(succeedCount, consumerScf);
        System.out.println("Expect " + succeedCount + " updated Rec:" + getListScf.size());
        for (int i = 0; i < succeedCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            TestCDPSMisc.printChangeRec(cdr);
            if (!cdr.getId().getString().equals("row94")) continue;
            TestCDPSMisc.verifyMixedLegalIllegalFieldThroughItr1("row94", cdr, (Document)rec, false);
        }
        jmutTable.close();
        jsonTable.close();
    }

    @Test
    public void testDeleteCursor() throws Exception {
        int RowCount1 = 5;
        String jsrc1 = "/tmp/jsonDelCur";
        String chglogdst1 = "/tmp/chgDelCur";
        String topicFullName = chglogdst1 + ":jsonDelCur";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        DBDocumentImpl rec1 = new DBDocumentImpl();
        for (int i = 0; i < RowCount1; ++i) {
            String rowid = "row" + i;
            rec1 = new DBDocumentImpl();
            rec1.set("field0", "value1-" + i);
            jsonTable.insertOrReplace(rowid, (Document)rec1);
        }
        jsonTable.flush();
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        Object crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        Object cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount1, consumerScf);
        Assert.assertEquals((long)RowCount1, (long)getListScf.size());
        consumerScf.commitSync();
        String cmd = "maprcli stream cursor list -path " + chglogdst1;
        String retstr = TestCluster.runCommand((String)cmd).getStdOut();
        _logger.info(retstr);
        Assert.assertTrue((boolean)retstr.contains("jsonDelCur"));
        cmd = "maprcli stream cursor delete -path " + chglogdst1;
        int retcode = TestCluster.runCommand((String)cmd).getExitCode();
        Assert.assertTrue((retcode == 0 ? 1 : 0) != 0);
        cmd = "maprcli stream cursor list -path " + chglogdst1;
        retstr = TestCluster.runCommand((String)cmd).getStdOut();
        _logger.info(retstr);
        Assert.assertTrue((!retstr.contains("jsonDelCur") ? 1 : 0) != 0);
        jsonTable.close();
    }

    @Test
    public void testRecOrder() throws Exception {
        String jsrc1 = "/tmp/jordsrc1";
        String chglogdst1 = "/tmp/chglogorddst1";
        String topicFullName = chglogdst1 + ":jordsrc1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        TestCDPSMisc.waitForBucketRepl(jsrc1, topicFullName);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        consumerScf = TestCDPSUtil.startConsumer(topicFullName);
        String rowid = "row1";
        int opCount = 500;
        DocumentMutation mutation = null;
        Object baseValue = "";
        for (int i = 0; i < opCount; ++i) {
            baseValue = (String)baseValue + "str" + i;
            mutation = MapRDBImpl.newMutation().set("field" + i, (String)baseValue + "value" + i);
            jsonTable.update(rowid, mutation);
            jsonTable.flush();
        }
        System.out.println("Done: update " + opCount + "records.");
        getListScf = TestCDPSUtil.fetchChangeData(opCount, consumerScf);
        System.out.println("Got " + getListScf.size() + " records");
        Assert.assertEquals((long)opCount, (long)getListScf.size());
        baseValue = "";
        for (int j = 0; j < opCount; ++j) {
            baseValue = (String)baseValue + "str" + j;
            crec = getListScf.get(j);
            cdr = (ChangeDataRecord)crec.value();
            String field = "field" + j;
            String value = (String)baseValue + "value" + j;
            this.verifyOrderThroughIter(field, value, cdr);
        }
        System.out.println("Verified " + opCount + " records");
        jsonTable.close();
    }

    @Test
    public void testLargeSrcRow() throws Exception {
        Object[] value3;
        int extraRowNum;
        int RowCount = 2;
        String jsrc1 = "/tmp/jsonLargeRow1";
        String chglogdst1 = "/tmp/chgLargeRow1";
        String topicFullName = chglogdst1 + ":jsonLargeRow1";
        TestCDPSUtil.replaceScfJsonTable(testAdmin, jsrc1);
        JsonTable jsonTable = MapRDBImpl.getTable((String)jsrc1);
        String fieldKey = "largefield";
        String arrayKey = "largearray";
        String rowKey1 = "RowA30MB";
        char[] value1 = new char[33553408];
        for (int i = 0; i < value1.length; ++i) {
            value1[i] = 16;
        }
        ArrayList<String> alist = new ArrayList<String>();
        alist.add(String.copyValueOf(value1));
        DBDocumentImpl r1 = new DBDocumentImpl();
        r1.set(arrayKey, alist);
        jsonTable.insertOrReplace(rowKey1, (Document)r1);
        String rowKey2 = "RowB30MB";
        byte[] value2 = new byte[33553408];
        for (int i = 0; i < value2.length; ++i) {
            value2[i] = 16;
        }
        Document r2 = MapRDBImpl.newDocument();
        r2.set(fieldKey, value2);
        jsonTable.insertOrReplace(rowKey2, r2);
        jsonTable.flush();
        Document d = jsonTable.findById(rowKey1);
        String item0 = d.getString(arrayKey + "[0]");
        byte[] v = item0.getBytes();
        Assert.assertEquals((long)v.length, (long)value1.length);
        for (int i = 0; i < v.length; ++i) {
            Assert.assertEquals((long)v[i], (long)value1[i]);
        }
        d = jsonTable.findById(rowKey2);
        ByteBuffer b = d.getBinary(fieldKey);
        v = b.array();
        Assert.assertEquals((long)v.length, (long)value2.length);
        for (int i = 0; i < v.length; ++i) {
            Assert.assertEquals((long)v[i], (long)value2[i]);
        }
        TestCDPSUtil.replaceStreamTable(chglogdst1, true, 1);
        TestCDPSUtil.setupCDPSReplicaWithColumns(jsrc1, chglogdst1, topicFullName, false, null);
        TestCDPSMisc.waitForBucketRepl(jsrc1, topicFullName);
        List<ConsumerRecord<byte[], ChangeDataRecord>> getListScf = null;
        ConsumerRecord<byte[], ChangeDataRecord> crec = null;
        KafkaConsumer<byte[], ChangeDataRecord> consumerScf = null;
        boolean isDebug = false;
        ChangeDataRecord cdr = null;
        Properties props = new Properties();
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "com.mapr.db.cdc.ChangeDataRecordDeserializer");
        props.put("fetch.message.max.bytes", "65000000");
        props.put("fetch.min.bytes", "65000000");
        props.put("max.partition.fetch.bytes", "65000000");
        props.put("fetch.wait.max.ms", "500000");
        props.put("auto.offset.reset", "earliest");
        props.put("enable.auto.commit", "false");
        consumerScf = TestCDPSUtil.startConsumer(props, topicFullName);
        getListScf = TestCDPSUtil.fetchChangeData(RowCount, consumerScf);
        for (int i = 0; i < RowCount; ++i) {
            crec = getListScf.get(i);
            cdr = (ChangeDataRecord)crec.value();
            if (i == 0) {
                TestCDPSMisc.verifyInitLargeRowThroughItr1(rowKey1, cdr, (Document)r1, isDebug);
                continue;
            }
            TestCDPSMisc.verifyInitLargeRowThroughItr1(rowKey2, cdr, r2, isDebug);
        }
        _logger.info("passed copyregion phase");
        int totalsize = v.length;
        for (extraRowNum = 0; extraRowNum < 10; ++extraRowNum) {
            _logger.info("loop " + extraRowNum + ":  value length " + totalsize);
            value3 = new char[128];
            for (int i = 0; i < value3.length; ++i) {
                value3[i] = 16;
            }
            ArrayList<String> sublist = new ArrayList<String>();
            sublist.add(String.copyValueOf(value3));
            DocumentMutation mutation = MapRDBImpl.newMutation();
            mutation.append(arrayKey, sublist);
            jsonTable.update(rowKey1, mutation);
            jsonTable.flush();
            try {
                d = jsonTable.findById(rowKey1);
            }
            catch (DBException e) {
                e.printStackTrace();
                break;
            }
            totalsize = 0;
            List strlist = d.getList(arrayKey);
            for (int j = 0; j < strlist.size(); ++j) {
                String itemj = (String)strlist.get(j);
                totalsize += itemj.length();
            }
        }
        _logger.info("array append stop at loop " + extraRowNum + ":  value length " + totalsize);
        getListScf = TestCDPSUtil.fetchChangeData(extraRowNum, consumerScf);
        _logger.info("CDC receive " + getListScf.size() + " array append record");
        Assert.assertEquals((long)extraRowNum, (long)getListScf.size());
        for (extraRowNum = 0; extraRowNum < 10; ++extraRowNum) {
            _logger.info("loop " + extraRowNum + ":  value length " + v.length);
            value3 = new byte[128];
            for (int i = 0; i < value3.length; ++i) {
                value3[i] = 16;
            }
            DocumentMutation mutation = MapRDBImpl.newMutation();
            mutation.append(fieldKey, (byte[])value3);
            jsonTable.update(rowKey2, mutation);
            jsonTable.flush();
            try {
                d = jsonTable.findById(rowKey2);
            }
            catch (DBException e) {
                e.printStackTrace();
                break;
            }
            b = d.getBinary(fieldKey);
            v = b.array();
        }
        _logger.info("field append stop at loop " + extraRowNum + ":  value length " + v.length);
        getListScf = TestCDPSUtil.fetchChangeData(extraRowNum, consumerScf);
        _logger.info("CDC receive " + getListScf.size() + " field append record");
        Assert.assertEquals((long)extraRowNum, (long)getListScf.size());
        jsonTable.delete(rowKey1);
        jsonTable.delete(rowKey2);
        jsonTable.flush();
    }

    public class ErrCodeMsg {
        public int ecode = 0;
        public String emsg = null;

        public ErrCodeMsg(int code, String msg) {
            this.ecode = code;
            this.emsg = msg;
        }

        public void set(int code, String msg) {
            this.ecode = code;
            this.emsg = msg;
        }

        public String toString() {
            return "ErrCode: " + this.ecode + ", ErrMsg: " + this.emsg;
        }
    }
}

