/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.schedulepolicy.commands.SchedulePolicyOutputUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchedulePolicyInfoCommand
extends CLIBaseClass
implements CLIInterface {
    private static final String SCHEDULE_INFO_PARAM = "info";
    private static final String SCHEDULE_ID_PARAM = "id";
    private static final String SCHEDULE_NAME_PARAM = "name";
    public static final String CLDB_HOST = "cldbip";
    public static final String CLDB_PORT = "cldbport";
    public static final String scheduleInfoUsage = "schedule info [-cluster cluster name] [-id id of schedule policy] [ -name name of schedule policy ]";
    public static Pattern p = Pattern.compile("(\\d+)|(\\w+)");
    public static final Log LOG = LogFactory.getLog(SchedulePolicyInfoCommand.class);
    public static final CLICommand schedulePolicyInfoCommand = new CLICommand("info", "info schedule ", SchedulePolicyInfoCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"id", (Object)new IntegerInputParameter("id", "id of schedule policy", false, null)).put((Object)"name", (Object)new TextInputParameter("name", "name of schedule policy", false, null)).build(), null);

    public SchedulePolicyInfoCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        CLDBProto.SchedulePolicyProcRequest.Builder scheduleRequestBuilder = CLDBProto.SchedulePolicyProcRequest.newBuilder();
        scheduleRequestBuilder.setPolicyOp(CLDBProto.SchedulePolicyProcRequest.SchedulePolicyOP.INFO);
        CLDBProto.Policy.Builder policyBuilder = CLDBProto.Policy.newBuilder();
        if (this.isParamPresent(SCHEDULE_ID_PARAM)) {
            int scheduleId = this.getParamIntValue(SCHEDULE_ID_PARAM, 0);
            policyBuilder.setPolicyId(scheduleId);
        } else if (this.isParamPresent(SCHEDULE_NAME_PARAM)) {
            String scheduleName = this.getParamTextValue(SCHEDULE_NAME_PARAM, 0);
            policyBuilder.setPolicyName(scheduleName);
        } else {
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(22, "you must specify either id or name.\nschedule info [-cluster cluster name] [-id id of schedule policy] [ -name name of schedule policy ]"));
            return co;
        }
        scheduleRequestBuilder.setPolicy(policyBuilder.build());
        byte[] data = null;
        try {
            scheduleRequestBuilder.setCreds(this.getUserCredentials());
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SchedulePolicyProc.getNumber(), (MessageLite)scheduleRequestBuilder.build(), CLDBProto.SchedulePolicyProcResponse.class);
            if (data == null) {
                LOG.error((Object)"RPC Request to get info of Schedule failed. No data returned");
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return co;
            }
            CLDBProto.SchedulePolicyProcResponse resp = CLDBProto.SchedulePolicyProcResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                LOG.error((Object)("RPC Request to get info of a Schedule failed with error: " + Errno.toString((int)resp.getStatus())));
                ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to get Schedule info failed with error: " + Errno.toString((int)resp.getStatus())));
                return co;
            }
            if (!SchedulePolicyOutputUtil.extractAndAddPolicyToOutput(resp, ch, LOG)) {
                return co;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to get policy info. Exception: ", (Throwable)e);
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(4, "Internal Error, check logs for more details"));
            return co;
        }
        return co;
    }
}

