/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.ServiceManagingOperation;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.AuthManager;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.EnumInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class NodeServicesManagementCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodeServicesManagementCommand.class);
    public static final String FILTER_PARAM = "filter";
    public static final String NODES_PARAM = "nodes";
    public static final String SERVICE_NAME_PARAM = "name";
    public static final String SERVICE_MULTI_PARAM = "multi";
    public static final String SERVICE_ACTION_PARAM = "action";
    public static final String ZK_CONNECTSTRING = "zkconnect";
    public static final int TIMEOUT_SERVER = 30000;
    public static final int MAX_CHARS_COUNT = 60;
    public static final String NODES_SERVICES_MNGMNT_TOP_PATH = "/nodes";
    public static final String NODES_SERVICES_MNGMNT_SERVICE_PATH = "/services";
    public static List<ACL> CREATOR_ALL_ACL_PLUS = new ArrayList<ACL>();
    public static List<ACL> CREATOR_ALL_ACL_PLUS_DIR = new ArrayList<ACL>();
    public static List<ACL> ZK_ACLS;
    public static List<ACL> ZK_ACLS_DIR;
    public static final CLICommand nodeServices;
    private AuthManager authManager = AuthManager.getInstance();

    public NodeServicesManagementCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        boolean isAuthorized;
        boolean isRoot;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        co.setOutput(oh);
        String zkConnectString = null;
        String clusterName = null;
        Security.CredentialsMsg creds = this.getUserCredentials();
        boolean bl = isRoot = creds.hasUid() && creds.getUid() == 0;
        if (!isRoot && !(isAuthorized = this.authManager.canPerformClusterActions(SecurityCommandHelper.CLUSTER_START_STOP_SERVICES_MASK, creds, oh))) {
            return co;
        }
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
            zkConnectString = MapRCliUtil.getZkConnect(clusterName);
        } else {
            zkConnectString = MapRCliUtil.getZkConnect();
            clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        }
        if (JNISecurity.IsSecurityEnabled((String)clusterName)) {
            ZK_ACLS = CREATOR_ALL_ACL_PLUS;
            ZK_ACLS_DIR = CREATOR_ALL_ACL_PLUS_DIR;
        }
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent(ZK_CONNECTSTRING)) {
            zkConnectString = this.getParamTextValue(ZK_CONNECTSTRING, 0);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("ZKConnectString: " + zkConnectString));
        }
        if (zkConnectString == null) {
            Object errorMsg = "Unable to obtain the ZooKeeper connection string from the CLDB. Make sure that the CLDB is running and accessible.";
            if (this.isParamPresent(ServicesEnum.cldb.name())) {
                errorMsg = (String)errorMsg + "\n If you are trying to start CLDB please specify valid Zookeeper connection string using zkconnect parameter";
            }
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, (String)errorMsg));
            return co;
        }
        boolean isFabricOperation = false;
        if (this.isParamPresent(SERVICE_NAME_PARAM)) {
            String serviceName = this.getParamTextValue(SERVICE_NAME_PARAM, 0);
            if ("fabric".equals(serviceName)) {
                isFabricOperation = true;
            }
            if ("fabric".equals(serviceName) || "warden".equals(serviceName)) {
                if (!this.isParamPresent(SERVICE_ACTION_PARAM)) {
                    LOG.error((Object)"action parameter has to be present when name is present");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "action parameter has to be present when name is present"));
                    return co;
                }
                ServiceManagingOperation action = (ServiceManagingOperation)this.getParamObjectValue(SERVICE_ACTION_PARAM, 0);
                String actionName = action.name();
                if (!"restart".equalsIgnoreCase(actionName)) {
                    LOG.error((Object)("Invalid action for " + serviceName + ". Current implementation supports restart action for service " + serviceName));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid action for " + serviceName + ". Current implementation supports only restart action for service " + serviceName));
                    return co;
                }
            }
        }
        List<String> nodes = NodesCommonUtils.findNodeIps(zkConnectString, clusterName);
        List<String> nodeHostNames = new ArrayList<String>();
        if (this.isParamPresent(NODES_PARAM)) {
            List nodeList = this.input.getParameterByName(NODES_PARAM).getParamValues();
            for (String node : nodeList) {
                if (node.contains(",")) {
                    nodeHostNames.addAll(Arrays.asList(node.split(",")));
                    continue;
                }
                nodeHostNames.add(node);
            }
        } else if (this.isParamPresent(FILTER_PARAM)) {
            String filter = this.getParamTextValue(FILTER_PARAM, 0);
            try {
                nodeHostNames = NodesCommonUtils.findFilteredNodeIps(filter, zkConnectString);
            }
            catch (CLIProcessingException e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get nodes list. Can not do an action on service"));
                return co;
            }
        } else if (!isFabricOperation) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Invalid parameters provided: neither \"filter\", nor \"nodes\" was specified"));
            return co;
        }
        if ((nodeHostNames == null || nodeHostNames.isEmpty()) && !isFabricOperation) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes matched input parameters"));
            return co;
        }
        List<String> nodeNames = NodesCommonUtils.convertHostToIpIncludingLocal(nodeHostNames);
        nodeNames.addAll(NodesCommonUtils.convertIpToHost(nodeHostNames));
        nodeNames.addAll(nodeHostNames);
        HashSet<String> nodeNamesSet = new HashSet<String>(nodeNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NodeNamesSet: " + nodeNamesSet));
        }
        nodeNamesSet.removeAll(nodes);
        nodeNames.removeAll(nodeNamesSet);
        HashSet<String> nodeNamesUnique = new HashSet<String>(nodeNames);
        if (nodeNamesUnique.isEmpty()) {
            StringBuilder outputErrorParams = new StringBuilder(nodeHostNames.toString());
            if (outputErrorParams.length() > 60) {
                outputErrorParams.delete(61, outputErrorParams.length());
                outputErrorParams.append("...");
            }
            if (!isFabricOperation) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes.  Please specify a node in the same format shown in the output of the \"maprcli node list\" command"));
                LOG.error((Object)("Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes.  Please specify a node in the same format shown in the output of the \"maprcli node list\" command"));
                return co;
            }
        }
        if (nodeNamesUnique.size() < nodeHostNames.size()) {
            LOG.error((Object)("Not all input nodes were identified. Command will be executed only for: " + nodeNamesUnique));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Not all input nodes were identified. Command will be executed only for: " + nodeNamesUnique + ". Please specify nodes in the same format shown in the output of the \"maprcli node list\" command"));
        }
        if (this.isParamPresent(SERVICE_NAME_PARAM)) {
            String serviceName = this.getParamTextValue(SERVICE_NAME_PARAM, 0);
            if ("warden".equals(serviceName)) {
                this.handleWardenAction(oh, zkConnectString, nodeNamesUnique);
                return co;
            }
            if ("fabric".equals(serviceName)) {
                this.handleFabricAction(oh, zkConnectString);
                return co;
            }
        }
        int retries = 0;
        if (retries++ < 3) {
            try {
                ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString);
                Map<String, List<String>> confServices = NodesCommonUtils.findServicesConfiguredHierarchy(zkConnectString);
                for (String node : nodeNamesUnique) {
                    List<String> confServicesPerNode;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Node: " + node));
                    }
                    if ((confServicesPerNode = confServices.get(node)) == null || confServicesPerNode.isEmpty()) {
                        LOG.error((Object)("Node: " + node + " does not have any service configured"));
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Node: " + node + " does not have any service configured"));
                        continue;
                    }
                    try {
                        s_zk.create(NODES_SERVICES_MNGMNT_TOP_PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                        // empty catch block
                    }
                    try {
                        s_zk.create("/nodes/" + node, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                        // empty catch block
                    }
                    try {
                        s_zk.create("/nodes/" + node + NODES_SERVICES_MNGMNT_SERVICE_PATH, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException nodeExistsException) {
                        // empty catch block
                    }
                    for (ServicesEnum service : ServicesEnum.values()) {
                        if (!this.isParamPresent(service.name())) continue;
                        String serviceOperation = this.getParamTextValue(service.name(), 0);
                        try {
                            ServiceManagingOperation.valueOf((String)serviceOperation);
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error((Object)("Service operation type for service: " + service.name() + " is not valid: " + serviceOperation));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10007, "Service operation type for service: " + service.name() + " is not valid: " + serviceOperation).setField(service.name()).setFieldValue(serviceOperation));
                            continue;
                        }
                        if (!confServicesPerNode.contains(service.name())) {
                            LOG.error((Object)("Service: " + service.name() + " is not configured on node: " + node));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + service.name() + " is not configured on node: " + node));
                            continue;
                        }
                        this.helperAction(s_zk, node, service.name(), serviceOperation, oh);
                    }
                    if (this.isParamPresent(SERVICE_NAME_PARAM)) {
                        String serviceName = this.getParamTextValue(SERVICE_NAME_PARAM, 0);
                        if (!this.isParamPresent(SERVICE_ACTION_PARAM)) {
                            LOG.error((Object)"action parameter has to be present when name is present");
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "action parameter has to be present when name is present"));
                            return co;
                        }
                        if (this.getParamObjectValue(SERVICE_ACTION_PARAM, 0) instanceof ServiceManagingOperation) {
                            ServiceManagingOperation action = (ServiceManagingOperation)this.getParamObjectValue(SERVICE_ACTION_PARAM, 0);
                            if (!confServicesPerNode.contains(serviceName)) {
                                LOG.error((Object)("Service: " + serviceName + " is not configured on node: " + node));
                                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " is not configured on node: " + node));
                                continue;
                            }
                            this.helperAction(s_zk, node, serviceName, action.name(), oh);
                        } else {
                            LOG.error((Object)("action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            return co;
                        }
                    }
                    if (!this.isParamPresent(SERVICE_MULTI_PARAM)) continue;
                    String multiParam = this.getParamTextValue(SERVICE_MULTI_PARAM, 0);
                    JSONTokener token = new JSONTokener(multiParam);
                    try {
                        JSONArray jarray = new JSONArray(token);
                        for (int i = 0; i < jarray.length(); ++i) {
                            JSONObject obj = jarray.getJSONObject(i);
                            String serviceName = obj.getString(SERVICE_NAME_PARAM);
                            if (!obj.has(SERVICE_ACTION_PARAM)) {
                                LOG.error((Object)"action parameter has to be present when name is present");
                                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "action parameter has to be present when name is present"));
                                return co;
                            }
                            String strAction = obj.getString(SERVICE_ACTION_PARAM);
                            ServiceManagingOperation action = null;
                            for (ServiceManagingOperation s : ServiceManagingOperation.values()) {
                                if (!s.name().equals(strAction)) continue;
                                action = s;
                                break;
                            }
                            if (action != null) {
                                if (!confServicesPerNode.contains(serviceName)) {
                                    LOG.error((Object)("Service: " + serviceName + " is not configured on node: " + node));
                                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Service: " + serviceName + " is not configured on node: " + node));
                                    continue;
                                }
                                this.helperAction(s_zk, node, serviceName, action.name(), oh);
                                continue;
                            }
                            LOG.error((Object)("action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "action on the service is not of correct Enum type. You can use only one of following: " + Arrays.asList(ServiceManagingOperation.values())));
                            return co;
                        }
                    }
                    catch (JSONException e) {
                        LOG.error((Object)("Error parsing JSON string: " + multiParam));
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing JSON string"));
                    }
                }
            }
            catch (KeeperException e) {
                LOG.error((Object)"KeeperException while trying to create ZK struct for service management", (Throwable)e);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "KeeperException while trying to create ZK struct for service management" + e.getLocalizedMessage()));
                return co;
            }
            catch (InterruptedException e) {
                LOG.error((Object)"InterruptedException while trying to create ZK struct for service management", (Throwable)e);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "InterruptedException while trying to create ZK struct for service management" + e.getLocalizedMessage()));
                return co;
            }
        }
        return co;
    }

    private void helperAction(ZooKeeper s_zk, String node, String service, String serviceOperation, CommandOutput.OutputHierarchy oh) throws KeeperException, InterruptedException {
        try {
            s_zk.create("/nodes/" + node + "/services/" + service, new byte[0], ZK_ACLS_DIR, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        try {
            byte[] data = String.valueOf(System.currentTimeMillis()).getBytes();
            String createdNode = s_zk.create("/nodes/" + node + "/services/" + service + "/" + serviceOperation + "_", data, ZK_ACLS, CreateMode.PERSISTENT_SEQUENTIAL);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Created znode: " + createdNode + " to " + serviceOperation + " service " + service));
            }
        }
        catch (KeeperException.NodeExistsException e1) {
            LOG.warn((Object)("Please wait. The previous " + serviceOperation + " command for " + service + " is executing."));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Please wait. The previous " + serviceOperation + " command for " + service + " is executing.").setField(service).setFieldValue(serviceOperation));
        }
    }

    private void handleFabricAction(CommandOutput.OutputHierarchy oh, String zkConnectString) {
        if (this.isParamPresent("cluster")) {
            LOG.error((Object)"handleWardenAction: invalid param cluster");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid param cluster. cluster is not supported for fabric service."));
            return;
        }
        ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString);
        this.cleanupTimestamps(s_zk);
        String zdir = "/fabric/restart/timestamp";
        try {
            Stat stat = s_zk.exists(zdir, null);
            if (stat == null) {
                LOG.error((Object)("handleWardenAction: zdir " + zdir + " not found."));
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"handleFabricAction: caught InterruptedException.", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)"handleFabricAction: caught KeeperException.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"handleFabricAction: caught IllegalArgumentException.", (Throwable)e);
        }
        LOG.info((Object)("handleFabricAction: processing zkdir " + zdir));
        String ts = String.valueOf(System.currentTimeMillis());
        String znode = zdir + "/" + ts;
        String res = this.createZNode(s_zk, znode, "fabric", "restart", oh);
        if (!res.equalsIgnoreCase(znode)) {
            LOG.error((Object)("handleFabricAction: failed to create znode " + znode));
            return;
        }
        LOG.info((Object)("handleFabricAction: created znode " + znode));
        this.dumpTimestamps(s_zk);
        LOG.info((Object)"handleFabricAction: completed fabric restart");
    }

    private void handleWardenAction(CommandOutput.OutputHierarchy oh, String zkConnectString, Set<String> targetNodes) {
        if (this.isParamPresent("cluster")) {
            LOG.error((Object)"handleWardenAction: invalid param cluster");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid param cluster. cluster is not supported for warden service."));
            return;
        }
        ZooKeeper s_zk = NodesCommonUtils.connect(zkConnectString);
        String zpath = "/fabric/service/warden/restart";
        for (String node : targetNodes) {
            String zdir = "/fabric/service/warden/restart/" + node;
            LOG.info((Object)("handleWardenAction: processing zdir " + zdir));
            try {
                Stat stat = s_zk.exists(zdir, null);
                if (stat == null) {
                    LOG.error((Object)("handleWardenAction: zdir " + zdir + " not found."));
                    continue;
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)"handleWardenAction: caught InterruptedException.", (Throwable)e);
            }
            catch (KeeperException e) {
                LOG.error((Object)"handleWardenAction: caught KeeperException.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"handleWardenAction: caught IllegalArgumentException.", (Throwable)e);
            }
            String znode = zdir + "/restart";
            String res = this.createZNode(s_zk, znode, "warden", "restart", oh);
            if (!res.equalsIgnoreCase(znode)) {
                LOG.error((Object)("handleWardenAction: failed to create znode " + znode));
                continue;
            }
            LOG.info((Object)("handleWardenAction: created znode " + znode));
        }
        LOG.info((Object)("handleWardenAction: completed restart for " + targetNodes.toString()));
    }

    private String createZNode(ZooKeeper s_zk, String path, String service, String opertion, CommandOutput.OutputHierarchy oh) {
        LOG.info((Object)("createZNode: creating znode: " + path));
        String res = "";
        if (opertion == null || opertion.isEmpty()) {
            opertion = "restart";
        } else if (!opertion.equalsIgnoreCase("restart")) {
            LOG.error((Object)("createZNode: Operation " + opertion + " is not supported."));
            return "";
        }
        try {
            res = s_zk.create(path, new byte[0], ZK_ACLS, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e1) {
            LOG.warn((Object)("createZNode: Please wait. The previous " + opertion + " command for " + service + " is executing."));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Please wait. The previous " + opertion + " command for " + service + " is executing.").setField(service).setFieldValue(opertion));
        }
        catch (KeeperException e) {
            LOG.error((Object)("createZNode: KeeperException while creating znode " + path), (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "KeeperException while creating znode " + path + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            LOG.error((Object)("createZNode: InterruptedException while creating znode " + path), (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "InterruptedException while creating znode " + path + e.getLocalizedMessage()));
        }
        LOG.info((Object)("createZNode: created znode " + res));
        return res;
    }

    private void cleanupTimestamps(ZooKeeper s_zk) {
        String path = "/fabric/restart/timestamp";
        try {
            Stat stat = s_zk.exists(path, null);
            if (stat == null) {
                return;
            }
            List children = s_zk.getChildren(path, null);
            LOG.info((Object)("cleanupTimestamps: num-children: " + children.size()));
            for (String child : children) {
                String childPath = path + "/" + child;
                LOG.info((Object)("cleanupTimestamps: removed child: " + childPath));
                s_zk.delete(childPath, -1);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"cleanupTimestamps: caught InterruptedException.", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)"cleanupTimestamps: caught KeeperException.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"cleanupTimestamps: caught IllegalArgumentException.", (Throwable)e);
        }
    }

    private void dumpTimestamps(ZooKeeper s_zk) {
        try {
            List children = s_zk.getChildren("/fabric/restart/timestamp", null);
            LOG.info((Object)("dumpTimestamps: num-timestamps: " + children.size() + ", timestamps ::>> " + children.toString()));
        }
        catch (InterruptedException e) {
            LOG.error((Object)"dumpTimestamps: caught InterruptedException.", (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.error((Object)"dumpTimestamps: caught KeeperException.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"dumpTimestamps: caught IllegalArgumentException.", (Throwable)e);
        }
    }

    static {
        CREATOR_ALL_ACL_PLUS.add(new ACL(30, ZooDefs.Ids.AUTH_IDS));
        CREATOR_ALL_ACL_PLUS.add(new ACL(1, new Id("sasl", "anyone")));
        CREATOR_ALL_ACL_PLUS_DIR.add(new ACL(31, new Id("sasl", "anyone")));
        ZK_ACLS = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        ZK_ACLS_DIR = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        nodeServices = new CLICommand("services", "service management command ", NodeServicesManagementCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)FILTER_PARAM, (Object)new FilterInputParameter(FILTER_PARAM, "node names filter. Please put it in quotes\"\"", false, null)).put((Object)ZK_CONNECTSTRING, (Object)new TextInputParameter(ZK_CONNECTSTRING, "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)NODES_PARAM, (Object)new TextInputParameter(NODES_PARAM, "node names space separated", false, null)).put((Object)ServicesEnum.cldb.name(), (Object)new TextInputParameter(ServicesEnum.cldb.name(), "managing cldb service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.fileserver.name(), (Object)new TextInputParameter(ServicesEnum.fileserver.name(), "managing fileserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.hbmaster.name(), (Object)new TextInputParameter(ServicesEnum.hbmaster.name(), "managing hbprimary service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.hbregionserver.name(), (Object)new TextInputParameter(ServicesEnum.hbregionserver.name(), "managing hbregionserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.jobtracker.name(), (Object)new TextInputParameter(ServicesEnum.jobtracker.name(), "managing jobtracker service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.nfs.name(), (Object)new TextInputParameter(ServicesEnum.nfs.name(), "managing nfs service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.tasktracker.name(), (Object)new TextInputParameter(ServicesEnum.tasktracker.name(), "managing tasktracker service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.apiserver.name(), (Object)new TextInputParameter(ServicesEnum.apiserver.name(), "managing apiserver service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)SERVICE_NAME_PARAM, (Object)new TextInputParameter(SERVICE_NAME_PARAM, "service name to perform action on", false, null)).put((Object)SERVICE_ACTION_PARAM, (Object)new EnumInputParameter(SERVICE_ACTION_PARAM, "service action. One of: " + Arrays.asList(ServiceManagingOperation.values()), false, ServiceManagingOperation.class, null)).put((Object)SERVICE_MULTI_PARAM, (Object)new TextInputParameter(SERVICE_MULTI_PARAM, "service json to parse to start/stop multiple services", false, null).setInvisible(true)).put((Object)ServicesEnum.nfs4.name(), (Object)new TextInputParameter(ServicesEnum.nfs4.name(), "managing nfs4 service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.s3server.name(), (Object)new TextInputParameter(ServicesEnum.s3server.name(), "managing s3server service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).put((Object)ServicesEnum.keycloak.name(), (Object)new TextInputParameter(ServicesEnum.keycloak.name(), "managing keycloak service: " + Arrays.asList(ServiceManagingOperation.values()), false, null)).build(), null);
    }
}

