/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mapr.fs.Nfsmon;
import org.apache.log4j.Logger;

public class NFS4MgmtCommands
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(NFS4MgmtCommands.class);
    private static final String NFSHostIp = "nfshost";
    private static final String NFSPort = "nfsport";
    private static final String NFSExportId = "exportid";
    private static final String NFSConfFile = "conffile";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"nfshost", (Object)new TextInputParameter("nfshost", "ip/hostname", false, "127.0.0.1")).put((Object)"nfsport", (Object)new IntegerInputParameter("nfsport", "port", false, Integer.valueOf(9995))).build();
    private static final CLICommand updateExportsCommand = new CLICommand("update-export", "usage: nfs4mgmt update-export -exportid id -conffile path", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"exportid", (Object)new IntegerInputParameter("exportid", "export id", true, Integer.valueOf(0))).put((Object)"conffile", (Object)new TextInputParameter("conffile", "conf file path", true, null)).build(), null).setShortUsage("nfs4mgmt update-export -exportid id -conffile path");
    private static final CLICommand addExportsCommand = new CLICommand("add-export", "usage: nfs4mgmt add-export -exportid id -conffile path", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"exportid", (Object)new IntegerInputParameter("exportid", "export id", true, Integer.valueOf(0))).put((Object)"conffile", (Object)new TextInputParameter("conffile", "conf file path", true, null)).build(), null).setShortUsage("nfs4mgmt add-export -exportid id -conffile path");
    private static final CLICommand removeExportsCommand = new CLICommand("remove-export", "usage: nfs4mgmt remove-export -exportid id", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"exportid", (Object)new IntegerInputParameter("exportid", "export id", true, Integer.valueOf(0))).build(), null).setShortUsage("nfs4mgmt remove-export -exportid id");
    private static final CLICommand listExportsCommand = new CLICommand("list-exports", "usage: nfs4mgmt list-exports", NFS4MgmtCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("nfs4mgmt list-exports");
    public static final CLICommand nfs4MgmtCmds = new CLICommand("nfs4mgmt", "usage: nfs4mgmt [add-export|remove-export|list-exports|update-exports]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listExportsCommand, addExportsCommand, removeExportsCommand, updateExportsCommand}).setShortUsage("nfs4mgmt [add-export|remove-export|list-exports|update-exports]");

    public NFS4MgmtCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        int port;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new CLIProcessingException("Error in RPC init");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Rpc.initialize " + e);
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
        port = this.getParamIntValue(NFSPort, 0);
        String hostName = this.getParamTextValue(NFSHostIp, 0);
        CLDBRpcCommonUtils.IpAddr hostip = new CLDBRpcCommonUtils.IpAddr(hostName);
        long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list-exports")) {
            NFS4MgmtCommands.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeShowAll, out, binding, -1, null);
            return output;
        }
        int exportId = this.getParamIntValue(NFSExportId, 0);
        if (this.cliCommand.getCommandName().equalsIgnoreCase("add-export")) {
            String confFilePath = this.getParamTextValue(NFSConfFile, 0);
            NFS4MgmtCommands.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeAdd, out, binding, exportId, confFilePath);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("remove-export")) {
            NFS4MgmtCommands.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeRemove, out, binding, exportId, null);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("update-export")) {
            String confFilePath = this.getParamTextValue(NFSConfFile, 0);
            NFS4MgmtCommands.sendExportRequest(Nfsmon.NFSExportRequestType.NFSExportRequestTypeUpdate, out, binding, exportId, confFilePath);
        }
        return output;
    }

    public static Nfsmon.NFSExportResponse sendRemoveExportRequestForShare(String hostName, int port, int exportId, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        CLDBRpcCommonUtils.IpAddr hostip = new CLDBRpcCommonUtils.IpAddr(hostName);
        Nfsmon.NFSExportRequestType type = Nfsmon.NFSExportRequestType.NFSExportRequestTypeRemove;
        String confFilePath = null;
        long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        CLDBProto.NFSExportInfo.Builder expInfo = CLDBProto.NFSExportInfo.newBuilder();
        expInfo.setExportId(exportId);
        List<CLDBProto.NFSExportInfo> expInfoList = Collections.singletonList(expInfo.build());
        return NFS4MgmtCommands.sendExportRequestInternal(type, out, binding, -1, confFilePath, expInfoList, true);
    }

    public static boolean updateAllExportsForShare(List<CLDBProto.ExportConfig> exportConfigs, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        LOG.debug((Object)("updateAllExportsForShare: exportConfigs:" + exportConfigs));
        if (exportConfigs == null || exportConfigs.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No exports to update"));
            return true;
        }
        HashMap<String, ArrayList<CLDBProto.ExportConfig>> exportsByIp = new HashMap<String, ArrayList<CLDBProto.ExportConfig>>();
        for (CLDBProto.ExportConfig config : exportConfigs) {
            String nfsIp = config.getNfsIp();
            if (nfsIp == null || nfsIp.isEmpty()) {
                LOG.warn((Object)("updateAllExportsForShare: Skipping export with missing nfsIp:" + nfsIp));
                continue;
            }
            ArrayList<CLDBProto.ExportConfig> configsForIp = (ArrayList<CLDBProto.ExportConfig>)exportsByIp.get(nfsIp);
            if (configsForIp == null) {
                configsForIp = new ArrayList<CLDBProto.ExportConfig>();
                exportsByIp.put(nfsIp, configsForIp);
            }
            configsForIp.add(config);
        }
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        boolean areAllExportsUpdated = true;
        for (Map.Entry entry : exportsByIp.entrySet()) {
            String nfsIP = (String)entry.getKey();
            List configsForIP = (List)entry.getValue();
            for (CLDBProto.ExportConfig config : configsForIP) {
                String hostName = config.getNfsIp();
                CLDBRpcCommonUtils.IpAddr hostip = new CLDBRpcCommonUtils.IpAddr(hostName);
                int port = config.getPort();
                CLDBProto.NFSExportInfo exportInfo = config.getExportInfo();
                List<CLDBProto.NFSExportInfo> expInfoList = Collections.singletonList(exportInfo);
                long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                Nfsmon.NFSExportResponse response = NFS4MgmtCommands.sendUpdateExportRequestForShare(binding, expInfoList, out);
                if (response != null && response.getStatus() == 0) continue;
                areAllExportsUpdated = false;
                LOG.error((Object)("Failed to update export for share: " + config.getShareName()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Failed to update export for share: " + config.getShareName()));
            }
        }
        return areAllExportsUpdated;
    }

    public static Nfsmon.NFSExportResponse sendUpdateExportRequestForShare(long binding, List<CLDBProto.NFSExportInfo> exportInfoList, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        LOG.debug((Object)("sendUpdateExportRequestForShare: exportId:" + exportInfoList.get(0).getExportId()));
        Nfsmon.NFSExportRequestType type = Nfsmon.NFSExportRequestType.NFSExportRequestTypeUpdate;
        String confFilePath = null;
        return NFS4MgmtCommands.sendExportRequestInternal(type, out, binding, -1, confFilePath, exportInfoList, true);
    }

    public static Nfsmon.NFSExportResponse sendAddExportRequestForShare(String hostName, int port, String path, String psudoPath, String secType, String accessType, String squash, List<CLDBProto.ClientSpec> clientSpecs, int exportId, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        LOG.debug((Object)("sendAddExportRequestForShare: path:" + path + ", psudoPath:" + psudoPath + ", secType" + secType + ", accessType:" + accessType + ", squash" + squash));
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        CLDBRpcCommonUtils.IpAddr hostip = new CLDBRpcCommonUtils.IpAddr(hostName);
        Nfsmon.NFSExportRequestType type = Nfsmon.NFSExportRequestType.NFSExportRequestTypeAdd;
        String confFilePath = null;
        long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        CLDBProto.NFSExportInfo.Builder expInfo = CLDBProto.NFSExportInfo.newBuilder();
        if (exportId != -1) {
            expInfo.setExportId(exportId);
        }
        if (path != null) {
            expInfo.setPath(path);
        }
        if (psudoPath != null) {
            expInfo.setPseudoPath(psudoPath);
        }
        if (secType != null) {
            expInfo.setSecType(secType);
        }
        if (accessType != null) {
            expInfo.setAccessType(accessType);
        }
        if (squash != null) {
            expInfo.setSquash(squash);
        }
        if (clientSpecs != null && !clientSpecs.isEmpty()) {
            expInfo.addAllClientSpecs(clientSpecs);
        }
        List<CLDBProto.NFSExportInfo> expInfoList = Collections.singletonList(expInfo.build());
        return NFS4MgmtCommands.sendExportRequestInternal(type, out, binding, -1, confFilePath, expInfoList, true);
    }

    public static boolean sendFailoverExportRequestForShare(List<CLDBProto.NFSExportInfo> expInfoList, String sourceNfsIp, int sourceNfsPort, String destinationNfsIp, int destinationNfsPort, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBRpcCommonUtils.IpAddr destHostip;
        long destBinding;
        Nfsmon.NFSExportResponse response;
        LOG.debug((Object)("sendFailoverExportRequestForShare: expInfoList:" + expInfoList));
        if (expInfoList == null || expInfoList.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No exports to failover"));
            return true;
        }
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (sourceNfsIp != null && !sourceNfsIp.isEmpty()) {
            CLDBRpcCommonUtils.IpAddr sourceHostIp = new CLDBRpcCommonUtils.IpAddr(sourceNfsIp);
            long sourceBinding = Rpc.createBindingFor((byte[])sourceHostIp.toByteArray(), (int)sourceNfsPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
            response = NFS4MgmtCommands.sendExportRequestInternal(Nfsmon.NFSExportRequestType.NFSExportRequestTypeRemoveMultiple, out, sourceBinding, -1, null, expInfoList, true);
            if (response == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Not able to reach source NFS server: " + sourceNfsIp));
                LOG.error((Object)("Not able to reach source NFS server: " + sourceNfsIp));
                return false;
            }
            if (response.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Failed to remove exports from source NFS server: " + sourceNfsIp));
                LOG.error((Object)("Failed to remove exports from source NFS server: " + sourceNfsIp));
                return false;
            }
        }
        if ((response = NFS4MgmtCommands.sendExportRequestInternal(Nfsmon.NFSExportRequestType.NFSExportRequestTypeAddMultiple, out, destBinding = Rpc.createBindingFor((byte[])(destHostip = new CLDBRpcCommonUtils.IpAddr(destinationNfsIp)).toByteArray(), (int)destinationNfsPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber()), -1, null, expInfoList, true)) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Not able to reach destination NFS server: " + destinationNfsIp));
            LOG.error((Object)("Not able to reach destination NFS server: " + destinationNfsIp));
            return false;
        }
        if (response.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Failed to add exports to destination NFS server: " + destinationNfsIp));
            LOG.error((Object)("Failed to add exports to destination NFS server: " + destinationNfsIp));
            return false;
        }
        return true;
    }

    private static Nfsmon.NFSExportResponse sendExportRequest(Nfsmon.NFSExportRequestType type, CommandOutput.OutputHierarchy out, long binding, int exportId, String confFilePath) throws CLIProcessingException {
        return NFS4MgmtCommands.sendExportRequestInternal(type, out, binding, exportId, confFilePath, null, false);
    }

    private static Nfsmon.NFSExportResponse sendExportRequestInternal(Nfsmon.NFSExportRequestType type, CommandOutput.OutputHierarchy out, long binding, int exportId, String confFilePath, List<CLDBProto.NFSExportInfo> expInfoList, boolean isShareExport) throws CLIProcessingException {
        Nfsmon.NFSExportResponse resp = null;
        Nfsmon.NFSExportRequest.Builder b = Nfsmon.NFSExportRequest.newBuilder();
        b.setReqType(type);
        if (exportId != -1) {
            b.setExportId(exportId);
        }
        if (confFilePath != null) {
            b.setConfFile(confFilePath);
        }
        if (isShareExport) {
            b.setIsShareExport(true);
        }
        if (expInfoList != null && !expInfoList.isEmpty()) {
            for (CLDBProto.NFSExportInfo expInfo : expInfoList) {
                b.addExportInfos(expInfo);
            }
        }
        try {
            byte[] data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.VirtualIPMonitorProgramId.getNumber(), (int)Nfsmon.NFSMgmtProg.NFSExportProc.getNumber(), (MessageLite)b.build());
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Couldn't connect to NFS server"));
                return resp;
            }
            resp = Nfsmon.NFSExportResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"sendExportRequestInternal: Caught MaprSecurityException: ", (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"sendExportRequestInternal: Caught exception: ", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        if (resp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No response from NFS server"));
            return resp;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return resp;
        }
        if (resp.hasErrMsg()) {
            LOG.error((Object)("sendExportRequestInternal: response errMsg: " + resp.getErrMsg()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(resp.getErrMsg()));
        }
        if (type == Nfsmon.NFSExportRequestType.NFSExportRequestTypeShowAll) {
            System.out.printf("%-10s    Path\n", "Export Id");
            List exportsList = resp.getExportsList();
            for (Nfsmon.NFSExport exp : exportsList) {
                System.out.printf("%-10d    %s\n", exp.getExportId(), exp.getExportedPath());
            }
        }
        return resp;
    }

    private MutableInt CreateNFSUserTicket(String clusterName) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (Security.Key)ticketAndKey.getUserKey());
        String userName = ticketAndKey.getUserCreds().getUserName();
        int[] gids = new int[]{userName.length()};
        ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)userName, (int)userName.length(), (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, null, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (Security.TicketAndKey)ticketAndKey);
        return err;
    }
}

