/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.policyserverutils.PolicyServerRpcCommonUtils;
import com.mapr.cli.UserResourceHelper;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.Rpc;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.policyserver.iam.IamSupportUtils;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.IamRolesHelper;
import com.mapr.security.UnixUserGroupHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IdentityPolicyCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(IdentityPolicyCommands.class);
    private static final String IDENTITY_POLICY_PARAM_NAME = "name";
    private static final String IDENTITY_POLICY_PARAM_USERNAME = "username";
    private static final String IDENTITY_POLICY_PARAM_IS_FILE = "is_file";
    private static final String IDENTITY_POLICY_PARAM_POLICY = "content";
    private static final String IDENTITY_POLICY_PARAM_USERS = "users";
    private static final String IDENTITY_POLICY_PARAM_GROUPS = "groups";
    private static final String START_PARAM = "start";
    private static final String LIMIT_PARAM = "limit";
    private static final int NUM_IAM_POLICIES_PER_RPC = 100;
    private static final String IDENTITY_POLICY_PARAM_ROLES = "roles";
    private static final String IDENTITY_POLICY_ACTION_MAPS = "actionmaps";
    private static final String DATE_FOMRAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Security.CredentialsMsg creds;
    private static Map<PolicyServerProto.IdentityPolicyInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyName, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyName.getNumber(), "n", "Name", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyId, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyId.getNumber(), "id", "Id", Long.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatus, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatus.getNumber(), "status", "Status", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyDescription, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyDescription.getNumber(), "desc", "Description", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyVersion, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyVersion.getNumber(), "version", "Version", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyActive, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyActive.getNumber(), "active", "Active", Boolean.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyOwner, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyOwner.getNumber(), "owner", "Owner", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyCreated, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyCreated.getNumber(), "created", "Created", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUpdated, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUpdated.getNumber(), "updated", "Updated", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatement, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatement.getNumber(), "stmt", "Statement", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementIdentifier, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementIdentifier.getNumber(), "sid", "Sid", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementEffect, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementEffect.getNumber(), "effect", "Effect", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResource, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResource.getNumber(), "resc", "Resource", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResourceAction, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResourceAction.getNumber(), "actn", "Action", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyIdentities, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyIdentities.getNumber(), "identities", "Identities", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUsers, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUsers.getNumber(), "u", "Users", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyGroups, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyGroups.getNumber(), "g", "Groups", String.class)).put((Object)PolicyServerProto.IdentityPolicyInfoFields.iamPolicyRoles, (Object)new FieldInfo(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyRoles.getNumber(), "r", "Roles", String.class)).build();
    private static Map<String, BaseInputParameter> nameParams = new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Policy Name>", true, null)).build();
    private static Map<String, BaseInputParameter> contentParams = new ImmutableMap.Builder().put((Object)"content", (Object)new TextInputParameter("content", "(JSON String | JSON File)", true, null)).build();
    private static Map<String, BaseInputParameter> isFileParams = new ImmutableMap.Builder().put((Object)"is_file", (Object)new BooleanInputParameter("is_file", "(true|false)", false, Boolean.valueOf(false))).build();
    private static Map<String, BaseInputParameter> userParams = new ImmutableMap.Builder().put((Object)"users", (Object)new TextInputParameter("users", "<List of Users>", false, null)).build();
    private static Map<String, BaseInputParameter> groupParams = new ImmutableMap.Builder().put((Object)"groups", (Object)new TextInputParameter("groups", "<List of Groups>", false, null)).build();
    private static Map<String, BaseInputParameter> roleParams = new ImmutableMap.Builder().put((Object)"roles", (Object)new TextInputParameter("roles", "<List of Roles>", false, null)).build();
    private static final String createIdentityPolicyUsage = "policy create -name <policy name>-is_file <true|false, default:false>-content <string data | json file>";
    private static final String modifyIdentityPolicyUsage = "policy modify -name <policy name>-is_file <true|false, default:false>-content <string data | json file>";
    private static final String infoIdentityPolicyUsage = "policy info -name <policy name>";
    private static final String listIdentityPolicyUsage = "policy list [ -start start. default: 0 ][ -limit limit (default:2147483647)] ";
    private static final String removeIdentityPolicyUsage = "policy remove -name <policy name>";
    private static final String assignIdentityPolicyUsage = "policy attach -name <policy name> -users <list of users> -groups <list of groups> -roles <list of roles>";
    private static final String unassignIdentityPolicyUsage = "policy detach -name <policy name> -users <list of users> -groups <list of groups> -roles <list of roles>";
    private static final String getAttachedIdentityPoliciesUsage = "policy mapping -users <list of users> -groups <list of groups> -roles <list of roles>";
    private static final CLICommand getUserActionsCommand = new CLICommand("getuseractions", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"username", (Object)new TextInputParameter("username", "<user name>", true, null)).build(), null).setShortUsage("policy getuseractions -username <user name>");
    private static final CLICommand createIdentityPolicyCommand = new CLICommand("create", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(contentParams).putAll(isFileParams).build(), null).setShortUsage("policy create -name <policy name>-is_file <true|false, default:false>-content <string data | json file>");
    private static final CLICommand modifyIdentityPolicyCommand = new CLICommand("modify", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(contentParams).putAll(isFileParams).build(), null).setShortUsage("policy modify -name <policy name>-is_file <true|false, default:false>-content <string data | json file>");
    private static final CLICommand infoIdentityPolicyCommand = new CLICommand("info", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).build(), null).setShortUsage("policy info -name <policy name>");
    private static final CLICommand listIdentityPolicyCommand = new CLICommand("list", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"start", (Object)new IntegerInputParameter("start", "<Start>", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "<Limit>", false, Integer.valueOf(Integer.MAX_VALUE))).build(), null).setShortUsage("policy list [ -start start. default: 0 ][ -limit limit (default:2147483647)] ");
    private static final CLICommand removeIdentityPolicyCommand = new CLICommand("remove", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).build(), null).setShortUsage("policy remove -name <policy name>");
    private static final CLICommand getAttachedIdentityPoliciesCommand = new CLICommand("mapping", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(userParams).putAll(groupParams).putAll(roleParams).build(), null).setShortUsage("policy mapping -users <list of users> -groups <list of groups> -roles <list of roles>");
    private static final CLICommand assignIdentityPolicyCommand = new CLICommand("attach", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(userParams).putAll(groupParams).putAll(roleParams).build(), null).setShortUsage("policy attach -name <policy name> -users <list of users> -groups <list of groups> -roles <list of roles>");
    private static final CLICommand unassignIdentityPolicyCommand = new CLICommand("detach", "", IdentityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(userParams).putAll(groupParams).putAll(roleParams).build(), null).setShortUsage("policy detach -name <policy name> -users <list of users> -groups <list of groups> -roles <list of roles>");
    public static final CLICommand IdentityPolicyCommands = new CLICommand("policy", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createIdentityPolicyCommand, getUserActionsCommand, modifyIdentityPolicyCommand, removeIdentityPolicyCommand, infoIdentityPolicyCommand, listIdentityPolicyCommand, assignIdentityPolicyCommand, unassignIdentityPolicyCommand, getAttachedIdentityPoliciesCommand}).setShortUsage("policy [create|modify|remove|attach|detach|info|list]");
    private ProcessedInput processedInput;
    private CLICommand cliCommand;
    private UnixUserGroupHelper uugh;
    private IamRolesHelper imrh;
    private String cluster;

    public IdentityPolicyCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
        this.processedInput = input;
        this.cliCommand = cliCommand;
    }

    void initialize() throws CLIProcessingException {
        try {
            this.creds = this.getUserCredentials();
            this.cluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            this.uugh = new UnixUserGroupHelper();
            this.imrh = new IamRolesHelper(this.cluster);
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC initialize");
            }
        }
        catch (Exception exp) {
            LOG.error((Object)("Exception while initializing RPC " + exp));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.initialize();
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("create")) {
            try {
                return this.createIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Create Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("modify")) {
            try {
                return this.modifyIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Modify Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("remove")) {
            try {
                return this.deleteIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Remove Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("attach")) {
            try {
                return this.assignIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Attach Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("detach")) {
            try {
                return this.unassignIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Detach Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("info")) {
            try {
                return this.infoIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Info Identity Policy Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("list")) {
            try {
                return this.listIdentityPolicy();
            }
            catch (Exception e) {
                throw new CLIProcessingException("List Identity Policies Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("mapping")) {
            try {
                return this.getIdentityPolicyMappings();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get Identity Policy Mappings Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("getuseractions")) {
            try {
                return this.getUserActions();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Fetch user identity policy Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Identity Policy command failed".getBytes());
    }

    private CommandOutput createIdentityPolicy() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String policyName = this.getPolicyName();
        boolean isFile = this.getIsFileParamValue();
        String strContent = null;
        try {
            strContent = this.getPolicyContent(isFile);
        }
        catch (Exception exp) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Failed to fetch Identity Policy contents " + exp.getLocalizedMessage()));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IdentityPolicyCreateRequest req = PolicyServerProto.IdentityPolicyCreateRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicyName(policyName).setPolicyData(strContent).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyCreateProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyCreateResponse resp = PolicyServerProto.IdentityPolicyCreateResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Identity Policy '" + policyName + "' created successfully");
        } else {
            String errMsg = "Failed to create Identity Policy '" + policyName + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput modifyIdentityPolicy() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String policyName = this.getPolicyName();
        boolean isFile = this.getIsFileParamValue();
        String strContent = null;
        try {
            strContent = this.getPolicyContent(isFile);
        }
        catch (Exception exp) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Failed to fetch Identity Policy contents " + exp.getLocalizedMessage()));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IdentityPolicyModifyRequest req = PolicyServerProto.IdentityPolicyModifyRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicyName(policyName).setPolicyData(strContent).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyModifyProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyModifyResponse resp = PolicyServerProto.IdentityPolicyModifyResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Identity Policy '" + policyName + "' modified successfully");
        } else {
            String errMsg = "Failed to modify Identity Policy '" + policyName + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput deleteIdentityPolicy() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String policyName = this.getPolicyName();
        byte[] data = null;
        PolicyServerProto.IdentityPolicyDeleteRequest req = PolicyServerProto.IdentityPolicyDeleteRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicy(policyName).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyDeleteProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyDeleteResponse resp = PolicyServerProto.IdentityPolicyDeleteResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Identity Policy '" + policyName + "' removed successfully");
        } else {
            String errMsg = "Failed to remove Identity Policy '" + policyName + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput assignIdentityPolicy() throws Exception {
        String roles;
        String groups;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        HashSet identities = new HashSet();
        String policy = this.getPolicyName();
        String users = this.getUsers();
        if (users != null) {
            HashSet<String> userNames = this.getValues(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroups()) != null) {
            HashSet<String> groupNames = this.getValues(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if ((roles = this.getRoles()) != null) {
            HashSet<String> roleNames = this.getValues(roles, ",");
            HashSet<Integer> roleIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Role, roleNames, out);
            if (roleIds == null || roleIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(roleIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Role));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users, Groups or Roles specified"));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IdentityPolicyAssignRequest req = PolicyServerProto.IdentityPolicyAssignRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicy(policy).addAllIdentities(identities).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyAssignProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyAssignResponse resp = PolicyServerProto.IdentityPolicyAssignResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Identity Policy '" + policy + "' attached successfully");
        } else {
            String errMsg = "Failed to attach Identity Policy '" + policy + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput unassignIdentityPolicy() throws Exception {
        String roles;
        String groups;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        HashSet identities = new HashSet();
        String policy = this.getPolicyName();
        String users = this.getUsers();
        if (users != null) {
            HashSet<String> userNames = this.getValues(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroups()) != null) {
            HashSet<String> groupNames = this.getValues(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if ((roles = this.getRoles()) != null) {
            HashSet<String> roleNames = this.getValues(roles, ",");
            HashSet<Integer> roleIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Role, roleNames, out);
            if (roleIds == null || roleIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(roleIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Role));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users, Groups or Roles specified"));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IdentityPolicyUnassignRequest req = PolicyServerProto.IdentityPolicyUnassignRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicy(policy).addAllIdentities(identities).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyUnassignProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyUnassignResponse resp = PolicyServerProto.IdentityPolicyUnassignResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Identity Policy '" + policy + "' detached successfully");
        } else {
            String errMsg = "Failed to detach Identity Policy '" + policy + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput infoIdentityPolicy() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String policyName = this.getPolicyName();
        byte[] data = null;
        PolicyServerProto.IdentityPolicyInfoRequest req = PolicyServerProto.IdentityPolicyInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setPolicy(policyName).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyInfoProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyInfoResponse resp = PolicyServerProto.IdentityPolicyInfoResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            PolicyServerProto.IdentityPolicyInfoMsg iamPolicy = resp.getIamPolicy();
            if (iamPolicy != null) {
                String status = IamSupportUtils.getIdentityPolicyStatus((PolicyServerProto.IdentityPolicyStatus)iamPolicy.getStatus());
                PolicyServerProto.PolicyInfoMsg policy = iamPolicy.getPolicy();
                List identities = iamPolicy.getIdentitiesList();
                CommandOutput.OutputHierarchy.OutputNode identityPolicyInfo = this.formatIdentityPolicyInfo(status, policy, identities, true);
                out.addNode(identityPolicyInfo);
            }
        } else {
            String errMsg = "Failed to get info for Identity Policy '" + policyName + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            if (resp.hasUsrMsg()) {
                errMsg = errMsg + " , user action: " + resp.getUsrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput listIdentityPolicy() throws CLIProcessingException, Exception {
        try {
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            this.list(out);
            return output;
        }
        catch (Exception exp) {
            throw new CLIProcessingException("Send request exception", (Throwable)exp);
        }
    }

    CommandOutput getIdentityPolicyMappings() throws CLIProcessingException, Exception {
        String roles;
        String groups;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        HashSet identities = new HashSet();
        String users = this.getUsers();
        if (users != null) {
            HashSet<String> userNames = this.getValues(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroups()) != null) {
            HashSet<String> groupNames = this.getValues(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if ((roles = this.getRoles()) != null) {
            HashSet<String> roleNames = this.getValues(roles, ",");
            HashSet<Integer> roleIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Role, roleNames, out);
            if (roleIds == null || roleIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(roleIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Role));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users, Groups or Roles specified"));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IdentityPolicyMappingsRequest req = PolicyServerProto.IdentityPolicyMappingsRequest.newBuilder().setCreds(this.getUserCredentials()).addAllIdentities(identities).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyMappingsProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IdentityPolicyMappingsResponse resp = PolicyServerProto.IdentityPolicyMappingsResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            for (PolicyServerProto.IdentityToPolicies mappingInfo : resp.getMappingsList()) {
                CommandOutput.OutputHierarchy.OutputNode mapIdentityPolicies = this.formatIdentityPolicyMapping(mappingInfo);
                out.addNode(mapIdentityPolicies);
            }
        } else {
            String errMsg = "Failed to get Identity Policy Mappings";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private int getIdFromName(PolicyServerProto.IdentityType type, String name) {
        int id = -1;
        if (type == PolicyServerProto.IdentityType.User) {
            id = this.uugh.getUserId(name);
        } else if (type == PolicyServerProto.IdentityType.Group) {
            id = this.uugh.getGroupId(name);
        } else if (type == PolicyServerProto.IdentityType.Role) {
            id = this.imrh.getRoleId(name);
        }
        return id;
    }

    private HashSet<Integer> getIdsFromNames(PolicyServerProto.IdentityType type, HashSet<String> names, CommandOutput.OutputHierarchy out) {
        HashSet<Integer> identites = new HashSet<Integer>();
        for (String name : names) {
            Integer id = null;
            String str = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)type);
            try {
                String errmsg;
                if (type == PolicyServerProto.IdentityType.User) {
                    id = this.uugh.getUserId(name);
                } else if (type == PolicyServerProto.IdentityType.Group) {
                    id = this.uugh.getGroupId(name);
                } else if (type == PolicyServerProto.IdentityType.Role) {
                    id = this.imrh.getRoleId(name);
                } else {
                    errmsg = String.format("getIdsFromNames not supported for %s: '%s'", str, name);
                    LOG.error((Object)errmsg);
                    if (out != null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                        return null;
                    }
                }
                if (id == null) {
                    errmsg = String.format("%s '%s' does not exist", str, name);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                    return null;
                }
                identites.add(id);
            }
            catch (Exception exp) {
                String errmsg = String.format("%s '%s' does not exist", str, name);
                LOG.error((Object)errmsg);
                if (out == null) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                return null;
            }
        }
        return identites;
    }

    private String getNameFromId(PolicyServerProto.IdentityType type, int id) {
        String name = null;
        if (type == PolicyServerProto.IdentityType.User) {
            name = this.uugh.getUsername(id);
        } else if (type == PolicyServerProto.IdentityType.Group) {
            name = this.uugh.getGroupname(id);
        } else if (type == PolicyServerProto.IdentityType.Role) {
            name = this.imrh.getRolename(id);
        }
        return name;
    }

    private HashSet<String> getNamesFromIds(PolicyServerProto.IdentityType type, HashSet<Integer> ids, CommandOutput.OutputHierarchy out) {
        HashSet<String> identites = new HashSet<String>();
        for (int id : ids) {
            String name = null;
            String str = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)type);
            try {
                String errmsg;
                if (type == PolicyServerProto.IdentityType.User) {
                    name = this.uugh.getUsername(id);
                } else if (type == PolicyServerProto.IdentityType.Group) {
                    name = this.uugh.getGroupname(id);
                } else if (type == PolicyServerProto.IdentityType.Role) {
                    name = this.imrh.getRolename(id);
                } else {
                    errmsg = String.format("getNamesFromIds not supported for %s: '%s'", str, name);
                    LOG.error((Object)errmsg);
                    if (out != null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                        return null;
                    }
                }
                if (name == null) {
                    errmsg = String.format("%s '%d' does not exist", str, id);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                    return null;
                }
                identites.add(name);
            }
            catch (Exception exp) {
                String errmsg = String.format("%s '%d' does not exist", str, id);
                LOG.error((Object)errmsg);
                if (out == null) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                return null;
            }
        }
        return identites;
    }

    private String getPolicyName() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_POLICY_PARAM_NAME) ? this.getParamTextValue(IDENTITY_POLICY_PARAM_NAME, 0) : null;
    }

    private String getUsers() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_POLICY_PARAM_USERS) ? this.getParamTextValue(IDENTITY_POLICY_PARAM_USERS, 0) : null;
    }

    private String getGroups() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_POLICY_PARAM_GROUPS) ? this.getParamTextValue(IDENTITY_POLICY_PARAM_GROUPS, 0) : null;
    }

    private String getRoles() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_POLICY_PARAM_ROLES) ? this.getParamTextValue(IDENTITY_POLICY_PARAM_ROLES, 0) : null;
    }

    private HashSet<String> getValues(String value, String seperator) {
        String[] tokens = value.split(seperator);
        HashSet<String> values = new HashSet<String>();
        for (int index = 0; index < tokens.length; ++index) {
            values.add(tokens[index].trim());
        }
        return values;
    }

    private String getString(HashSet<String> values) {
        return values != null && !values.isEmpty() ? String.join((CharSequence)",", values) : "";
    }

    private boolean getIsFileParamValue() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_POLICY_PARAM_IS_FILE) ? this.getParamBooleanValue(IDENTITY_POLICY_PARAM_IS_FILE, 0) : false;
    }

    private String getPolicyContent(boolean is_file) throws CLIProcessingException {
        String strParam;
        String string = strParam = this.isParamPresent(IDENTITY_POLICY_PARAM_POLICY) ? this.getParamTextValue(IDENTITY_POLICY_PARAM_POLICY, 0) : null;
        if (!is_file) {
            return strParam;
        }
        String strContent = "";
        try {
            if (!Files.exists(Paths.get(strParam, new String[0]), new LinkOption[0])) {
                throw new CLIProcessingException("Specified file '" + strParam + "' not found");
            }
            strContent = new String(Files.readAllBytes(Paths.get(strParam, new String[0])));
        }
        catch (FileNotFoundException fexp) {
            throw new CLIProcessingException(fexp.getMessage(), (Throwable)fexp);
        }
        catch (IOException ioexp) {
            throw new CLIProcessingException(ioexp.getMessage(), (Throwable)ioexp);
        }
        return strContent;
    }

    private byte[] sendRequestToPolicyServer(int procId, MessageLite request, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<PolicyServerProto.IdentityPolicyCreateResponse> responseClass = null;
        byte[] data = null;
        switch (procId) {
            case 13: {
                responseClass = PolicyServerProto.IdentityPolicyCreateResponse.class;
                break;
            }
            case 14: {
                responseClass = PolicyServerProto.IdentityPolicyModifyResponse.class;
                break;
            }
            case 15: {
                responseClass = PolicyServerProto.IdentityPolicyDeleteResponse.class;
                break;
            }
            case 16: {
                responseClass = PolicyServerProto.IdentityPolicyAssignResponse.class;
                break;
            }
            case 17: {
                responseClass = PolicyServerProto.IdentityPolicyUnassignResponse.class;
                break;
            }
            case 18: {
                responseClass = PolicyServerProto.IdentityPolicyInfoResponse.class;
                break;
            }
            case 19: {
                responseClass = PolicyServerProto.IdentityPolicyListResponse.class;
                break;
            }
            case 20: {
                responseClass = PolicyServerProto.IdentityPolicyMappingsResponse.class;
                break;
            }
            case 25: {
                responseClass = PolicyServerProto.ClusterActionsFetchResponse.class;
                break;
            }
            default: {
                return data;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send requestuest " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send requestuest " + procId));
            return data;
        }
        try {
            data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(procId, request, responseClass);
        }
        catch (Exception exp) {
            throw new CLIProcessingException((Throwable)exp);
        }
        return data;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityPolicyInfo(String strStatus, PolicyServerProto.PolicyInfoMsg policyInfo, List<PolicyServerProto.IdentityInfoMsg> identityInfoList, boolean verboseInfo) {
        Object strDateTime;
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        if (policyInfo.hasName()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyName).getName(false), (Object)policyInfo.getName()));
        }
        if (policyInfo.hasId()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyId).getName(false), policyInfo.getId()));
        }
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyDescription).getName(false), (Object)policyInfo.getDescription()));
        if (policyInfo.hasVersion()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyVersion).getName(false), (Object)policyInfo.getVersion()));
        }
        if (policyInfo.hasOwnerId()) {
            Object strOwner = "";
            try {
                strOwner = this.uugh.getUsername(policyInfo.getOwnerId());
            }
            catch (SecurityException se) {
                strOwner = "Uid " + policyInfo.getOwnerId();
            }
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyOwner).getName(false), strOwner));
        }
        if (policyInfo.hasCreatedEpoch()) {
            strDateTime = dateFormat.format(policyInfo.getCreatedEpoch());
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyCreated).getName(false), strDateTime));
        }
        if (policyInfo.hasUpdatedEpoch()) {
            strDateTime = dateFormat.format(policyInfo.getUpdatedEpoch());
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUpdated).getName(false), strDateTime));
        } else {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUpdated).getName(false), (Object)""));
        }
        if (policyInfo.hasIsActive()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyActive).getName(false), (Object)policyInfo.getIsActive()));
        }
        if (verboseInfo) {
            for (PolicyServerProto.StatementInfoMsg statementInfo : policyInfo.getStatementsList()) {
                CommandOutput.OutputHierarchy.OutputNode statement = new CommandOutput.OutputHierarchy.OutputNode();
                String strIdentifier = statementInfo.hasIdentifier() ? statementInfo.getIdentifier() : "";
                statement.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementIdentifier).getName(false), (Object)strIdentifier));
                statement.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatementEffect).getName(false), (Object)statementInfo.getEffect().toString()));
                HashSet<String> resourceUrns = new HashSet<String>();
                HashSet resourceActions = new HashSet();
                for (PolicyServerProto.ResourceInfoMsg resourceInfo : statementInfo.getResourcesList()) {
                    resourceUrns.add(IamSupportUtils.getResourceUrn((PolicyServerProto.ResourceInfoMsg)resourceInfo));
                    resourceActions = IamSupportUtils.getResourceActions((PolicyServerProto.ResourceInfoMsg)resourceInfo);
                }
                for (String resourceAction : resourceActions) {
                    CommandOutput.OutputHierarchy.OutputNode resourceActionsNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResourceAction).getName(false), (Object)resourceAction);
                    resourceActionsNode.setTreatSingleChildAsPeer(true);
                    statement.addChild(resourceActionsNode);
                }
                for (String resourceUrn : resourceUrns) {
                    CommandOutput.OutputHierarchy.OutputNode resourceUrnsNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyResource).getName(false), (Object)resourceUrn);
                    resourceUrnsNode.setTreatSingleChildAsPeer(true);
                    statement.addChild(resourceUrnsNode);
                }
                CommandOutput.OutputHierarchy.OutputNode statementNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatement).getName(false), (Object)statement);
                statementNode.setTreatSingleChildAsPeer(true);
                output.addChild(statementNode);
            }
        }
        CommandOutput.OutputHierarchy.OutputNode identities = this.formatIdentityInfoList(identityInfoList);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyIdentities).getName(false), (Object)identities));
        if (strStatus != null && !strStatus.isEmpty()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyStatus).getName(false), (Object)strStatus));
        }
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityInfoList(List<PolicyServerProto.IdentityInfoMsg> identityInfoList) {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        HashSet<PolicyServerProto.IdentityInfoMsg> identities = new HashSet<PolicyServerProto.IdentityInfoMsg>();
        if (identityInfoList != null && !identityInfoList.isEmpty()) {
            identities.addAll(identityInfoList);
        }
        HashSet userIds = IamSupportUtils.getUserIds(identities);
        HashSet<String> userNames = new HashSet<String>();
        if (userIds != null && !userIds.isEmpty()) {
            userNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.User, userIds, null));
        }
        String strUserNames = this.getString(userNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyUsers).getName(false), (Object)strUserNames));
        HashSet groupIds = IamSupportUtils.getGroupIds(identities);
        HashSet<String> groupNames = new HashSet<String>();
        if (groupIds != null && !groupIds.isEmpty()) {
            groupNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.Group, groupIds, null));
        }
        String strGroupNames = this.getString(groupNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyGroups).getName(false), (Object)strGroupNames));
        HashSet roleIds = IamSupportUtils.getRoleIds(identities);
        HashSet<String> roleNames = new HashSet<String>();
        if (roleIds != null && !roleIds.isEmpty()) {
            roleNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.Role, roleIds, null));
        }
        String strRoleNames = this.getString(roleNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IdentityPolicyInfoFields.iamPolicyRoles).getName(false), (Object)strRoleNames));
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityPolicyMapping(PolicyServerProto.IdentityToPolicies mapInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        PolicyServerProto.IdentityInfoMsg identity = mapInfo.getIdentity();
        String identityName = this.getNameFromId(identity.getType(), identity.getId());
        String identityType = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)identity.getType());
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IdType", (Object)identityType));
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IdName", (Object)identityName));
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IamPolicies", (Object)this.getString(new HashSet<String>((Collection<String>)mapInfo.getPoliciesList()))));
        return output;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        PolicyServerProto.IdentityPolicyListResponse resp = (PolicyServerProto.IdentityPolicyListResponse)response;
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        List iamPolicies = resp.getIamPoliciesList();
        for (PolicyServerProto.IdentityPolicyInfoMsg iamPolicy : iamPolicies) {
            if (iamPolicy == null) continue;
            String status = IamSupportUtils.getIdentityPolicyStatus((PolicyServerProto.IdentityPolicyStatus)iamPolicy.getStatus());
            PolicyServerProto.PolicyInfoMsg policy = iamPolicy.getPolicy();
            List identities = iamPolicy.getIdentitiesList();
            CommandOutput.OutputHierarchy.OutputNode iamInfo = this.formatIdentityPolicyInfo(status, policy, identities, false);
            out.addNode(iamInfo);
        }
    }

    public PolicyServerProto.IdentityPolicyListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        PolicyServerProto.IdentityPolicyListRequest req = (PolicyServerProto.IdentityPolicyListRequest)request;
        byte[] replyData = null;
        try {
            replyData = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IdentityPolicyListProc.getNumber(), (MessageLite)req, PolicyServerProto.IdentityPolicyListResponse.class);
        }
        catch (Exception exp) {
            throw new CLIProcessingException((Throwable)exp);
        }
        if (replyData != null) {
            try {
                return PolicyServerProto.IdentityPolicyListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into IdentityPolicyListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list identity policies failed. No data returned");
        return null;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM) ? this.getParamIntValue(LIMIT_PARAM, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM) ? this.getParamIntValue(START_PARAM, 0) : 0;
    }

    private PolicyServerProto.IdentityPolicyListRequest.Builder getIdentityPolicyListRequest() throws CLIProcessingException {
        PolicyServerProto.IdentityPolicyListRequest.Builder req = PolicyServerProto.IdentityPolicyListRequest.newBuilder();
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 100);
        return req.setCreds(this.getUserCredentials()).setLimiter(limiter);
    }

    public PolicyServerProto.IdentityPolicyListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        PolicyServerProto.IdentityPolicyListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? PolicyServerProto.IdentityPolicyListRequest.newBuilder((PolicyServerProto.IdentityPolicyListRequest)((PolicyServerProto.IdentityPolicyListRequest)prevReq)) : this.getIdentityPolicyListRequest();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((PolicyServerProto.IdentityPolicyListResponse)prevResp).getIamPoliciesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((PolicyServerProto.IdentityPolicyListRequest)prevReq).getLimiter().getStart(), ((PolicyServerProto.IdentityPolicyListResponse)prevResp).getIamPoliciesCount());
    }

    CommandOutput getUserActions() throws CLIProcessingException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String user = this.getParamTextValue(IDENTITY_POLICY_PARAM_USERNAME, 0);
        if (user == null || user.isBlank()) {
            LOG.error((Object)"getUserActions: Invalid usage, Missing param user");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "User name not provided"));
            return output;
        }
        String clustername = null;
        if (this.isParamPresent("cluster")) {
            clustername = this.getParamTextValue("cluster", 0);
        }
        UserResourceHelper usrResHelper = UserResourceHelper.getInstance();
        UserResourceHelper.UserRoleHelper roleHelper = usrResHelper.getUserRoleHelper(user, this.getUserCredentials(), clustername, out);
        roleHelper.fetchUserResourceActions();
        if (roleHelper.getStatus() != 0) {
            return output;
        }
        roleHelper.formatMergedActionMap();
        return output;
    }
}

