/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.mapr.cli.common.OnDiskImage;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import org.apache.log4j.Logger;

public class OndiskFileAccessor<T> {
    final String cksumAlgo;
    final long LIST_EXPIRY_MILLIS = 60000L;
    final String filename;
    OnDiskImage<T> onDiskObject;
    static final Logger LOG = Logger.getLogger(OndiskFileAccessor.class);

    public OndiskFileAccessor(String file, String algo) {
        this.filename = file;
        this.cksumAlgo = algo;
    }

    String getChecksumAlgorithm() {
        return this.cksumAlgo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeListToFile() {
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(this.filename);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(this.onDiskObject);
            LOG.debug((Object)("Serialized list (size:" + this.onDiskObject.list.size() + ") to file " + this.filename));
        }
        catch (IOException e) {
            LOG.error((Object)("IO Exception. Filename: " + this.filename), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("IO Exception. Filename: " + this.filename), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnDiskImage<T> deserializeListFromFile() {
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        OnDiskImage odObj = null;
        try {
            fileIn = new FileInputStream(this.filename);
            in = new ObjectInputStream(fileIn);
            odObj = (OnDiskImage)in.readObject();
            LOG.debug((Object)("List (size:" + odObj.list.size() + ") read from " + this.filename));
        }
        catch (EOFException i) {
            LOG.error((Object)("End of file " + this.filename), (Throwable)i);
        }
        catch (StreamCorruptedException e) {
            LOG.error((Object)("Stream is corrupted " + this.filename), (Throwable)e);
        }
        catch (InvalidClassException e) {
            LOG.error((Object)"Cant be casted to given class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"OnDiskImage class not found", (Throwable)e);
        }
        catch (FileNotFoundException i) {
            LOG.error((Object)("File not found " + this.filename), (Throwable)i);
        }
        catch (IOException i) {
            LOG.error((Object)("IO exception " + this.filename), (Throwable)i);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("IO exception closing file " + this.filename), (Throwable)e);
            }
        }
        return odObj;
    }

    public String getSortkey() {
        return this.onDiskObject.sortKey;
    }

    public List<T> getList(String key) {
        return this.onDiskObject.list;
    }

    public void updateListToFile(List<T> list, String sortkey) {
        if (this.onDiskObject.list == null || this.onDiskObject.list.size() != list.size() || sortkey != null && !sortkey.equalsIgnoreCase(this.onDiskObject.sortKey)) {
            this.onDiskObject.list = list;
            this.onDiskObject.sortKey = sortkey;
            if (this.onDiskObject.createStamp == 0L) {
                this.onDiskObject.createStamp = System.currentTimeMillis();
                LOG.info((Object)("updateListToFile: updating create time:" + this.onDiskObject.createStamp));
            }
            this.onDiskObject.checksum = this.onDiskObject.getListCheckSum(this.cksumAlgo);
            this.serializeListToFile();
        }
    }

    public List<T> getListFromFile() {
        this.onDiskObject = this.deserializeListFromFile();
        if (this.onDiskObject != null && this.isListUsable()) {
            return this.onDiskObject.list;
        }
        this.onDiskObject = new OnDiskImage();
        return null;
    }

    public boolean isListUsable() {
        Object fileIn = null;
        Object in = null;
        long now = System.currentTimeMillis();
        LOG.debug((Object)("File timestamp: " + this.onDiskObject.createStamp + ", now:" + now));
        if (now - this.onDiskObject.createStamp > 60000L) {
            LOG.error((Object)("File timestamp: " + this.onDiskObject.createStamp + ", now:" + now + ", persisted list expired."));
            return false;
        }
        String checksum = this.onDiskObject.getListCheckSum(this.cksumAlgo);
        LOG.debug((Object)("File checksum: " + this.onDiskObject.checksum + ", list checksum:" + checksum));
        if (!checksum.equals(this.onDiskObject.checksum)) {
            LOG.error((Object)("Checksum mismatch, stream is corrupted. File checksum: " + this.onDiskObject.checksum + ", list checksum:" + checksum));
            return false;
        }
        return true;
    }
}

