/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.JNIFileTierStatus;
import com.mapr.login.client.MapRLoginHttpsClient;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class FileTierCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String FILE_PARAM_NAME = "name";
    public static final String JOB_PARAM_NAME = "job";
    private static final Logger LOG = Logger.getLogger(FileTierCommands.class);
    public static final String offloadUsage = "file offload -name <filename>";
    public static final String recallUsage = "file recall -name <filename>";
    public static final String terminateUsage = "file tierjobterminate -name <filename>";
    public static final String tierjobstatusUsage = "file tierjobstatus -name <filename> [-job <jobid>]";
    public static final String tierstatusUsage = "file tierstatus -name <filename>";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand offloadCommand = new CLICommand("offload", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("file offload -name <filename>");
    public static final CLICommand recallCommand = new CLICommand("recall", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("file recall -name <filename>");
    public static final CLICommand tierjobstatusCommand = new CLICommand("tierjobstatus", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"job", (Object)new TextInputParameter("job", "jobid", false, null)).build(), null).setShortUsage("file tierjobstatus -name <filename> [-job <jobid>]");
    public static final CLICommand tierstatusCommand = new CLICommand("tierstatus", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("file tierstatus -name <filename>");
    public static final CLICommand abortCommand = new CLICommand("tierjobabort", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"job", (Object)new TextInputParameter("job", "jobid", false, null)).build(), null).setShortUsage("file tierjobterminate -name <filename>").setUsageInVisible(true);
    public static final CLICommand terminateCommand = new CLICommand("tierjobterminate", "", FileTierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"job", (Object)new TextInputParameter("job", "jobid", false, null)).build(), null).setShortUsage("file tierjobterminate -name <filename>");
    private static final BigInteger TWO_64 = BigInteger.ONE.shiftLeft(64);

    public FileTierCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public String asUnsignedDecimalString(long l) {
        BigInteger b = BigInteger.valueOf(l);
        if (b.signum() < 0) {
            b = b.add(TWO_64);
        }
        return b.toString(16);
    }

    private String ftidStr(JNIFileTierStatus fts) {
        long shaHashHigh = fts.shaHashHigh;
        long shaHashLow = fts.shaHashLow;
        long uniq = fts.uniq;
        return "0x" + this.asUnsignedDecimalString(fts.shaHashHigh) + ".0x" + this.asUnsignedDecimalString(fts.shaHashLow) + ".0x" + this.asUnsignedDecimalString(fts.uniq);
    }

    long[] strToFtid(String jobid) {
        boolean jobIdValid = false;
        String[] subs = jobid.split("\\.");
        long[] ftId = new long[3];
        String myout = "";
        if (subs != null && subs.length == 3) {
            try {
                for (int i = 0; i < 3; ++i) {
                    String curr = subs[i].toLowerCase();
                    int radix = 10;
                    if (curr.startsWith("0x")) {
                        radix = 16;
                        curr = curr.substring(2);
                    } else if (curr.startsWith("0")) {
                        radix = 8;
                        curr = curr.substring(1);
                    }
                    BigInteger b = new BigInteger(curr, radix);
                    if (b.signum() < 0) {
                        b = b.add(TWO_64);
                    }
                    ftId[i] = b.longValue();
                }
                jobIdValid = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jobIdValid) {
            return ftId;
        }
        return null;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String cluster = null;
        String fileName = null;
        Object credentials = null;
        String jobid = null;
        long[] ftId = null;
        long shaHigh = 0L;
        long shaLow = 0L;
        long uniq = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        try {
            String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            MapRLoginHttpsClient client = new MapRLoginHttpsClient();
            client.authenticateIfNeeded(clusterName);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception unable to authenticate ", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Authentication failed. Retry after obtaining a new ticket using maprlogin"));
            return output;
        }
        String cmd = this.cliCommand.getCommandName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if (this.isParamPresent(FILE_PARAM_NAME)) {
            fileName = this.getParamTextValue(FILE_PARAM_NAME, 0);
        }
        if (this.isParamPresent(JOB_PARAM_NAME)) {
            jobid = this.getParamTextValue(JOB_PARAM_NAME, 0);
            ftId = this.strToFtid(jobid);
            if (ftId == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid jobid.  JobId must be of the form <num>.<num>.<num>."));
                return output;
            }
            shaHigh = ftId[0];
            shaLow = ftId[1];
            uniq = ftId[2];
        }
        CLDBProto.FileTierOp opcode = CLDBProto.FileTierOp.FILE_TIERSTATUS;
        String opString = null;
        if (this.cliCommand.getCommandName().equalsIgnoreCase("offload")) {
            opcode = CLDBProto.FileTierOp.FILE_OFFLOAD;
            opString = "offload";
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("recall")) {
            opcode = CLDBProto.FileTierOp.FILE_RECALL;
            opString = "recall";
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobabort") || this.cliCommand.getCommandName().equalsIgnoreCase("tierjobterminate")) {
            opcode = CLDBProto.FileTierOp.FILE_ABORT;
            opString = "tierjobterminate";
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("tierjobstatus")) {
            opcode = CLDBProto.FileTierOp.FILE_TIEROP_STATUS;
            opString = "tierjobstatus";
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("tierstatus")) {
            opcode = CLDBProto.FileTierOp.FILE_TIERSTATUS;
            opString = "tierstatus";
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            JNIFileTierStatus fts = fs.tierOp(opcode.getNumber(), new Path(fileName), false, false, shaHigh, shaLow, uniq);
            if (fts == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(14, "Error handling the command."));
                return output;
            }
            if (opcode == CLDBProto.FileTierOp.FILE_OFFLOAD || opcode == CLDBProto.FileTierOp.FILE_RECALL || opcode == CLDBProto.FileTierOp.FILE_ABORT || opcode == CLDBProto.FileTierOp.FILE_TIEROP_STATUS || opcode == CLDBProto.FileTierOp.FILE_TIERSTATUS) {
                // empty if block
            }
            CLDBProto.FileTierOpStatus tos = CLDBProto.FileTierOpStatus.values()[fts.fileTierOpStatus];
            boolean error = false;
            if (tos == CLDBProto.FileTierOpStatus.OP_FAIL || tos == CLDBProto.FileTierOpStatus.INVALID_FILE || tos == CLDBProto.FileTierOpStatus.FILE_NOT_TIERED || tos == CLDBProto.FileTierOpStatus.FILE_EMPTY || tos == CLDBProto.FileTierOpStatus.NO_GATEWAY || tos == CLDBProto.FileTierOpStatus.OP_TIMEOUT || tos == CLDBProto.FileTierOpStatus.FTOS_EPERM || tos == CLDBProto.FileTierOpStatus.FTOS_JOB_NOT_AVAILABLE) {
                error = true;
            }
            CommandOutput.OutputHierarchy.OutputNode opNode = new CommandOutput.OutputHierarchy.OutputNode(opString);
            if (error) {
                if (fts.message != null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(fts.fileTierOpStatus, fts.message));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(fts.fileTierOpStatus, ""));
                }
                return output;
            }
            opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("status", fts.fileTierOpStatus));
            if (fts.message != null) {
                opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("message", (Object)fts.message));
            } else {
                opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("message", (Object)""));
            }
            if (opcode != CLDBProto.FileTierOp.FILE_TIERSTATUS) {
                if (fts.gateway != null) {
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)fts.gateway));
                } else {
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("gateway", (Object)""));
                }
            }
            if (opcode == CLDBProto.FileTierOp.FILE_TIEROP_STATUS) {
                String opStr = null;
                if (tos != CLDBProto.FileTierOpStatus.FTOS_JOB_NOT_AVAILABLE) {
                    CLDBProto.FileTierOp retOpcode = CLDBProto.FileTierOp.FILE_TIEROP_STATUS;
                    retOpcode = CLDBProto.FileTierOp.values()[fts.retOpcode];
                    switch (retOpcode) {
                        case FILE_OFFLOAD: {
                            opStr = "Offload";
                            break;
                        }
                        case FILE_RECALL: {
                            opStr = "Recall";
                            break;
                        }
                        case FILE_TIERSTATUS: {
                            opStr = "Status";
                            break;
                        }
                        case FILE_ABORT: {
                            opStr = "Terminate";
                            break;
                        }
                        case FILE_TIEROP_STATUS: {
                            opStr = "Status";
                        }
                    }
                } else {
                    opStr = "Not Available";
                }
                if (opStr != null) {
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("op", (Object)opStr));
                }
                if (!error) {
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("completedFids", fts.completedFids));
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("failedFids", fts.failedFids));
                    opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalFids", fts.totalFids));
                }
            }
            if (!(error || opcode != CLDBProto.FileTierOp.FILE_OFFLOAD && opcode != CLDBProto.FileTierOp.FILE_RECALL && opcode != CLDBProto.FileTierOp.FILE_ABORT)) {
                String ftid = this.ftidStr(fts);
                opNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("jobid", (Object)this.ftidStr(fts)));
            }
            out.addNode(opNode);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid op."));
        }
        return output;
    }
}

