/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Security;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class VolumeDumpFileCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeDumpFileCommands.class);
    public static final String VOLUME_PARAM_NAME = "name";
    public static final String DUMP_FILE_NAME = "dumpfile";
    public static final String START_VOLUME_POINT_NAME = "s";
    public static final String END_VOLUME_POINT_NAME = "e";
    public static final String DUMP_FILE_ON_STDOUT = "o";
    public static final String DUMP_FILE_FROM_STDIN = "i";
    public static final String CREATE_NEW_VOLUME = "n";
    public static final String FULL_VOLUME_RESTORE = "full";
    Security.CredentialsMsg srcCreds;
    Security.CredentialsMsg dstCreds;
    public static final String createDumpUsage = "volume dump create [-s startvolumepoint name] [-e endvolumepoint name] [-o (for dumpfile on stdout)]  -name volumename -dumpfile dumpfilename (ignored if -o specified) [-cluster clustername]";
    public static final String restoreDumpUsage = "volume dump restore [-i (read dumpfile from stdin)] [-n (create new volume if volume doesn't exist)] -name volumename -dumpfile dumpfile (ignored if -i specified)[-cluster clustername]";
    public static final CLICommand createDumpCommand = new CLICommand("create", "", VolumeDumpFileCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"s", (Object)new TextInputParameter("s", "start volumepoint name", false, null)).put((Object)"e", (Object)new TextInputParameter("e", "end volumepoint name", false, null)).put((Object)"o", (Object)new TextInputParameter("o", "(generate dumpfile on stdout)", false, null)).put((Object)"dumpfile", (Object)new TextInputParameter("dumpfile", "dumpfilename (not needed if -o is used)", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "volumename", true, null)).build(), null).setShortUsage("volume dump create [-s startvolumepoint name] [-e endvolumepoint name] [-o (for dumpfile on stdout)]  -name volumename -dumpfile dumpfilename (ignored if -o specified) [-cluster clustername]");
    public static final CLICommand restoreDumpCommand = new CLICommand("restore", "", VolumeDumpFileCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"i", (Object)new TextInputParameter("i", "(read dumpfile from stdin)", false, null)).put((Object)"n", (Object)new TextInputParameter("n", "(create new volume if it doesn't exist)", false, null)).put((Object)"dumpfile", (Object)new TextInputParameter("dumpfile", "dumpfilename (not needed if -i is used)", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "volumename", true, null)).put((Object)"full", (Object)new TextInputParameter("full", "<true|false> (perform full volume restore, default:false)", false, null)).build(), null).setShortUsage("volume dump restore [-i (read dumpfile from stdin)] [-n (create new volume if volume doesn't exist)] -name volumename -dumpfile dumpfile (ignored if -i specified)[-cluster clustername]");
    public static CLICommand[] dumpCommandsArray = new CLICommand[]{createDumpCommand, restoreDumpCommand};
    public static CLICommand dumpCommands = new CLICommand("dump", "dump", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, dumpCommandsArray).setShortUsage("dump [create|restore]");

    public VolumeDumpFileCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.createDump();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Create dump Exception ", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("restore")) {
            try {
                return this.restoreDump();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Restore dump Exception", (Throwable)e);
            }
        }
        return null;
    }

    private CommandOutput createDump() throws CLIProcessingException {
        Object dumpDir;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String startPointName = this.isParamPresent(START_VOLUME_POINT_NAME) ? this.getParamTextValue(START_VOLUME_POINT_NAME, 0) : null;
        String endPointName = this.isParamPresent(END_VOLUME_POINT_NAME) ? this.getParamTextValue(END_VOLUME_POINT_NAME, 0) : null;
        String clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
        String volumeName = this.getParamTextValue(VOLUME_PARAM_NAME, 0);
        String dumpFile = this.getParamTextValue(DUMP_FILE_NAME, 0);
        if (dumpFile.startsWith("/")) {
            dumpDir = dumpFile;
        } else {
            dumpDir = System.getProperty("user.dir") + "/" + dumpFile;
            LOG.debug((Object)("No directory specified in the command, dump file path " + (String)dumpDir));
        }
        if (this.isParamPresent(DUMP_FILE_ON_STDOUT)) {
            LOG.error((Object)"o param not valid. Cannot output dump to stdout.");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "o param not valid. Cannot output dump to stdout"));
            return output;
        }
        LOG.info((Object)("Creating dumpfile for volume " + volumeName + " with file name " + (String)dumpDir));
        ArrayList<String> command = new ArrayList<String>();
        command.add("/opt/mapr/bin/dumpclient");
        command.add("volume");
        command.add("dump");
        command.add("create");
        command.add("-name");
        command.add(volumeName);
        command.add("-dumpfile");
        command.add((String)dumpDir);
        if (startPointName != null) {
            command.add("-s");
            command.add(startPointName);
        }
        if (endPointName != null) {
            command.add("-e");
            command.add(endPointName);
        }
        if (clusterName != null) {
            command.add("-cluster");
            command.add(clusterName);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            Process p = builder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                if (!s.trim().isEmpty()) continue;
            }
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdErr.readLine()) != null) {
            }
            int status = p.waitFor();
            if (status != 0) {
                throw new CLIProcessingException("Dump creation failed ");
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Dump creation failed ", (Throwable)e);
        }
        LOG.debug((Object)("Volume dump file " + (String)dumpDir + " created for volume " + volumeName));
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("message", (Object)("Successfully created dump for volume " + volumeName)));
        return output;
    }

    private CommandOutput restoreDump() throws CLIProcessingException {
        String clusterName;
        String volumeName;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String string = volumeName = this.isParamPresent(VOLUME_PARAM_NAME) ? this.getParamTextValue(VOLUME_PARAM_NAME, 0) : null;
        if (volumeName == null) {
            LOG.error((Object)"Missing Volume Name Param");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing Volume Name Param"));
            return output;
        }
        String string2 = clusterName = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
        if (this.isParamPresent(DUMP_FILE_FROM_STDIN)) {
            LOG.error((Object)"i param not valid. Cannot read dump from stdin.");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "i param not valid. Cannot read dump from stdin"));
            return output;
        }
        String createNewVolume = this.isParamPresent(CREATE_NEW_VOLUME) ? "-n" : null;
        String dumpFile = null;
        if (!this.isParamPresent(DUMP_FILE_NAME)) {
            LOG.error((Object)"dumpfile param required.");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "dumpfile param required."));
            return output;
        }
        dumpFile = this.getParamTextValue(DUMP_FILE_NAME, 0);
        String isFullVolumeRestore = this.isParamPresent(FULL_VOLUME_RESTORE) ? this.getParamTextValue(FULL_VOLUME_RESTORE, 0) : "false";
        LOG.info((Object)("Restoring volume " + volumeName + " for dumpFile " + dumpFile));
        ArrayList<String> command = new ArrayList<String>();
        command.add("maprcli");
        command.add("volume");
        command.add("dump");
        command.add("restore");
        command.add("-name");
        command.add(volumeName);
        if (clusterName != null) {
            command.add("-cluster");
            command.add(clusterName);
        }
        command.add("-dumpfile");
        command.add(dumpFile);
        command.add("-full");
        command.add(isFullVolumeRestore);
        if (createNewVolume != null) {
            command.add("-n");
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        StringBuilder cmd = new StringBuilder();
        for (String str : builder.command()) {
            cmd.append(str).append(" ");
        }
        LOG.debug((Object)("Command: " + cmd));
        Process process = null;
        try {
            process = builder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = stdInput.readLine()) != null) {
                if (!line.trim().isEmpty()) continue;
            }
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stdErr.readLine()) != null) {
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CLIProcessingException("Volume dump restore failed with exit code " + exitCode);
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Dump creation failed", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        LOG.info((Object)("Restored volume " + volumeName + " for dumpfile " + dumpFile));
        oh.addNode(new CommandOutput.OutputHierarchy.OutputNode("message", (Object)("Successfully restored volume " + volumeName)));
        return output;
    }

    void init() throws CLIProcessingException {
        this.srcCreds = this.getUserCredentials();
        this.dstCreds = this.getUserCredentials();
    }
}

