/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.ConfigCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtelEndPointCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(OtelEndPointCommands.class);
    public static final String ENDPOINT_PARAM_NAME = "name";
    public static final String ENDPOINT_PARAM_FQDN = "url";
    public static final String ENDPOINT_PARAM_PORT = "port";
    public static final String ENDPOINT_PARAM_KEY = "key";
    public static final String ENDPOINT_PARAM_CERT = "cert";
    public static final String ENDPOINT_PARAM_KEY_FILE = "keyfile";
    public static final String ENDPOINT_PARAM_CERT_FILE = "certfile";
    public static final String ENDPOINT_PARAM_CUSTOM_OPTS = "customopts";
    public static final String ENDPOINT_PARAM_CUSTOM_OPTS_FILE = "customoptsfile";
    Security.CredentialsMsg creds;
    public static Map<String, BaseInputParameter> nameParams = new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "end point name", true, null)).build();
    public static Map<String, BaseInputParameter> portParams = new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, null)).build();
    public static Map<String, BaseInputParameter> fqdnParams = new ImmutableMap.Builder().put((Object)"url", (Object)new TextInputParameter("url", "http[s]://hostname", true, null)).build();
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static Map<String, BaseInputParameter> keyParams = new ImmutableMap.Builder().put((Object)"key", (Object)new TextInputParameter("key", "Base64 encoded key", false, null)).build();
    public static Map<String, BaseInputParameter> keyFileParams = new ImmutableMap.Builder().put((Object)"keyfile", (Object)new TextInputParameter("keyfile", "key file path", false, null)).build();
    public static Map<String, BaseInputParameter> certParams = new ImmutableMap.Builder().put((Object)"cert", (Object)new TextInputParameter("cert", "Base64 encoded certificate", false, null)).build();
    public static Map<String, BaseInputParameter> certFileParams = new ImmutableMap.Builder().put((Object)"certfile", (Object)new TextInputParameter("certfile", "certificate file path", false, null)).build();
    public static Map<String, BaseInputParameter> customOptsParams = new ImmutableMap.Builder().put((Object)"customopts", (Object)new TextInputParameter("customopts", "json formatted custom options", false, null)).build();
    public static Map<String, BaseInputParameter> customOptsFileParams = new ImmutableMap.Builder().put((Object)"customoptsfile", (Object)new TextInputParameter("customoptsfile", "path to json formatted custom options", false, null)).build();
    public static final String addEndPointCommandUsage = "otelendpoint add -name <identifier name for the end point>-url <url for endpoint> -port <port on which end points listens from otel>-keyfile <key-file> -certfile <-certificate-file> [-key <base64-encoded-key>][-cert <base64-encoded-cert>-customopts <json-formatted-key-values-customoptsfile <json-formatted-key-values-file>";
    public static final String updateEndPointCommandUsage = "otelendpoint update -name <identifier name for the end point>-url <url for endpoint> -port <port on which end points listens from otel>-keyfile <key-file> -certfile <-certificate-file> [-key <base64-encoded-key>][-cert <base64-encoded-cert>-customopts <json-formatted-key-values-customoptsfile <json-formatted-key-values-file>";
    public static final String infoEndPointCommandUsage = "otelendpoint info -name <identifier name for the end point>";
    public static final String removeEndPointCommandUsage = "otelendpoint remove -name <identifier name for the end point>";
    public static final String listEndPointCommandUsage = "otelendpoint list ";
    static final CLICommand addEndPointCommand = new CLICommand("add", "", OtelEndPointCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(fqdnParams).putAll(portParams).putAll(keyParams).putAll(keyFileParams).putAll(certParams).putAll(certFileParams).putAll(customOptsParams).putAll(customOptsFileParams).putAll(baseParams).build(), null).setShortUsage("otelendpoint add -name <identifier name for the end point>-url <url for endpoint> -port <port on which end points listens from otel>-keyfile <key-file> -certfile <-certificate-file> [-key <base64-encoded-key>][-cert <base64-encoded-cert>-customopts <json-formatted-key-values-customoptsfile <json-formatted-key-values-file>");
    static final CLICommand updateEndPointCommand = new CLICommand("update", "", OtelEndPointCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(fqdnParams).putAll(portParams).putAll(keyParams).putAll(keyFileParams).putAll(certParams).putAll(certFileParams).putAll(customOptsParams).putAll(customOptsFileParams).putAll(baseParams).build(), null).setShortUsage("otelendpoint update -name <identifier name for the end point>-url <url for endpoint> -port <port on which end points listens from otel>-keyfile <key-file> -certfile <-certificate-file> [-key <base64-encoded-key>][-cert <base64-encoded-cert>-customopts <json-formatted-key-values-customoptsfile <json-formatted-key-values-file>");
    static final CLICommand infoEndPointCommand = new CLICommand("info", "", OtelEndPointCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(baseParams).build(), null).setShortUsage("otelendpoint info -name <identifier name for the end point>");
    static final CLICommand removeEndPointCommand = new CLICommand("remove", "", OtelEndPointCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(nameParams).putAll(baseParams).build(), null).setShortUsage("otelendpoint remove -name <identifier name for the end point>");
    static final CLICommand listEndPointCommand = new CLICommand("list", "", OtelEndPointCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("otelendpoint list ");
    public static final CLICommand otelEndPointCommands = new CLICommand("otelendpoint", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addEndPointCommand, updateEndPointCommand, removeEndPointCommand, infoEndPointCommand, listEndPointCommand}).setShortUsage("otelendpoint [add|update|info|remove|list]");
    private CLICommand cliCommand;

    public OtelEndPointCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
        this.cliCommand = cliCommand;
        this.creds = this.getUserCredentials();
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("add")) {
            this.addEndPoint(out);
        } else if (cmd.equalsIgnoreCase("update")) {
            this.updateEndPoint(out);
        } else if (cmd.equalsIgnoreCase("info")) {
            this.infoEndPoint(out);
        } else if (cmd.equalsIgnoreCase("list")) {
            this.listEndPoints(out);
        } else if (cmd.equalsIgnoreCase("remove")) {
            this.removeEndPoint(out);
        }
        return output;
    }

    private String getClusterName() throws CLIProcessingException {
        return this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
    }

    private String getEndPointName() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_NAME) ? this.getParamTextValue(ENDPOINT_PARAM_NAME, 0) : null;
    }

    private String getEndPointFqdn() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_FQDN) ? this.getParamTextValue(ENDPOINT_PARAM_FQDN, 0) : null;
    }

    private int getEndPointPort() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_PORT) ? this.getParamIntValue(ENDPOINT_PARAM_PORT, 0) : 0;
    }

    private String getEndPointKey() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_KEY) ? this.getParamTextValue(ENDPOINT_PARAM_KEY, 0) : null;
    }

    private String getEndPointCert() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_CERT) ? this.getParamTextValue(ENDPOINT_PARAM_CERT, 0) : null;
    }

    private String getEndPointKeyPath() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_KEY_FILE) ? this.getParamTextValue(ENDPOINT_PARAM_KEY_FILE, 0) : null;
    }

    private String getEndPointCertPath() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_CERT_FILE) ? this.getParamTextValue(ENDPOINT_PARAM_CERT_FILE, 0) : null;
    }

    private String getEndPointCustomOpts() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_CUSTOM_OPTS) ? this.getParamTextValue(ENDPOINT_PARAM_CUSTOM_OPTS, 0) : null;
    }

    private String getEndPointCustomOptsPath() throws CLIProcessingException {
        return this.isParamPresent(ENDPOINT_PARAM_CUSTOM_OPTS_FILE) ? this.getParamTextValue(ENDPOINT_PARAM_CUSTOM_OPTS_FILE, 0) : null;
    }

    private void addEndPoint(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.OtelEndPointAddRequest req;
        byte[] data;
        this.getClusterName();
        String name = this.getEndPointName();
        String fqdn = this.getEndPointFqdn();
        int port = this.getEndPointPort();
        String keyPath = this.getEndPointKeyPath();
        String certPath = this.getEndPointCertPath();
        String key = this.getEndPointKey();
        String cert = this.getEndPointCert();
        String customOpts = this.getEndPointCustomOpts();
        String customOptsPath = this.getEndPointCustomOptsPath();
        if (key != null && keyPath != null) {
            String err = "Please provide either one of base64 encoded key or path to keyfile";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (cert != null && certPath != null) {
            String err = "Please provide either one of base64 encoded cert or path to certfile";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (customOpts != null && customOptsPath != null) {
            String err = "Please provide either one of json formatted custom opts or path to custom opts file";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (key == null && keyPath != null) {
            try {
                key = this.readAndEncode(keyPath);
            }
            catch (IOException e) {
                String err = "unable to read key file: " + keyPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if (cert == null && certPath != null) {
            try {
                cert = this.readAndEncode(certPath);
            }
            catch (IOException e) {
                String err = "unable to read cert file: " + certPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if (customOpts == null && customOptsPath != null) {
            try {
                customOpts = new String(Files.readAllBytes(Paths.get(customOptsPath, new String[0])));
            }
            catch (IOException e) {
                String err = "unable to read custom opts file: " + customOptsPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if ((data = this.sendRequestToCLDB(CLDBProto.CLDBProg.OtelEndPointAddProc, (MessageLite)(req = CLDBProto.OtelEndPointAddRequest.newBuilder().setEndPoint(this.prepareEndPoint(name, fqdn, port, key, cert, customOpts)).build()), out)) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response received. check cldb logs"));
            return;
        }
        CLDBProto.OtelEndPointAddResponse resp = null;
        try {
            resp = CLDBProto.OtelEndPointAddResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            String err = "exception in add end point rpc" + e;
            LOG.error((Object)err, (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (resp.getStatus() == 0) {
            out.addMessage("end point added successfully");
        } else {
            String err = "add end point rpc failed with err:" + resp.getStatus() + ". " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), err));
            LOG.error((Object)err);
        }
    }

    private String readAndEncode(String filePath) throws IOException {
        byte[] contents = Files.readAllBytes(Paths.get(filePath, new String[0]));
        return new String(Base64.getEncoder().encode(contents));
    }

    private CLDBProto.OtelEndPoint prepareEndPoint(String name, String fqdn, int port, String key, String cert, String customOpts) {
        Common.IPAddress.Builder addr = Common.IPAddress.newBuilder().setHostname(fqdn);
        if (port != 0) {
            addr.setPort(port);
        }
        CLDBProto.OtelEndPoint.Builder builder = CLDBProto.OtelEndPoint.newBuilder().setName(name).setAddr(addr.build());
        if (key != null) {
            builder.setKey(key);
        }
        if (cert != null) {
            builder.setCertificate(cert);
        }
        if (customOpts != null) {
            Map<String, String> keyValues = ConfigCommands.parseParamsFromJSONObject(customOpts);
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                builder.addCustomOptions(CLDBProto.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
            }
        }
        return builder.build();
    }

    private void infoEndPoint(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this.getClusterName();
        String name = this.getEndPointName();
        CLDBProto.OtelEndPointInfoRequest req = CLDBProto.OtelEndPointInfoRequest.newBuilder().setEndPointName(name).build();
        byte[] data = this.sendRequestToCLDB(CLDBProto.CLDBProg.OtelEndPointInfoProc, (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response received. check cldb logs"));
            return;
        }
        CLDBProto.OtelEndPointInfoResponse resp = null;
        try {
            resp = CLDBProto.OtelEndPointInfoResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            String err = "Exception in getting endpoint info rpc" + e;
            LOG.error((Object)err, (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (resp.getStatus() == 0) {
            this.addEndPoint(resp.getEndPoint(), out);
        } else {
            String err = "end point info rpc failed with err:" + resp.getStatus() + ". " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), err));
            LOG.error((Object)err);
        }
    }

    private void removeEndPoint(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String name = this.getEndPointName();
        CLDBProto.OtelEndPointRemoveRequest req = CLDBProto.OtelEndPointRemoveRequest.newBuilder().setEndPointName(name).build();
        byte[] data = this.sendRequestToCLDB(CLDBProto.CLDBProg.OtelEndPointRemoveProc, (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response received. check cldb logs"));
            return;
        }
        CLDBProto.OtelEndPointRemoveResponse resp = null;
        try {
            resp = CLDBProto.OtelEndPointRemoveResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            String err = "Exception in removing endpoint rpc" + e;
            LOG.error((Object)err, (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (resp.getStatus() == 0) {
            out.addMessage("end point removed successfully");
        } else {
            String err = "remove end point rpc failed with err:" + resp.getStatus() + ". " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), err));
            LOG.error((Object)err);
        }
    }

    private void listEndPoints(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.OtelEndPointListRequest req = CLDBProto.OtelEndPointListRequest.newBuilder().setCreds(this.creds).build();
        byte[] data = this.sendRequestToCLDB(CLDBProto.CLDBProg.OtelEndPointListProc, (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response received. check cldb logs"));
            return;
        }
        CLDBProto.OtelEndPointListResponse resp = null;
        try {
            resp = CLDBProto.OtelEndPointListResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            String err = "exception in list end point rpc" + e;
            LOG.error((Object)err, (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (resp.getStatus() == 0) {
            for (CLDBProto.OtelEndPoint endPoint : resp.getEndPointsList()) {
                this.addEndPoint(endPoint, out);
            }
        } else {
            String err = "list end point rpc failed with err:" + resp.getStatus() + ". " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), err));
            LOG.error((Object)err);
        }
    }

    private void updateEndPoint(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.OtelEndPointUpdateRequest req;
        byte[] data;
        this.getClusterName();
        String name = this.getEndPointName();
        String fqdn = this.getEndPointFqdn();
        int port = this.getEndPointPort();
        String keyPath = this.getEndPointKeyPath();
        String certPath = this.getEndPointCertPath();
        String key = this.getEndPointKey();
        String cert = this.getEndPointCert();
        String customOpts = this.getEndPointCustomOpts();
        String customOptsPath = this.getEndPointCustomOptsPath();
        if (key != null && keyPath != null) {
            String err = "Please provide either one of base64 encoded key or path to keyfile";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (cert != null && certPath != null) {
            String err = "Please provide either one of base64 encoded cert or path to certfile";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (customOpts != null && customOptsPath != null) {
            String err = "Please provide either one of json formatted custom opts or path to custom opts file";
            LOG.error((Object)err);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (key == null && keyPath != null) {
            try {
                key = this.readAndEncode(keyPath);
            }
            catch (IOException e) {
                String err = "unable to read key file: " + keyPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if (cert == null && certPath != null) {
            try {
                cert = this.readAndEncode(certPath);
            }
            catch (IOException e) {
                String err = "unable to read cert file: " + certPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if (customOpts == null && customOptsPath != null) {
            try {
                customOpts = new String(Files.readAllBytes(Paths.get(customOptsPath, new String[0])));
            }
            catch (IOException e) {
                String err = "unable to read custom opts file: " + customOptsPath;
                LOG.error((Object)err, (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                return;
            }
        }
        if ((data = this.sendRequestToCLDB(CLDBProto.CLDBProg.OtelEndPointUpdateProc, (MessageLite)(req = CLDBProto.OtelEndPointUpdateRequest.newBuilder().setEndPoint(this.prepareEndPoint(name, fqdn, port, key, cert, customOpts)).build()), out)) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response received. check cldb logs"));
            return;
        }
        CLDBProto.OtelEndPointUpdateResponse resp = null;
        try {
            resp = CLDBProto.OtelEndPointUpdateResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            String err = "exception in updating end point rpc" + e;
            LOG.error((Object)err, (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
            return;
        }
        if (resp.getStatus() == 0) {
            out.addMessage("end point updated successfully");
        } else {
            String err = "update end point rpc failed with err:" + resp.getStatus() + ". " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), err));
            LOG.error((Object)err);
        }
    }

    void addEndPoint(CLDBProto.OtelEndPoint endPoint, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode epNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (endPoint.hasName()) {
            epNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_NAME, (Object)endPoint.getName()));
        }
        if (endPoint.hasAddr()) {
            Common.IPAddress addr = endPoint.getAddr();
            if (addr.hasHostname()) {
                epNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_FQDN, (Object)addr.getHostname()));
            }
            if (addr.hasPort()) {
                epNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_PORT, addr.getPort()));
            }
        }
        if (endPoint.hasKey()) {
            epNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_KEY, (Object)endPoint.getKey()));
        }
        if (endPoint.hasCertificate()) {
            epNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_CERT, (Object)endPoint.getCertificate()));
        }
        if (endPoint.getCustomOptionsCount() > 0) {
            CommandOutput.OutputHierarchy.OutputNode customOptsNode = new CommandOutput.OutputHierarchy.OutputNode(ENDPOINT_PARAM_CUSTOM_OPTS);
            for (CLDBProto.KeyValue option : endPoint.getCustomOptionsList()) {
                customOptsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(option.getKey(), (Object)option.getValue()));
            }
            epNode.addChild(customOptsNode);
        }
        out.addNode(epNode);
    }

    private byte[] sendRequestToCLDB(CLDBProto.CLDBProg procId, MessageLite req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<CLDBProto.OtelEndPointAddResponse> responseClass = null;
        switch (procId) {
            case OtelEndPointAddProc: {
                responseClass = CLDBProto.OtelEndPointAddResponse.class;
                break;
            }
            case OtelEndPointUpdateProc: {
                responseClass = CLDBProto.OtelEndPointUpdateResponse.class;
                break;
            }
            case OtelEndPointInfoProc: {
                responseClass = CLDBProto.OtelEndPointInfoResponse.class;
                break;
            }
            case OtelEndPointRemoveProc: {
                responseClass = CLDBProto.OtelEndPointRemoveResponse.class;
                break;
            }
            case OtelEndPointListProc: {
                responseClass = CLDBProto.OtelEndPointListResponse.class;
                break;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send request " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send request " + procId));
            return null;
        }
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        return data;
    }
}

