/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.iamserverutils.IamServerRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.policyserver.iam.IamSupportUtils;
import com.mapr.fs.proto.IAMServerProto;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IamRolesCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(IamRolesCommands.class);
    private static final String IDENTITY_ROLE_PARAM_NAME = "name";
    private static final String IDENTITY_ROLE_PARAM_DESCRIPTION = "desc";
    private static final String IDENTITY_ROLE_PARAM_ROLE_CONTENT = "content";
    private static final String IDENTITY_ROLE_PARAM_USERS = "users";
    private static final String IDENTITY_ROLE_PARAM_GROUPS = "groups";
    private static final Integer MAX_ROLES_PER_PRC = 100;
    private static final String START_PARAM = "start";
    private static final String LIMIT_PARAM = "limit";
    private static final Integer KEYCLOACK_CACHE_EXPIRY_IN_MINS = 100;
    private static final String IAM_ROLE_NAME_REGEX = "[a-zA-Z0-9\\-_]*";
    private static final String IAM_ROLE_DESCRIPTION_REGEX = "[a-zA-Z0-9\\-_\\s]*";
    Security.CredentialsMsg creds;
    private UnixUserGroupHelper uugh;
    private static Map<IAMServerProto.RolesInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)IAMServerProto.RolesInfoFields.roleName, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.roleName.getNumber(), "n", "Name", String.class, null)).put((Object)IAMServerProto.RolesInfoFields.roleDescription, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.roleDescription.getNumber(), "desc", "Description", String.class, null)).put((Object)IAMServerProto.RolesInfoFields.id, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.id.getNumber(), "id", "Id", String.class, null)).put((Object)IAMServerProto.RolesInfoFields.identities, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.identities.getNumber(), "identities", "Identities", String.class, null)).put((Object)IAMServerProto.RolesInfoFields.users, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.users.getNumber(), "u", "Users", String.class, null)).put((Object)IAMServerProto.RolesInfoFields.groups, (Object)new FieldInfo(IAMServerProto.RolesInfoFields.groups.getNumber(), "g", "Groups", String.class, null)).build();
    private static final String createCustomRoleUsage = "role create -name <Role Name>[ -desc <Role Description> ][ -cluster <Cluster Name> ]";
    private static final String modifyCustomRoleUsage = "role modify -name <Role Name>-desc <Role Description>[ -cluster <Cluster Name> ]";
    private static final String infoCustomRoleUsage = "role info -name <Role Name>[ -cluster <Cluster Name> ]";
    private static final String listCustomRoleUsage = "role list -name <Role Name>-cluster <Cluster Name>[ -start start (default: 0) ][ -limit limit (default:2147483647)] ";
    private static final String removeCustomRoleUsage = "role remove -name <Role Name>[ -cluster <Cluster Name> ]";
    private static final String attachCustomRoleUsage = "role attach -role <Role Name>[ -users <List of Users> ][ -groups <List of Groups> ]";
    private static final String detachCustomRoleUsage = "role detach -role <Role Name>[ -users <List of Users> ][ -groups <List of Groups> ]";
    private static final String getAttachedIdentityRolesUsage = "role mapping ( -users <List of Users> | -groups <List of Groups> )";
    private static final CLICommand createCustomRoleCommand = new CLICommand("create", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"desc", (Object)new TextInputParameter("desc", "<Role Description>", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).build(), null).setShortUsage("role create -name <Role Name>[ -desc <Role Description> ][ -cluster <Cluster Name> ]");
    private static final CLICommand modifyCustomRoleCommand = new CLICommand("modify", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"desc", (Object)new TextInputParameter("desc", "<Role Description>", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).build(), null).setShortUsage("role modify -name <Role Name>-desc <Role Description>[ -cluster <Cluster Name> ]");
    private static final CLICommand infoCustomRoleCommand = new CLICommand("info", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).build(), null).setShortUsage("role info -name <Role Name>[ -cluster <Cluster Name> ]");
    private static final CLICommand listCustomRoleCommand = new CLICommand("list", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "<Limit>", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"start", (Object)new IntegerInputParameter("start", "<Start>", false, Integer.valueOf(0))).build(), null).setShortUsage("role list -name <Role Name>-cluster <Cluster Name>[ -start start (default: 0) ][ -limit limit (default:2147483647)] ");
    private static final CLICommand removeCustomRoleCommand = new CLICommand("remove", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).build(), null).setShortUsage("role remove -name <Role Name>[ -cluster <Cluster Name> ]");
    private static final CLICommand attachCustomRoleCommand = new CLICommand("attach", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"users", (Object)new TextInputParameter("users", "<List of Users>", false, null)).put((Object)"groups", (Object)new TextInputParameter("groups", "<List of Groups>", false, null)).build(), null).setShortUsage("role attach -role <Role Name>[ -users <List of Users> ][ -groups <List of Groups> ]");
    private static final CLICommand detachCustomRoleCommand = new CLICommand("detach", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Role Name>", true, null)).put((Object)"users", (Object)new TextInputParameter("users", "<List of Users>", false, null)).put((Object)"groups", (Object)new TextInputParameter("groups", "<List of Groups>", false, null)).build(), null).setShortUsage("role detach -role <Role Name>[ -users <List of Users> ][ -groups <List of Groups> ]");
    private static final CLICommand getAttachedIdentityRolesCommand = new CLICommand("mapping", "", IamRolesCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"users", (Object)new TextInputParameter("users", "<List of Users>", false, null)).put((Object)"groups", (Object)new TextInputParameter("groups", "<List of Groups>", false, null)).build(), null).setShortUsage("role mapping ( -users <List of Users> | -groups <List of Groups> )");
    public static final CLICommand IamRolesCommands = new CLICommand("role", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createCustomRoleCommand, modifyCustomRoleCommand, removeCustomRoleCommand, infoCustomRoleCommand, listCustomRoleCommand, attachCustomRoleCommand, detachCustomRoleCommand, getAttachedIdentityRolesCommand}).setShortUsage("role [create|remove|modify|info|list|attach|detach|mapping]");

    public IamRolesCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void initialize() throws CLIProcessingException {
        this.creds = this.getUserCredentials();
        this.uugh = new UnixUserGroupHelper();
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output;
        block10: {
            this.initialize();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output = new CommandOutput();
            output.setOutput(out);
            String cmd = this.cliCommand.getCommandName();
            try {
                if (cmd.equalsIgnoreCase("create")) {
                    this.createRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("modify")) {
                    this.modifyRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("info")) {
                    this.infoRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("list")) {
                    this.listRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("remove")) {
                    this.removeRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("attach")) {
                    this.attachRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("detach")) {
                    this.detachRole(out);
                    break block10;
                }
                if (cmd.equalsIgnoreCase("mapping")) {
                    this.getIamRolesMappings(out);
                    break block10;
                }
                return new TextCommandOutput("IAM Role command failed".getBytes());
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception sending role command to IAM Server, " + e.getLocalizedMessage());
            }
        }
        return output;
    }

    private IAMServerProto.RoleLookupResponse roleLookup(String cluster, String roleName, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        byte[] data = null;
        IAMServerProto.RoleLookupRequest.Builder roleInfoBuilder = IAMServerProto.RoleLookupRequest.newBuilder();
        roleInfoBuilder.setName(roleName);
        roleInfoBuilder.setCreds(this.getUserCredentials());
        IAMServerProto.RoleLookupRequest roleInfo = roleInfoBuilder.build();
        try {
            data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleInfoProc.getNumber(), (MessageLite)roleInfo, out);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return IAMServerProto.RoleLookupResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing role info to IAM Server, " + e.getLocalizedMessage());
        }
    }

    CommandOutput createRole(CommandOutput.OutputHierarchy out) throws Exception {
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String description = this.getRoleDesc();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command to create a role").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        String roleName = this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0).trim();
        if (!this.isValidRoleName(roleName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Role Name: " + roleName).setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        if (this.isParamPresent(IDENTITY_ROLE_PARAM_DESCRIPTION) && !this.isValidRoleDescription(description)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Role Description: " + description).setField(IDENTITY_ROLE_PARAM_DESCRIPTION));
            return output;
        }
        byte[] data = null;
        IAMServerProto.RoleCreateRequest.Builder roleCreate = IAMServerProto.RoleCreateRequest.newBuilder();
        roleCreate.setName(roleName);
        if (this.isParamPresent(IDENTITY_ROLE_PARAM_DESCRIPTION)) {
            roleCreate.setDescription(description);
        }
        roleCreate.setCreds(this.getUserCredentials());
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleCreateProc.getNumber(), (MessageLite)roleCreate.build(), out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IamServer. Check if IamServer is up and running."));
            return output;
        }
        IAMServerProto.RoleCreateResponse resp = IAMServerProto.RoleCreateResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully created the role '" + roleName + "'.");
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()).setField(IDENTITY_ROLE_PARAM_NAME).setFieldValue(roleName));
        }
        return output;
    }

    CommandOutput modifyRole(CommandOutput.OutputHierarchy out) throws Exception {
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String description = this.getRoleDesc();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command to modify a role").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_DESCRIPTION)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Description is required parameter in role modify. Please provide a vaild Role Description.").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        String roleName = this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0).trim();
        if (!this.isValidRoleName(roleName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Role Name: " + roleName).setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        if (this.isParamPresent(IDENTITY_ROLE_PARAM_DESCRIPTION) && !this.isValidRoleDescription(description)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Role Description: " + description).setField(IDENTITY_ROLE_PARAM_DESCRIPTION));
            return output;
        }
        byte[] data = null;
        IAMServerProto.RoleModifyRequest roleModify = IAMServerProto.RoleModifyRequest.newBuilder().setName(roleName).setDescription(description).setCreds(this.getUserCredentials()).build();
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleModifyProc.getNumber(), (MessageLite)roleModify, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IamServer. Check if IamServer is up and running."));
            return output;
        }
        IAMServerProto.RoleModifyResponse resp = IAMServerProto.RoleModifyResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully modified the role '" + roleName + "'");
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()).setField(IDENTITY_ROLE_PARAM_NAME).setFieldValue(roleName));
        }
        return output;
    }

    CommandOutput infoRole(CommandOutput.OutputHierarchy out) throws Exception {
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cluster = this.getClusterName();
        String roleName = this.getRoleName();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command.").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        LOG.debug((Object)("RoleInfo: Looking up Role name " + roleName));
        IAMServerProto.RoleLookupResponse resp = this.roleLookup(cluster, roleName, out);
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy.OutputNode roleInfo = this.formatRoleProperties(resp.getRoleInfo());
            out.addNode(roleInfo);
        } else {
            LOG.info((Object)("RoleInfo: Lookup of role name " + roleName + " failed, status=" + Errno.toString((int)resp.getStatus())));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to info '" + roleName + "'." + (resp.getStatus() == 2 ? " No such Role exists" : resp.getErrMsg())));
        }
        return output;
    }

    CommandOutput listRole(CommandOutput.OutputHierarchy out) throws Exception {
        try {
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            this.list(out);
            return output;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request exception", (Throwable)e);
        }
    }

    CommandOutput removeRole(CommandOutput.OutputHierarchy out) throws Exception {
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command.").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        String roleName = this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0).trim();
        IAMServerProto.RoleRemoveRequest.Builder roleRemove = IAMServerProto.RoleRemoveRequest.newBuilder();
        byte[] data = null;
        roleRemove.setName(roleName);
        roleRemove.setCreds(this.getUserCredentials());
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleRemoveProc.getNumber(), (MessageLite)roleRemove.build(), out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IamServer. Check if IamServer is up and running."));
            return output;
        }
        IAMServerProto.RoleRemoveResponse resp = IAMServerProto.RoleRemoveResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully removed the role '" + roleName + "'.");
        } else {
            String errMsg = "Failed to remove '" + roleName + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + ": " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg).setField(IDENTITY_ROLE_PARAM_NAME).setFieldValue(roleName));
        }
        return output;
    }

    CommandOutput attachRole(CommandOutput.OutputHierarchy out) throws Exception {
        String groups;
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        HashSet identities = new HashSet();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command to attach the role.").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        String roleName = this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0).trim();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_USERS) && !this.isParamPresent(IDENTITY_ROLE_PARAM_GROUPS)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Atleast one of Users or Groups must be present in role attach command."));
            return output;
        }
        String users = this.getUsersNames();
        if (users != null) {
            HashSet<String> userNames = this.getListFromInputString(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroupsNames()) != null) {
            HashSet<String> groupNames = this.getListFromInputString(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users or Groups specified"));
            return output;
        }
        IAMServerProto.RoleAttachRequest roleAttach = IAMServerProto.RoleAttachRequest.newBuilder().setName(roleName).setCreds(this.getUserCredentials()).addAllIdentities(identities).build();
        byte[] data = null;
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleAttachProc.getNumber(), (MessageLite)roleAttach, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IamServer. Check if IamServer is up and running."));
            return output;
        }
        IAMServerProto.RoleAttachResponse resp = IAMServerProto.RoleAttachResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully attached the role '" + roleName + "'.");
        } else {
            String errMsg = "Failed to attach '" + roleName + "'. ";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + ": " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg).setField(IDENTITY_ROLE_PARAM_NAME).setFieldValue(roleName).setField(IDENTITY_ROLE_PARAM_USERS).setFieldValue(users.toString()).setField(IDENTITY_ROLE_PARAM_GROUPS).setFieldValue(groups.toString()));
        }
        return output;
    }

    CommandOutput detachRole(CommandOutput.OutputHierarchy out) throws Exception {
        String groups;
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        HashSet identities = new HashSet();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing Role name in the command to detach the role.").setField(IDENTITY_ROLE_PARAM_NAME));
            return output;
        }
        String roleName = this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0).trim();
        if (!this.isParamPresent(IDENTITY_ROLE_PARAM_USERS) && !this.isParamPresent(IDENTITY_ROLE_PARAM_GROUPS)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Atleast one of Users or Groups must be present in role detach command."));
            return output;
        }
        String users = this.getUsersNames();
        if (users != null) {
            HashSet<String> userNames = this.getListFromInputString(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroupsNames()) != null) {
            HashSet<String> groupNames = this.getListFromInputString(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users or Groups specified"));
            return output;
        }
        IAMServerProto.RoleDetachRequest roleDetach = IAMServerProto.RoleDetachRequest.newBuilder().setName(roleName).setCreds(this.getUserCredentials()).addAllIdentities(identities).build();
        byte[] data = null;
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleDetachProc.getNumber(), (MessageLite)roleDetach, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IamServer. Check if IamServer is up and running."));
            return output;
        }
        IAMServerProto.RoleAttachResponse resp = IAMServerProto.RoleAttachResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("Successfully detached the role '" + roleName + "'.");
        } else {
            String errMsg = "Failed to detach '" + roleName + "'.";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + ": " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg).setField(IDENTITY_ROLE_PARAM_NAME).setFieldValue(roleName).setField(IDENTITY_ROLE_PARAM_USERS).setFieldValue(users.toString()).setField(IDENTITY_ROLE_PARAM_GROUPS).setFieldValue(groups.toString()));
        }
        return output;
    }

    CommandOutput getIamRolesMappings(CommandOutput.OutputHierarchy out) throws CLIProcessingException, Exception {
        String groups;
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        HashSet identities = new HashSet();
        String users = this.getUsersNames();
        if (users != null) {
            HashSet<String> userNames = this.getListFromInputString(users, ",");
            HashSet<Integer> userIds = this.getIdsFromNames(PolicyServerProto.IdentityType.User, userNames, out);
            if (userIds == null || userIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(userIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
        }
        if ((groups = this.getGroupsNames()) != null) {
            HashSet<String> groupNames = this.getListFromInputString(groups, ",");
            HashSet<Integer> groupIds = this.getIdsFromNames(PolicyServerProto.IdentityType.Group, groupNames, out);
            if (groupIds == null || groupIds.isEmpty()) {
                return output;
            }
            identities.addAll(IamSupportUtils.getIdentities(groupIds, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
        }
        if (identities.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Users or Groups specified"));
            return output;
        }
        byte[] data = null;
        IAMServerProto.IamRoleMappingsRequest req = IAMServerProto.IamRoleMappingsRequest.newBuilder().setCreds(this.getUserCredentials()).addAllIdentities(identities).build();
        data = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleMappingsProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to IAM Sever"));
            return output;
        }
        IAMServerProto.IamRoleMappingsResponse resp = IAMServerProto.IamRoleMappingsResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            for (IAMServerProto.IdentityToRoles mappingInfo : resp.getMappingsList()) {
                CommandOutput.OutputHierarchy.OutputNode mapIdentityRoles = this.formatIdentityRolesMapping(mappingInfo);
                out.addNode(mapIdentityRoles);
            }
        } else {
            String errMsg = "Failed to get Identity Role Mappings";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private HashSet<String> getListFromInputString(String inputString, String seperator) {
        String[] tokens = inputString.split(seperator);
        HashSet<String> values = new HashSet<String>();
        for (int index = 0; index < tokens.length; ++index) {
            values.add(tokens[index].trim());
        }
        return values;
    }

    private String getString(HashSet<String> values) {
        return values != null && !values.isEmpty() ? String.join((CharSequence)",", values) : "";
    }

    private HashSet<Integer> getIdsFromNames(PolicyServerProto.IdentityType type, HashSet<String> names, CommandOutput.OutputHierarchy out) {
        HashSet<Integer> identites = new HashSet<Integer>();
        for (String name : names) {
            Integer id = null;
            String str = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)type);
            try {
                if (type == PolicyServerProto.IdentityType.User) {
                    id = this.uugh.getUserId(name);
                } else if (type == PolicyServerProto.IdentityType.Group) {
                    id = this.uugh.getGroupId(name);
                }
                if (id == null) {
                    String errmsg = String.format("%s '%s' does not exist", str, name);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                    return null;
                }
                identites.add(id);
            }
            catch (Exception exp) {
                String errmsg = String.format("%s '%s' does not exist", str, name);
                LOG.error((Object)errmsg);
                if (out == null) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                return null;
            }
        }
        return identites;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityInfoList(HashSet<Integer> userIds, HashSet<Integer> groupIds) {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        HashSet<String> userNames = new HashSet<String>();
        if (userIds != null && !userIds.isEmpty()) {
            userNames = this.getNamesFromIds(PolicyServerProto.IdentityType.User, userIds, null);
        }
        String strUserNames = this.getString(userNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.users).getName(false), (Object)strUserNames));
        HashSet<String> groupNames = new HashSet<String>();
        if (groupIds != null && !groupIds.isEmpty()) {
            groupNames = this.getNamesFromIds(PolicyServerProto.IdentityType.Group, groupIds, null);
        }
        String strGroupsNames = this.getString(groupNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.groups).getName(false), (Object)strGroupsNames));
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityRolesMapping(IAMServerProto.IdentityToRoles mapInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        HashSet<String> roleNames = new HashSet<String>();
        PolicyServerProto.IdentityInfoMsg identity = mapInfo.getIdentity();
        String identityName = this.getNameFromId(identity.getType(), identity.getId());
        String identityType = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)identity.getType());
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IdType", (Object)identityType));
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IdName", (Object)identityName));
        for (PolicyServerProto.IdentityInfoMsg roleIdentityInfoMsg : mapInfo.getRolesList()) {
            roleNames.add(roleIdentityInfoMsg.getName());
        }
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("IamRoles", (Object)this.getString(roleNames)));
        return output;
    }

    private String getNameFromId(PolicyServerProto.IdentityType type, int id) {
        String name = null;
        if (type == PolicyServerProto.IdentityType.User) {
            name = this.uugh.getUsername(id);
        } else if (type == PolicyServerProto.IdentityType.Group) {
            name = this.uugh.getGroupname(id);
        }
        return name;
    }

    private HashSet<String> getNamesFromIds(PolicyServerProto.IdentityType type, HashSet<Integer> ids, CommandOutput.OutputHierarchy out) {
        HashSet<String> identites = new HashSet<String>();
        for (int id : ids) {
            String name = null;
            String str = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)type);
            try {
                String errmsg;
                if (type == PolicyServerProto.IdentityType.User) {
                    name = this.uugh.getUsername(id);
                } else if (type == PolicyServerProto.IdentityType.Group) {
                    name = this.uugh.getGroupname(id);
                } else {
                    errmsg = String.format("getNamesFromIds not supported for %s: '%s'", str, name);
                    LOG.error((Object)errmsg);
                    if (out != null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                        return null;
                    }
                }
                if (name == null) {
                    errmsg = String.format("%s '%d' does not exist", str, id);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                    return null;
                }
                identites.add(name);
            }
            catch (Exception exp) {
                String errmsg = String.format("%s '%d' does not exist", str, id);
                LOG.error((Object)errmsg);
                if (out == null) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                return null;
            }
        }
        return identites;
    }

    private String getClusterName() throws CLIProcessingException {
        return this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
    }

    private String getRoleDesc() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_ROLE_PARAM_DESCRIPTION) ? this.getParamTextValue(IDENTITY_ROLE_PARAM_DESCRIPTION, 0) : null;
    }

    private String getRoleName() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_ROLE_PARAM_NAME) ? this.getParamTextValue(IDENTITY_ROLE_PARAM_NAME, 0) : null;
    }

    private String getUsersNames() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_ROLE_PARAM_USERS) ? this.getParamTextValue(IDENTITY_ROLE_PARAM_USERS, 0) : null;
    }

    private String getGroupsNames() throws CLIProcessingException {
        return this.isParamPresent(IDENTITY_ROLE_PARAM_GROUPS) ? this.getParamTextValue(IDENTITY_ROLE_PARAM_GROUPS, 0) : null;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM) ? this.getParamIntValue(LIMIT_PARAM, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM) ? this.getParamIntValue(START_PARAM, 0) : 0;
    }

    private boolean isValidRoleName(String roleName) {
        return roleName.matches(IAM_ROLE_NAME_REGEX);
    }

    private boolean isValidRoleDescription(String roleDesc) {
        return roleDesc.matches(IAM_ROLE_DESCRIPTION_REGEX);
    }

    private byte[] sendRequestToIAMServer(int procId, MessageLite req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<IAMServerProto.RoleCreateResponse> responseClass = null;
        switch (procId) {
            case 1: {
                responseClass = IAMServerProto.RoleCreateResponse.class;
                break;
            }
            case 4: {
                responseClass = IAMServerProto.RoleLookupResponse.class;
                break;
            }
            case 2: {
                responseClass = IAMServerProto.RoleRemoveResponse.class;
                break;
            }
            case 3: {
                responseClass = IAMServerProto.RoleListResponse.class;
                break;
            }
            case 5: {
                responseClass = IAMServerProto.RoleAttachResponse.class;
                break;
            }
            case 6: {
                responseClass = IAMServerProto.RoleDetachResponse.class;
                break;
            }
            case 9: {
                responseClass = IAMServerProto.RoleModifyResponse.class;
            }
            case 10: {
                responseClass = IAMServerProto.IamRoleMappingsResponse.class;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send request " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send request " + procId));
            return null;
        }
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? IamServerRpcCommonUtils.getInstance().sendRequestToIamServer(this.getClusterName(), procId, req, responseClass) : IamServerRpcCommonUtils.getInstance().sendRequestToIamServer(procId, req, responseClass);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        return data;
    }

    CommandOutput.OutputHierarchy.OutputNode formatRoleProperties(IAMServerProto.RoleInfo RoleProps) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode roleProperties = new CommandOutput.OutputHierarchy.OutputNode();
        roleProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.roleName).getName(false), (Object)RoleProps.getRName()));
        roleProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.id).getName(false), RoleProps.getRId()));
        roleProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.roleDescription).getName(false), (Object)RoleProps.getDescription()));
        HashSet<Integer> userids = new HashSet<Integer>(RoleProps.getUIdsList());
        HashSet<Integer> groupids = new HashSet<Integer>(RoleProps.getGIdsList());
        CommandOutput.OutputHierarchy.OutputNode identities = this.formatIdentityInfoList(userids, groupids);
        roleProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(IAMServerProto.RolesInfoFields.identities).getName(false), (Object)identities));
        return roleProperties;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        IAMServerProto.RoleListResponse resp = (IAMServerProto.RoleListResponse)response;
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        for (IAMServerProto.RoleInfo s : resp.getRoleInfoList()) {
            try {
                CommandOutput.OutputHierarchy.OutputNode roleProperties = this.formatRoleProperties(s);
                out.addNode(roleProperties);
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while trying to list Roles", (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while trying to list Roles."));
            }
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
    }

    public IAMServerProto.RoleListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        IAMServerProto.RoleListRequest req = (IAMServerProto.RoleListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.sendRequestToIAMServer(IAMServerProto.IAMRoleProc.RoleListProc.getNumber(), (MessageLite)req, null);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return IAMServerProto.RoleListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into RoleListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list security policies failed. No data returned");
        return null;
    }

    private IAMServerProto.RoleListRequest.Builder getRoleListRequestBuilder() throws CLIProcessingException {
        IAMServerProto.RoleListRequest.Builder req = IAMServerProto.RoleListRequest.newBuilder();
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), MAX_ROLES_PER_PRC);
        return req.setCreds(this.getUserCredentials()).setLimiter(limiter);
    }

    public IAMServerProto.RoleListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        IAMServerProto.RoleListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? IAMServerProto.RoleListRequest.newBuilder((IAMServerProto.RoleListRequest)((IAMServerProto.RoleListRequest)prevReq)) : this.getRoleListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((IAMServerProto.RoleListResponse)prevResp).getRoleInfoCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, MAX_ROLES_PER_PRC));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((IAMServerProto.RoleListRequest)prevReq).getLimiter().getStart(), ((IAMServerProto.RoleListResponse)prevResp).getRoleInfoCount());
    }
}

