/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.mapr.cli.common.OndiskFileAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

class OnDiskImage<T>
implements Serializable {
    List<T> list = null;
    String sortKey = null;
    String checksum = null;
    long createStamp = 0L;

    OnDiskImage() {
    }

    String getListCheckSum(String algo) {
        return this.getObjectCheckSum(this.list, algo);
    }

    private String getObjectCheckSum(Object obj, String algo) {
        String checksum = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algo);
            byte[] buffer = this.serializeObject(obj);
            digest.update(buffer);
            checksum = DatatypeConverter.printHexBinary((byte[])digest.digest());
            OndiskFileAccessor.LOG.debug((Object)("computed checksum:" + checksum));
        }
        catch (NoSuchAlgorithmException e) {
            OndiskFileAccessor.LOG.error((Object)("Checksum Algorithm not found: " + algo));
        }
        return checksum;
    }

    private byte[] serializeObject(Object obj) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ObjectOutputStream o = new ObjectOutputStream(b);
            o.writeObject(obj);
        }
        catch (IOException io) {
            OndiskFileAccessor.LOG.error((Object)("IOException: " + io));
        }
        return b.toByteArray();
    }
}

