/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.baseutils.Errno;
import com.mapr.baseutils.acls.SecurityCommandHelper;
import com.mapr.cli.common.AuthManager;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoginCommand
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(LoginCommand.class);
    public static final String USER_PARAM_NAME = "user";
    private AuthManager authManager = AuthManager.getInstance();
    public static final CLICommand loginCommand = new CLICommand("login", "login -user", LoginCommand.class, CLICommand.ExecutionTypeEnum.NATIVE).setShortUsage("login -user").setUsageInVisible(true);

    public LoginCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private CommandOutput login() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Map parameters = this.input.getAllParameters();
        if (!parameters.containsKey(USER_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "User Name Required"));
            return output;
        }
        ProcessedInput.Parameter param = (ProcessedInput.Parameter)parameters.get(USER_PARAM_NAME);
        String user = (String)param.getParamValues().get(0);
        if (user == null || user.trim().isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid user  " + Errno.toString((int)22)));
            return output;
        }
        this.authManager.canPerformClusterActions(SecurityCommandHelper.CLUSTER_READ_MASK, this.getUserCredentials(), out);
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        if (!super.validateInput()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Input"));
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("login")) {
            return this.login();
        }
        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown command"));
        output.setOutput(out);
        return output;
    }
}

