/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.SetupYarnAppLogLinks;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public final class SetupJobLogLinks
extends CLIBaseClass
implements CLIInterface {
    private static final String CENTRAL_LOGVIEWDIR_PROP = "mapr.centrallogview.dir";
    private static final PathFilter jobLogFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String pathName = p.getName();
            return !pathName.endsWith(".xml") && !pathName.endsWith("_metrics");
        }
    };
    private static final Log LOG = LogFactory.getLog(SetupJobLogLinks.class);
    private final Configuration conf = new Configuration();
    private Path jobsDonePath;
    private String localVolumesPath;
    private String centralLogDirName;
    private String centralLogViewDirName;
    private FileSystem maprFS;

    public SetupJobLogLinks(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String confFile;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String jobidArg = this.getParamTextValue("jobid", 0);
        String jobid = jobidArg == null ? "" : jobidArg.trim();
        String viewDirArg = this.getParamTextValue("todir", 0);
        String viewDir = viewDirArg == null ? "" : viewDirArg.trim();
        String confFileArg = this.isParamPresent("jobconf") ? this.getParamTextValue("jobconf", 0) : null;
        String string = confFile = confFileArg == null ? "" : confFileArg.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsed arguments: " + jobid + ", " + viewDir + ", " + confFile));
        }
        if (jobid.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid job id: <" + jobidArg + ">"));
            return output;
        }
        if (jobid.startsWith("application")) {
            try {
                new SetupYarnAppLogLinks(jobid, viewDirArg).run();
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to create job log links." + e.getMessage()));
            }
            return output;
        }
        if (jobid.startsWith("job")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Hadoop v1 is not supporetd"));
            return output;
        }
        if (!jobid.startsWith("job")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Only YARN applications are supported, job names starts with \"application\""));
            return output;
        }
        if (!confFile.isEmpty()) {
            this.conf.addResource(new Path(confFile));
        }
        if (viewDir.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid directory name: <" + viewDirArg + ">"));
            return output;
        }
        this.conf.set(CENTRAL_LOGVIEWDIR_PROP, viewDir);
        return output;
    }
}

