/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class InstallerCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(InstallerCommands.class);
    public static final int START_ARGS = 2;
    public static final String CREATE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/create_cluster.py";
    public static final String STATUS_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/create_cluster_status.py";
    public static final String REMOVE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/remove_cluster.py";
    public static final String INFO_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_info.py";
    public static final String LIST_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/list_clusters.py";
    public static final String CHECK_FOR_UPDATE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_check_updates.py";
    public static final String CLUSTER_UPGRADE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_upgrade.py";
    public static final String CHECK_UPGRADE_STATUS_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_upgrade_status.py";
    public static final String GETCLUSTERKEY_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_key.py";
    public static final String STORAGECONFIG_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/storage_config.py";
    public static final String CLUSTER_SCALE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_scale.py";
    public static final String CLUSTER_SCALE_STATUS_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_scale_status.py";
    public static final String CLUSTER_REMOVE_NODE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_remove_node.py";
    public static final String CLUSTER_REMOVE_STATUS_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_remove_status.py";
    public static final String CLUSTER_DOWNLOAD_LOG_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_logs.py";
    public static final String installerCommandsUsage = "installer  [clustercreate|clusterremove|clusterstatus|clusterinfo|listdeployments|checkforupdate|clusterupgrade|clusterupgradestatus|clusterscale|clusterscalestatus|getclusterkey|infrastate|installerstate|storageconfig|logs]";
    public static final int MAX_FILE_SIZE_IN_KB = 20;
    public static final String INSTALLER_COMMAND_CLUSTER_CREATE = "clustercreate";
    public static final String INSTALLER_COMMAND_CLUSTER_REMOVE = "clusterremove";
    public static final String INSTALLER_COMMAND_CLUSTER_STATUS = "clusterstatus";
    public static final String INSTALLER_COMMAND_CLUSTER_INFO = "clusterinfo";
    public static final String INSTALLER_COMMAND_LIST_DEPLOYMENTS = "listdeployments";
    public static final String INSTALLER_COMMAND_GET_CLUSTER_KEY = "getclusterkey";
    private static final String INSTALLER_COMMAND_CHECK_FOR_UPDATE = "checkforupdate";
    private static final String INSTALLER_COMMAND_CLUSTER_UPGRADE = "clusterupgrade";
    private static final String INSTALLER_COMMAND_CLUSTER_UPGRADE_STATUS = "clusterupgradestatus";
    private static final String INSTALLER_COMMAND_INSTALLER_STATE = "installerstate";
    private static final String INSTALLER_COMMAND_INFRA_STATE = "infrastate";
    private static final String INSTALLER_COMMAND_DEPLOYMENT_INFO = "deploymentinfo";
    private static final String INSTALLER_COMMAND_INSTALL_INFO = "installinfo";
    private static final String INSTALLER_COMMAND_UPGRADE_INFO = "upgradeinfo";
    private static final String INSTALLER_COMMAND_FABRIC_INFO = "fabricinfo";
    private static final String INSTALLER_COMMAND_CLUSTER_KEY = "clusterkey";
    private static final String INSTALLER_COMMAND_SCALE_INFO = "scaleinfo";
    private static final String INSTALLER_COMMAND_REMOVE_INFO = "removeinfo";
    public static final String INSTALLER_COMMAND_STORAGE_CONFIG = "storageconfig";
    private static final String INSTALLER_COMMAND_CLUSTER_SCALE = "clusterscale";
    private static final String INSTALLER_COMMAND_CLUSTER_SCALE_STATUS = "clusterscalestatus";
    private static final String INSTALLER_COMMAND_CLUSTER_REMOVE_NODE = "clusterremovenode";
    private static final String INSTALLER_COMMAND_CLUSTER_REMOVE_STATUS = "clusterremovestatus";
    private static final String INSTALLER_COMMAND_CLUSTER_DOWNLOAD_LOG = "logs";
    private static final String FILE_PARAM = "file";
    private static final String DATA_PARAM = "data";
    private static final String CLUSTERNAME_PARAM = "clustername";
    private static final String ADD_PARAM = "add";
    private static final String UPDATE_PARAM = "update";
    private static final String REMOVE_PARAM = "remove";
    private static final String GET_PARAM = "get";
    public static final String P_PATH = "pypath";
    public static final String DEFAULT_PATH = "/opt/mapr/installer/build/ezdfaas/bin/python3.10 ";
    public static final String usage = "for detailed usage use -h";
    public static final CLICommand InstallerClusterCreateCommand = new CLICommand("clustercreate", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterRemoveCommand = new CLICommand("clusterremove", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterStatusCommand = new CLICommand("clusterstatus", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterInfoCommand = new CLICommand("clusterinfo", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerListDeploymentsCommand = new CLICommand("listdeployments", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerCheckForUpdateCommand = new CLICommand("checkforupdate", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterUpgradeCommand = new CLICommand("clusterupgrade", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterUpgradeStatusCommand = new CLICommand("clusterupgradestatus", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterDownloadLogCommand = new CLICommand("logs", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterScaleCommand = new CLICommand("clusterscale", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterScaleStatusCommand = new CLICommand("clusterscalestatus", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterRemoveNodeCommand = new CLICommand("clusterremovenode", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterRemoveStatusCommand = new CLICommand("clusterremovestatus", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setUsageInVisible(true).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterKeyCommand = new CLICommand("getclusterkey", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerStateAddCmd = new CLICommand("add", "add state of installer from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installerstate add -file<filename> -clustername <clustername");
    public static final CLICommand InstallerStateUpdateCmd = new CLICommand("update", "update installer state from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installerstate update -file<filename> -clustername <clustername");
    public static final CLICommand InstallerStateRemoveCmd = new CLICommand("remove", "remove installer state from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installerstate remove -file<filename> -clustername <clustername");
    public static final CLICommand InstallerStateGetCmd = new CLICommand("get", "get installer state of given cluster from clustergroup to the file", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installerstate get -file<filename> -clustername <clustername");
    public static final CLICommand InfraStateAddCmd = new CLICommand("add", "add state of infrastructure from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("infrastate add -file<filename> -clustername <clustername");
    public static final CLICommand InfraStateUpdateCmd = new CLICommand("update", "update infrastructure state from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("infrastate update -file <filename> -clustername <clustername>");
    public static final CLICommand InfraStateRemoveCmd = new CLICommand("remove", "remove infrastructure state from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("infrastate remove -file <filename> -clustername <clustername>");
    public static final CLICommand InfraStateGetCmd = new CLICommand("get", "get infrastructure state of given cluster from clustergroup to the file", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("infrastate get -file <filename> -clustername <clustername>");
    public static final CLICommand InstallerStateCmds = new CLICommand("installerstate", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{InstallerStateAddCmd, InstallerStateGetCmd, InstallerStateRemoveCmd}).setUsageInVisible(true).setShortUsage("installerstate [add|get|remove]");
    public static final CLICommand InfraStateCmds = new CLICommand("infrastate", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{InfraStateAddCmd, InfraStateGetCmd, InfraStateRemoveCmd}).setUsageInVisible(true).setShortUsage("infrastate [add|get|remove]");
    public static final CLICommand InstallerStorageConfigCommand = new CLICommand("storageconfig", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand DeploymentInfoAddCmd = new CLICommand("add", "add deployment related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("deploymentinfo add -data <filename> -clustername <clustername");
    public static final CLICommand DeploymentInfoGetCmd = new CLICommand("get", "get deployment related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("deploymentinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand DeploymentInfoRemoveCmd = new CLICommand("remove", "remove deployment info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("deploymentinfo remove -clustername <clustername");
    public static final CLICommand DeploymentInfoCommands = new CLICommand("deploymentinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{DeploymentInfoAddCmd, DeploymentInfoGetCmd, DeploymentInfoRemoveCmd}).setUsageInVisible(true).setShortUsage("deploymentinfo [add|get|remove]");
    public static final CLICommand InstallInfoAddCmd = new CLICommand("add", "add install related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installinfo add -data <filename> -clustername <clustername");
    public static final CLICommand InstallInfoGetCmd = new CLICommand("get", "get install related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand InstallInfoRemoveCmd = new CLICommand("remove", "remove install info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("installinfo remove -clustername <clustername");
    public static final CLICommand InstallInfoCommands = new CLICommand("installinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{InstallInfoAddCmd, InstallInfoGetCmd, InstallInfoRemoveCmd}).setUsageInVisible(true).setShortUsage("installinfo [add|get|remove]");
    public static final CLICommand UpgradeInfoAddCmd = new CLICommand("add", "add upgrade related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("upgradeinfo add -data <filename> -clustername <clustername");
    public static final CLICommand UpgradeInfoGetCmd = new CLICommand("get", "get upgrade related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("upgradeinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand UpgradeInfoRemoveCmd = new CLICommand("remove", "remove upgrade info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("upgradeinfo remove -clustername <clustername");
    public static final CLICommand UpgradeInfoCommands = new CLICommand("upgradeinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{UpgradeInfoAddCmd, UpgradeInfoGetCmd, UpgradeInfoRemoveCmd}).setUsageInVisible(true).setShortUsage("upgradeinfo [add|get|remove]");
    public static final CLICommand FabricInfoAddCmd = new CLICommand("add", "add fabric related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("fabricinfo add -data <filename> -clustername <clustername");
    public static final CLICommand FabricInfoGetCmd = new CLICommand("get", "get fabric related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("fabricinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand FabricInfoRemoveCmd = new CLICommand("remove", "remove fabric info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("fabricinfo remove -clustername <clustername");
    public static final CLICommand FabricInfoCommands = new CLICommand("fabricinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{FabricInfoAddCmd, FabricInfoGetCmd, FabricInfoRemoveCmd}).setUsageInVisible(true).setShortUsage("fabricinfo [add|get|remove]");
    public static final CLICommand ClusterKeyAddCmd = new CLICommand("add", "add cluster key from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("clusterkey add -data <filename> -clustername <clustername");
    public static final CLICommand ClusterKeyGetCmd = new CLICommand("get", "get cluster key from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("clusterkey get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand ClusterKeyRemoveCmd = new CLICommand("remove", "remove cluster key for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("clusterkey remove -clustername <clustername");
    public static final CLICommand ClusterKeyCommands = new CLICommand("clusterkey", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{ClusterKeyAddCmd, ClusterKeyGetCmd, ClusterKeyRemoveCmd}).setUsageInVisible(true).setShortUsage("clusterkey [add|get|remove]");
    public static final CLICommand ScaleInfoAddCmd = new CLICommand("add", "add fabric related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("scaleinfo add -data <filename> -clustername <clustername");
    public static final CLICommand ScaleInfoGetCmd = new CLICommand("get", "get fabric related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("scaleinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand ScaleInfoRemoveCmd = new CLICommand("remove", "remove fabric info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("scaleinfo remove -clustername <clustername");
    public static final CLICommand ScaleInfoCommands = new CLICommand("scaleinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{ScaleInfoAddCmd, ScaleInfoGetCmd, ScaleInfoRemoveCmd}).setShortUsage("scaleinfo [add|get|remove]");
    public static final CLICommand RemoveInfoAddCmd = new CLICommand("add", "add fabric related info from the file to clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "filename", true, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("removeinfo add -data <filename> -clustername <clustername");
    public static final CLICommand RemoveInfoGetCmd = new CLICommand("get", "get fabric related info from clustergroup, for given cluster", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file to store data", false, null)).put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("removeinfo get -clustername <clustername> [-file <file to store data>]");
    public static final CLICommand RemoveInfoRemoveCmd = new CLICommand("remove", "remove fabric info for given cluster from clustergroup", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("removeinfo remove -clustername <clustername");
    public static final CLICommand RemoveInfoCommands = new CLICommand("removeinfo", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{RemoveInfoAddCmd, RemoveInfoGetCmd, RemoveInfoRemoveCmd}).setShortUsage("removeinfo [add|get|remove]");
    public static final CLICommand[] installerCommands = new CLICommand[]{InstallerClusterCreateCommand, InstallerClusterRemoveCommand, InstallerClusterStatusCommand, InstallerClusterInfoCommand, InstallerListDeploymentsCommand, InstallerCheckForUpdateCommand, InstallerClusterUpgradeCommand, InstallerClusterUpgradeStatusCommand, InstallerClusterKeyCommand, InstallerStateCmds, InfraStateCmds, InstallerStorageConfigCommand, DeploymentInfoCommands, InstallInfoCommands, UpgradeInfoCommands, FabricInfoCommands, ClusterKeyCommands, InstallerClusterScaleCommand, InstallerClusterScaleStatusCommand, InstallerClusterRemoveNodeCommand, InstallerClusterRemoveStatusCommand, InstallerClusterDownloadLogCommand, ScaleInfoCommands, RemoveInfoCommands};

    public InstallerCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        String parentCmdName = this.cliCommand.getParentCommand().getCommandName();
        if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INSTALLER_STATE) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INFRA_STATE) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_DEPLOYMENT_INFO) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INSTALL_INFO) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_UPGRADE_INFO) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_FABRIC_INFO) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_KEY) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_SCALE_INFO) || parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_REMOVE_INFO)) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
            output.setOutput(oh);
            String clustername = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
            String filename = this.isParamPresent(FILE_PARAM) ? this.getParamTextValue(FILE_PARAM, 0) : null;
            CLDBProto.InstallerTableColumns col = null;
            try {
                if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INSTALLER_STATE)) {
                    this.handleInstallerState(oh, filename, clustername);
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INFRA_STATE)) {
                    this.handleInfraState(oh, filename, clustername);
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_DEPLOYMENT_INFO)) {
                    col = CLDBProto.InstallerTableColumns.DeploymentInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_INSTALL_INFO)) {
                    col = CLDBProto.InstallerTableColumns.InstallInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_UPGRADE_INFO)) {
                    col = CLDBProto.InstallerTableColumns.UpgradeInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_FABRIC_INFO)) {
                    col = CLDBProto.InstallerTableColumns.FabricInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_KEY)) {
                    col = CLDBProto.InstallerTableColumns.ClusterKeyInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_SCALE_INFO)) {
                    col = CLDBProto.InstallerTableColumns.ScaleInfo;
                } else if (parentCmdName.equalsIgnoreCase(INSTALLER_COMMAND_REMOVE_INFO)) {
                    col = CLDBProto.InstallerTableColumns.RemoveInfo;
                }
                if (col != null) {
                    this.handleInstallerTableOperation(oh, clustername, col);
                }
                return output;
            }
            catch (CLIProcessingException e) {
                String msg = "Installer Command '" + parentCmdName + " " + commandName + "' failed.";
                LOG.error((Object)(msg + " CLIProcessingException exception:"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                String msg = "Installer Command '" + parentCmdName + " " + commandName + "' failed.";
                LOG.error((Object)(msg + " exception:"), (Throwable)e);
                throw new CLIProcessingException(msg + " exception:", (Throwable)e);
            }
        }
        String[] input = this.getInput().getRawInput();
        StringBuilder sb = new StringBuilder();
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        boolean printHelp = false;
        boolean hasPypath = false;
        Object ppath = this.isParamPresent(P_PATH) ? this.getParamTextValue(P_PATH, 0) + " " : DEFAULT_PATH;
        int i = 0;
        for (String str : input) {
            if (++i <= 2) continue;
            if (!printHelp) {
                printHelp = str.equalsIgnoreCase("-h");
            }
            if (str.equalsIgnoreCase("-pypath")) {
                hasPypath = true;
                continue;
            }
            if (hasPypath) {
                hasPypath = false;
                continue;
            }
            if (str.equalsIgnoreCase("-json")) continue;
            sb.append(" " + str);
        }
        Object args = sb.toString();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_CREATE)) {
                String loginUserId = this.getUserLoginId();
                if (loginUserId != null) {
                    args = (String)args + " -o " + loginUserId;
                }
                args = (String)ppath + CREATE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_REMOVE)) {
                args = (String)ppath + REMOVE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_STATUS)) {
                args = (String)ppath + STATUS_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_INFO)) {
                args = (String)ppath + INFO_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_LIST_DEPLOYMENTS)) {
                args = (String)ppath + LIST_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CHECK_FOR_UPDATE)) {
                args = (String)ppath + CHECK_FOR_UPDATE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_UPGRADE)) {
                args = (String)ppath + CLUSTER_UPGRADE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_UPGRADE_STATUS)) {
                args = (String)ppath + CHECK_UPGRADE_STATUS_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_SCALE)) {
                args = (String)ppath + CLUSTER_SCALE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_SCALE_STATUS)) {
                args = (String)ppath + CLUSTER_SCALE_STATUS_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_REMOVE_NODE)) {
                args = (String)ppath + CLUSTER_REMOVE_NODE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_REMOVE_STATUS)) {
                args = (String)ppath + CLUSTER_REMOVE_STATUS_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_GET_CLUSTER_KEY)) {
                args = (String)ppath + GETCLUSTERKEY_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_STORAGE_CONFIG)) {
                args = (String)ppath + STORAGECONFIG_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_DOWNLOAD_LOG)) {
                args = (String)ppath + CLUSTER_DOWNLOAD_LOG_SCRIPT + (String)args;
            } else {
                return new TextCommandOutput("Not a valid installer command".getBytes());
            }
            return this.executeCommand((String)args, printHelp);
        }
        catch (Exception e) {
            LOG.error((Object)("Installer command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("Installer command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput executeCommand(String inputString, boolean printHelp) {
        ArrayList<String> finalCommand;
        int ret;
        ByteArrayOutputStream baos;
        CommandOutput.OutputHierarchy oh;
        CommandOutput output;
        block11: {
            long timeout = 3600000L;
            output = new CommandOutput();
            oh = new CommandOutput.OutputHierarchy();
            output.setOutput(oh);
            String[] command = inputString.split(" ");
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[0x100000];
            ret = -1;
            finalCommand = new ArrayList<String>();
            for (String comToken : command) {
                finalCommand.addAll(Arrays.asList(comToken.split(" ")));
            }
            try {
                ProcessBuilder pb = new ProcessBuilder(finalCommand);
                pb.directory(null);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedInputStream is = new BufferedInputStream(process.getInputStream());
                try {
                    int len;
                    long startProcessingTime = System.currentTimeMillis();
                    while ((len = is.read(buf)) != -1 && System.currentTimeMillis() - startProcessingTime < timeout) {
                        baos.write(buf, 0, len);
                    }
                    if (System.currentTimeMillis() - startProcessingTime >= timeout) break block11;
                    try {
                        ret = process.waitFor();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted Exception during command: " + finalCommand + " run";
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(4, msg));
                        LOG.error((Object)msg, (Throwable)e);
                        CommandOutput commandOutput = output;
                        is.close();
                        process.destroy();
                        return commandOutput;
                    }
                }
                finally {
                    is.close();
                    process.destroy();
                }
            }
            catch (IOException ioex) {
                String msg = "IOException during process firing";
                LOG.error((Object)msg, (Throwable)ioex);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(5, msg));
                return output;
            }
        }
        TextCommandOutput txt = new TextCommandOutput(baos.toByteArray());
        String txtString = txt.toPrettyString().replaceAll("\\\"", "'");
        if (ret != 0) {
            String out = "Error:" + ret + " while running command: " + finalCommand + System.lineSeparator();
            LOG.error((Object)out);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, txtString));
            return output;
        }
        if (printHelp) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(0, txtString));
            return output;
        }
        oh.addMessage(txtString);
        return output;
    }

    private void handleInstallerTableOperation(CommandOutput.OutputHierarchy oh, String clustername, CLDBProto.InstallerTableColumns col) throws CLIProcessingException {
        String parentCmdName = this.cliCommand.getParentCommand().getCommandName();
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(ADD_PARAM)) {
            if (!this.isParamPresent(DATA_PARAM)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'" + parentCmdName + " add ' is invalid without -data"));
                return;
            }
            String filename = this.getParamTextValue(DATA_PARAM, 0);
            this.updateInstallerTable(oh, filename, clustername, col);
        } else if (cmdName.equalsIgnoreCase(GET_PARAM)) {
            this.getFromInstallerTable(oh, clustername, col);
        } else if (cmdName.equalsIgnoreCase(REMOVE_PARAM)) {
            this.removeFromInstallerTable(oh, clustername, col);
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'" + parentCmdName + " " + cmdName + "' is not a valid installer command"));
        }
    }

    private void updateInstallerTable(CommandOutput.OutputHierarchy oh, String filename, String clustername, CLDBProto.InstallerTableColumns col) throws CLIProcessingException {
        CLDBProto.StateRecord record = this.readStateRecordFromFile(oh, clustername, filename, true, true);
        if (record == null) {
            return;
        }
        CLDBProto.InstallerTableUpdateRequest req = CLDBProto.InstallerTableUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setRecord(record).setColumn(col).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerTableUpdateProc.getNumber(), (MessageLite)req, CLDBProto.InstallerTableUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerTableUpdateResponse resp = CLDBProto.InstallerTableUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated installer table for cluster " + clustername);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void getFromInstallerTable(CommandOutput.OutputHierarchy oh, String clustername, CLDBProto.InstallerTableColumns col) throws CLIProcessingException {
        CLDBProto.InstallerTableGetRequest req = CLDBProto.InstallerTableGetRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).setColumn(col).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerTableGetProc.getNumber(), (MessageLite)req, CLDBProto.InstallerTableGetResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerTableGetResponse resp = CLDBProto.InstallerTableGetResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return;
            }
            CLDBProto.StateRecord record = resp.getRecord();
            if (record == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid response, state record missing."));
                return;
            }
            if (this.isParamPresent(FILE_PARAM)) {
                String filename = this.getParamTextValue(FILE_PARAM, 0);
                LOG.debug((Object)("filename: " + filename));
                int status = this.writeStateRecordtoFile(oh, record, filename);
                if (status == 0) {
                    oh.addMessage("Successfully stored " + col + " record for cluster " + clustername + " in " + filename);
                } else {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Error storing " + col + " record for cluster " + clustername + " to file " + filename));
                }
            } else {
                ByteString binaryData = record.getBinaryData();
                String jsonString = binaryData.toString("UTF-8");
                oh.addMessage(jsonString);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void removeFromInstallerTable(CommandOutput.OutputHierarchy oh, String clustername, CLDBProto.InstallerTableColumns col) throws CLIProcessingException {
        CLDBProto.InstallerTableRemoveRequest req = CLDBProto.InstallerTableRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).setColumn(col).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerTableRemoveProc.getNumber(), (MessageLite)req, CLDBProto.InstallerTableRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerTableRemoveResponse resp = CLDBProto.InstallerTableRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                String parentCmdName = this.cliCommand.getParentCommand().getCommandName();
                oh.addMessage("Successfully removed column " + parentCmdName + " for cluster " + clustername);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void handleInstallerState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(ADD_PARAM)) {
            this.addInstallerState(oh, filename, clustername);
        } else if (cmdName.equalsIgnoreCase(UPDATE_PARAM)) {
            this.updateInstallerState(oh, filename, clustername);
        } else if (cmdName.equalsIgnoreCase(REMOVE_PARAM)) {
            this.removeInstallerState(oh, clustername);
        } else if (cmdName.equalsIgnoreCase(GET_PARAM)) {
            this.getInstallerState(oh, filename, clustername);
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'installerstate " + cmdName + "' is not a valid installer command"));
        }
    }

    private void addInstallerState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.StateRecord record = this.readStateRecordFromFile(oh, clustername, filename);
        if (record == null) {
            return;
        }
        CLDBProto.InstallerStateAddRequest req = CLDBProto.InstallerStateAddRequest.newBuilder().setCreds(this.getUserCredentials()).setRecord(record).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerStateAddProc.getNumber(), (MessageLite)req, CLDBProto.InstallerStateAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerStateAddResponse resp = CLDBProto.InstallerStateAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully added installer state for cluster " + clustername);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void updateInstallerState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.StateRecord record = this.readStateRecordFromFile(oh, clustername, filename);
        if (record == null) {
            return;
        }
        CLDBProto.InstallerStateUpdateRequest req = CLDBProto.InstallerStateUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setRecord(record).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerStateUpdateProc.getNumber(), (MessageLite)req, CLDBProto.InstallerStateUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerStateUpdateResponse resp = CLDBProto.InstallerStateUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated installer state");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void removeInstallerState(CommandOutput.OutputHierarchy oh, String clustername) throws CLIProcessingException {
        CLDBProto.InstallerStateRemoveRequest req = CLDBProto.InstallerStateRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerStateRemoveProc.getNumber(), (MessageLite)req, CLDBProto.InstallerStateRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerStateRemoveResponse resp = CLDBProto.InstallerStateRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully removed installer state for cluster " + clustername);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void getInstallerState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.InstallerStateGetRequest req = CLDBProto.InstallerStateGetRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InstallerStateGetProc.getNumber(), (MessageLite)req, CLDBProto.InstallerStateGetResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InstallerStateGetResponse resp = CLDBProto.InstallerStateGetResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return;
            }
            int status = this.writeStateRecordtoFile(oh, resp.getRecord(), filename);
            if (status != 0) {
                return;
            }
            oh.addMessage("Successfully stored installer state for cluster " + clustername + " in " + filename);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void handleInfraState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(ADD_PARAM)) {
            this.addInfraState(oh, filename, clustername);
        } else if (cmdName.equalsIgnoreCase(UPDATE_PARAM)) {
            this.updateInfraState(oh, filename, clustername);
        } else if (cmdName.equalsIgnoreCase(REMOVE_PARAM)) {
            this.removeInfraState(oh, clustername);
        } else if (cmdName.equalsIgnoreCase(GET_PARAM)) {
            this.getInfraState(oh, filename, clustername);
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "infrastate '" + cmdName + "' is not a valid installer command"));
        }
    }

    private void addInfraState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.StateRecord record = this.readStateRecordFromFile(oh, clustername, filename);
        if (record == null) {
            return;
        }
        CLDBProto.InfraStateAddRequest req = CLDBProto.InfraStateAddRequest.newBuilder().setCreds(this.getUserCredentials()).setRecord(record).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InfraStateAddProc.getNumber(), (MessageLite)req, CLDBProto.InfraStateAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InfraStateAddResponse resp = CLDBProto.InfraStateAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully added infra state");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void updateInfraState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.StateRecord record = this.readStateRecordFromFile(oh, clustername, filename);
        if (record == null) {
            return;
        }
        CLDBProto.InfraStateUpdateRequest req = CLDBProto.InfraStateUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setRecord(record).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InfraStateUpdateProc.getNumber(), (MessageLite)req, CLDBProto.InfraStateUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InfraStateUpdateResponse resp = CLDBProto.InfraStateUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated infra state");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void removeInfraState(CommandOutput.OutputHierarchy oh, String clustername) throws CLIProcessingException {
        CLDBProto.InfraStateRemoveRequest req = CLDBProto.InfraStateRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InfraStateRemoveProc.getNumber(), (MessageLite)req, CLDBProto.InfraStateRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InfraStateRemoveResponse resp = CLDBProto.InfraStateRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully removed infra state for cluster " + clustername);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private void getInfraState(CommandOutput.OutputHierarchy oh, String filename, String clustername) throws CLIProcessingException {
        CLDBProto.InfraStateGetRequest req = CLDBProto.InfraStateGetRequest.newBuilder().setCreds(this.getUserCredentials()).setClustername(clustername).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InfraStateGetProc.getNumber(), (MessageLite)req, CLDBProto.InfraStateGetResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.InfraStateGetResponse resp = CLDBProto.InfraStateGetResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return;
            }
            int status = this.writeStateRecordtoFile(oh, resp.getRecord(), filename);
            if (status != 0) {
                return;
            }
            oh.addMessage("Successfully stored infra state for cluster " + clustername + " in " + filename);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException ", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    private boolean isValidJsonFile(String filePath) {
        try {
            FileReader fileReader = new FileReader(filePath);
            JSONTokener tokener = new JSONTokener((Reader)fileReader);
            new JSONObject(tokener);
        }
        catch (JSONException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private CLDBProto.StateRecord readStateRecordFromFile(CommandOutput.OutputHierarchy oh, String clusterName, String filePath) {
        return this.readStateRecordFromFile(oh, clusterName, filePath, false, false);
    }

    private CLDBProto.StateRecord readStateRecordFromFile(CommandOutput.OutputHierarchy oh, String clusterName, String filePath, boolean validateJson, boolean validateFileSize) {
        File file = new File(filePath);
        if (!file.exists()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "File do not exist"));
            return null;
        }
        if (!file.canRead()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(1, "File do not have read permissions"));
            return null;
        }
        if (validateFileSize && file.length() > 20480L) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(1, "File too big for operation"));
            return null;
        }
        if (validateJson && !this.isValidJsonFile(filePath)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(1, "File contents are not valid json"));
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(filePath);
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            ByteString dataBytes = ByteString.copyFrom((byte[])buffer);
            fis.close();
            int cksum = InstallerCommands.calculateChecksum(buffer);
            return CLDBProto.StateRecord.newBuilder().setClusterName(clusterName).setBinaryData(dataBytes).setCksum((long)cksum).build();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Caugh NoSuchAlgorithmException while calculating checksum for data.", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(5, e.getMessage()));
        }
        catch (IOException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(5, e.getMessage()));
            LOG.error((Object)("Caugh IOException while reading from file" + filePath), (Throwable)e);
        }
        return null;
    }

    private int writeStateRecordtoFile(CommandOutput.OutputHierarchy oh, CLDBProto.StateRecord record, String filePath) {
        ByteString binaryData = record.getBinaryData();
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write(binaryData.toByteArray());
            fos.close();
            return 0;
        }
        catch (IOException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(5, e.getMessage()));
            LOG.error((Object)("Caugh IOException while writing to the file" + filePath), (Throwable)e);
            return 5;
        }
    }

    private static int calculateChecksum(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data);
        byte[] checksumBytes = md.digest();
        int checksum = 0;
        for (byte b : checksumBytes) {
            checksum = checksum << 8 | b & 0xFF;
        }
        return checksum;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return null;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return false;
    }
}

