/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.s3serverutils.S3ServerRpcCommonUtils;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class S3UserCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(S3UserCommands.class);
    public static final String S3USER_COMMAND_CREATE = "create";
    public static final String S3USER_COMMAND_REFRESHLDAP = "refreshldap";
    public static final String DOMAINNAME_PARAM = "domainname";
    public static final String ACCOUNTNAME_PARAM = "accountname";
    public static final String USERNAME_PARAM = "username";
    public static final String REFRESH_ALL_PARAM = "all";
    public static final String s3UserCreateUsage = "s3user create -domainname <domain_name> -accountname <account_name> -username <user_name>";
    public static final String s3UserRefreshldapUsage = "s3user refreshldap -username <user_name>-all <true|false>";
    public static final CLICommand s3UserCreateCommand = new CLICommand("create", "", S3UserCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"domainname", (Object)new TextInputParameter("domainname", "<domain_name>", true, null)).put((Object)"accountname", (Object)new TextInputParameter("accountname", "<account_name>", true, null)).put((Object)"username", (Object)new TextInputParameter("username", "<user_name>", true, null)).build(), null).setShortUsage("s3user create -domainname <domain_name> -accountname <account_name> -username <user_name>");
    public static final CLICommand s3UserRefreshldapCommand = new CLICommand("refreshldap", "", S3UserCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"username", (Object)new TextInputParameter("username", "<user_name>", false, null)).put((Object)"all", (Object)new BooleanInputParameter("all", "<true|false>", false, null)).build(), null).setShortUsage("s3user refreshldap -username <user_name>-all <true|false>");
    public static final CLICommand[] s3UserCommands = new CLICommand[]{s3UserCreateCommand, s3UserRefreshldapCommand};
    public static final String s3UserCommandsUsage = "s3user [create, refreshldap]";

    public S3UserCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            switch (commandName) {
                case "create": {
                    return this.createS3User();
                }
                case "refreshldap": {
                    return this.refreshLdapUser();
                }
            }
            LOG.error((Object)("invalid s3user command name:" + commandName));
            return new TextCommandOutput("invalid s3user command".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("s3user command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("s3user command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    CommandOutput createS3User() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String cluster = this.getClusterName();
        String domainname = this.getParamTextValue(DOMAINNAME_PARAM, 0);
        String acname = this.getParamTextValue(ACCOUNTNAME_PARAM, 0);
        String username = this.getParamTextValue(USERNAME_PARAM, 0);
        UnixUserGroupHelper uInfo = new UnixUserGroupHelper();
        CLDBS3ServerProto.S3AddUserRequest request = CLDBS3ServerProto.S3AddUserRequest.newBuilder().setDomainName(domainname).setAccountName(acname).setUserName(username).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3AddUserProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3AddUserResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3AddUserProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3AddUserResponse.class);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server"));
            return output;
        }
        CLDBS3ServerProto.S3AddUserResponse resp = CLDBS3ServerProto.S3AddUserResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "create s3 user failed").setField(USERNAME_PARAM));
        } else {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("accesskey", (Object)resp.getAccessKey()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("secretkey", (Object)resp.getSecretKey()));
            oh.addNode(out);
        }
        return output;
    }

    CommandOutput refreshLdapUser() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        if (this.isParamPresent(REFRESH_ALL_PARAM) && this.isParamPresent(USERNAME_PARAM)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid to use -username along with -all"));
            return output;
        }
        CLDBS3ServerProto.S3RefreshLdapUserRequest.Builder request = CLDBS3ServerProto.S3RefreshLdapUserRequest.newBuilder();
        if (this.isParamPresent(USERNAME_PARAM)) {
            String username = this.getParamTextValue(USERNAME_PARAM, 0);
            request.setUserName(username);
        } else if (this.isParamPresent(REFRESH_ALL_PARAM)) {
            request.setRefreshAll(this.getParamBooleanValue(REFRESH_ALL_PARAM, 0));
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid use. Either -username <username> or -all <true|false> must be provided"));
            return output;
        }
        byte[] data = null;
        String cluster = this.getClusterName();
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3RefreshLdapUserProc.getNumber(), (MessageLite)request.build(), CLDBS3ServerProto.S3RefreshLdapUserResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3RefreshLdapUserProc.getNumber(), (MessageLite)request.build(), CLDBS3ServerProto.S3RefreshLdapUserResponse.class);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server"));
            return output;
        }
        CLDBS3ServerProto.S3RefreshLdapUserResponse resp = CLDBS3ServerProto.S3RefreshLdapUserResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "refreshldap user failed"));
        }
        return output;
    }

    String getClusterName() throws CLIProcessingException {
        return this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite mlResp) throws CLIProcessingException {
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return true;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return null;
    }

    public CLDBS3ServerProto.S3AddUserResponse sendRequest(MessageLite mlReq) throws CLIProcessingException {
        return null;
    }
}

