/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.mapr.cli.common.NodesCommonUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.ZooKeeper;

public class ClusterServicesUtils {
    public static final Log LOG = LogFactory.getLog(NodesCommonUtils.class);
    public static final String MAPR_HOME = "/opt/mapr/conf/";
    public static final String WARDEN_CONF_NAME = "warden.conf";
    public static final String WARDEN_CONF = "/opt/mapr/conf/warden.conf";
    public static final String ZK_STRING_KEY = "zookeeper.servers";
    private static String zkConnectString = ClusterServicesUtils.getZkConnectString();
    private static ClusterServicesUtils s_instance = new ClusterServicesUtils();

    private ClusterServicesUtils() {
    }

    public static ClusterServicesUtils getInstance() {
        return s_instance;
    }

    private static String getZkConnectString() {
        Properties properties = new Properties();
        String zKString = null;
        try (FileInputStream configFile = new FileInputStream(WARDEN_CONF);){
            properties.load(configFile);
            zKString = properties.getProperty(ZK_STRING_KEY);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error((Object)("ClusterSercvicesUtil : " + e.getLocalizedMessage()));
        }
        return zKString;
    }

    public ZooKeeper getZKClient() {
        ZooKeeper zk = NodesCommonUtils.connect(zkConnectString);
        return zk;
    }
}

