/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.bulk;

import com.google.common.collect.Lists;
import com.mapr.cli.bulk.Task;
import com.mapr.cli.bulk.TaskResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class TaskCompletionService
extends ExecutorCompletionService<TaskResult> {
    private static final Logger LOG = Logger.getLogger(TaskCompletionService.class);
    private static final int NUM_THREADS = 3;
    private static final TaskCompletionService service = new TaskCompletionService();
    private int taskCount = 0;

    private TaskCompletionService() {
        super(Executors.newFixedThreadPool(3));
    }

    public static TaskCompletionService getInstance() {
        return service;
    }

    public void submitTasks(Collection<Task> tasks) {
        for (Task task : tasks) {
            this.submit(task);
            ++this.taskCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskResult> fetchResults() {
        ArrayList results = Lists.newArrayList();
        try {
            for (int i = 0; i < this.taskCount; ++i) {
                TaskResult result = (TaskResult)this.take().get();
                if (result == null || result.getStatus() != 0) {
                    LOG.warn((Object)("Task " + result.getTaskName() + " has failed. Reason: " + result.getFailureMsg()));
                }
                results.add(result);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while fetching the results for tasks.", (Throwable)e);
        }
        finally {
            this.taskCount = 0;
        }
        return results;
    }
}

