/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.S3BucketUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRDbKeyValue;
import com.mapr.fs.MapRDbResultScanner;
import com.mapr.fs.MapRDbUtils;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Msicommon;
import com.mapr.fs.proto.iamconstants;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.log4j.Logger;

public class S3BucketCommands
extends ListCommand
implements CLIInterface,
AceHelper.DBPermission {
    public static final String BUCKET_NAME_PARAM = "name";
    public static final String BUCKET_CREATE_PARAM_PATH = "path";
    public static final String BUCKET_IS_WORM = "isworm";
    private static final Logger LOG = Logger.getLogger(S3BucketCommands.class);
    public static final String s3BucketCreateUsage = "s3bucket -name bucketName [-path dirPath]";
    public static final String s3BucketListUsage = "s3bucket -name bucketName";
    public static final String s3BucketRemoveUsage = "s3bucket -name bucketName";
    public static final String s3BucketStatsUsage = "s3bucket";
    public static final CLICommand s3BucketCreateCommand = new CLICommand("create", "", S3BucketCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"path", (Object)new TextInputParameter("path", "path", false, null)).put((Object)"isworm", (Object)new BooleanInputParameter("isworm", "isworm", false, null)).build(), null).setShortUsage("s3bucket -name bucketName [-path dirPath]");
    public static final CLICommand s3BucketListCommand = new CLICommand("list", "", S3BucketCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("s3bucket -name bucketName");
    public static final CLICommand s3BucketRemoveCommand = new CLICommand("remove", "", S3BucketCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("s3bucket -name bucketName");
    public static final CLICommand s3BucketStatsCommand = new CLICommand("stats", "", S3BucketCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).build(), null).setShortUsage("s3bucket");
    public static final CLICommand[] s3BucketCommands = new CLICommand[]{s3BucketCreateCommand, s3BucketListCommand, s3BucketRemoveCommand, s3BucketStatsCommand};

    public S3BucketCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.bucketCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            try {
                return this.bucketList();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.removeS3Bucket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("stats")) {
            try {
                return this.bucketStats();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("S3Bucket command failed".getBytes());
    }

    void init() throws CLIProcessingException {
    }

    CommandOutput bucketCreate() throws CLIProcessingException, IOException {
        String bucketName;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(BUCKET_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Bucket name argument not supplied."));
            return output;
        }
        String path = "";
        if (this.isParamPresent(BUCKET_CREATE_PARAM_PATH)) {
            path = this.getParamTextValue(BUCKET_CREATE_PARAM_PATH, 0);
            if (path == null) {
                path = "";
            }
            while (path.length() > 1 && path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length());
            }
            if (path == "/") {
                path = "";
            }
        }
        if (!this.isValidBucketParams(path, bucketName = this.getParamTextValue(BUCKET_NAME_PARAM, 0), out)) {
            return output;
        }
        boolean isWorm = false;
        if (this.isParamPresent(BUCKET_IS_WORM)) {
            isWorm = this.getParamBooleanValue(BUCKET_IS_WORM, 0);
        }
        String domainName = Common.MapRClusterS3Defaults.getDefaultInstance().getDefaultDomain();
        int aId = Common.MapRClusterS3Defaults.getDefaultInstance().getDefaultAccountId();
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem(this.getUserLoginId());
        byte[] respRcvd = fs.s3BucketCreate(path, bucketName, domainName, aId, isWorm, this.getUserId());
        if (respRcvd == null) {
            LOG.error((Object)("s3bucket create: Bucket Create Failed for bucket " + bucketName));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "s3bucket create: Bucket Create Failed for bucket: " + bucketName));
            return output;
        }
        CLDBS3ServerProto.S3AddBucketResponse resp = CLDBS3ServerProto.S3AddBucketResponse.parseFrom((byte[])respRcvd);
        int status = resp.getStatus();
        if (status != 0) {
            LOG.error((Object)("s3bucket create: Bucket Create Failed for bucket " + bucketName + "(" + status + ")"));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "s3bucket create: Bucket Create Failed for bucket: " + bucketName + "(" + status + ")"));
            return output;
        }
        out.addMessage("bucket Create executed Successfully");
        return output;
    }

    boolean isValidBucketParams(String path, String bucketName, CommandOutput.OutputHierarchy out) {
        if (bucketName == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing bucket name in the command to create bucket").setField(BUCKET_NAME_PARAM));
            return false;
        }
        if (S3BucketUtils.isReservedBucketName((String)bucketName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "S3 Bucket create failed. Can not use 'mapr.internal' as prefix in bucket name, " + Errno.toString((int)1)));
            return false;
        }
        if (!S3BucketUtils.isValidBucketName((String)bucketName)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Bucket Name " + bucketName + ", Allowed characters " + S3BucketUtils.getValidName()));
            return false;
        }
        return true;
    }

    CommandOutput bucketList() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        return output;
    }

    CommandOutput removeS3Bucket() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(BUCKET_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "bucket name not provided"));
            return output;
        }
        String bucketName = this.getParamTextValue(BUCKET_NAME_PARAM, 0);
        if (!this.isValidBucketParams(null, bucketName, out)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "bucket name does not have valid format"));
            return output;
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem(this.getUserLoginId());
        byte[] data = fs.removeS3Bucket(bucketName, this.getUserLoginId());
        if (data == null) {
            LOG.error((Object)("s3 bucket remove failed, bucket:" + bucketName));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "s3 bucket remove failed"));
            return output;
        }
        CLDBS3ServerProto.S3RemoveBucketResponse resp = CLDBS3ServerProto.S3RemoveBucketResponse.parseFrom((byte[])data);
        int status = resp.getStatus();
        if (status != 0) {
            LOG.error((Object)("s3bucket remove failed, bucket:" + bucketName));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "s3 bucket remove failed"));
            return output;
        }
        out.addMessage("bucket removed successfully");
        return output;
    }

    CommandOutput bucketStats() throws CLIProcessingException, IOException {
        MapRDbKeyValue result;
        MapRDbResultScanner bktScanner;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Common.MapRClusterS3Defaults s3ServerDefaults = Common.MapRClusterS3Defaults.getDefaultInstance();
        String globalBucketTablePath = s3ServerDefaults.getS3BucketVolPathDomainPrefix() + s3ServerDefaults.getDefaultDomain() + "/" + s3ServerDefaults.getBucketsTable();
        String defaultCfName = CLDBS3ServerProto.S3ServerDefaults.getDefaultInstance().getDefaultCFName();
        String defaultColumnName = CLDBS3ServerProto.S3ServerDefaults.getDefaultInstance().getDefaultColumnName();
        MapRDbUtils dbUtilObj = new MapRDbUtils();
        dbUtilObj.Init(globalBucketTablePath, defaultCfName, defaultColumnName);
        try {
            bktScanner = dbUtilObj.getScanner(null, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get scanner."));
            return output;
        }
        String BUCKET_COLUMN_BUCKETSTATS = iamconstants.BucketTableCols.getDefaultInstance().getBucketStats();
        String BUCKET_COLUMN_BUCKETPROPS = iamconstants.BucketTableCols.getDefaultInstance().getBucketProp();
        while ((result = bktScanner.next(false)) != null) {
            String bucketName = new String(result.getKey(), StandardCharsets.US_ASCII);
            Map valueMap = result.getValueMap();
            if (valueMap == null || valueMap.size() == 0) {
                LOG.debug((Object)"empty value map in bucket table");
                continue;
            }
            Msicommon.S3BucketStats stats = null;
            Common.S3BucketProperties bucketProps = null;
            CommandOutput.OutputHierarchy.OutputNode bucStats = new CommandOutput.OutputHierarchy.OutputNode();
            try {
                if (valueMap.containsKey(BUCKET_COLUMN_BUCKETSTATS)) {
                    stats = Msicommon.S3BucketStats.parseFrom((byte[])((byte[])valueMap.get(BUCKET_COLUMN_BUCKETSTATS)));
                }
                if (valueMap.containsKey(BUCKET_COLUMN_BUCKETPROPS)) {
                    bucketProps = Common.S3BucketProperties.parseFrom((byte[])((byte[])valueMap.get(BUCKET_COLUMN_BUCKETPROPS)));
                }
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
                LOG.error((Object)"Exception while parsing stats.", (Throwable)e);
                return output;
            }
            if (bucketProps != null) {
                this.formatBucketProperties(bucketProps, bucStats);
            }
            if (stats != null) {
                this.formatBucketStats(stats.getStats(), bucStats, bucketName);
            }
            out.addNode(bucStats);
        }
        return output;
    }

    private void formatBucketProperties(Common.S3BucketProperties props, CommandOutput.OutputHierarchy.OutputNode bucStats) {
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("account", (Object)props.getAccountName()));
    }

    private void formatBucketStats(Msicommon.MSIStatsRec stats, CommandOutput.OutputHierarchy.OutputNode bucStats, String bucketName) {
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("key", (Object)bucketName));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("size", stats.getTotalSzObjects()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("objectCount", stats.getNumObjects()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("inProgressCount", stats.getNumInProgress()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("deleteMarkerCount", stats.getNumDeleteMarkers()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("purgeCount", stats.getNumMarkedForPurge()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("legalHoldCount", stats.getNumLegalHoldEnabled()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("retentionCount", stats.getNumRetentionEnabled()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("complianceCount", stats.getNumComplianceEnabled()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("objectPartsCount", stats.getNumObjectParts()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("multiPartPendingCount", stats.getNumMPPendingStitching()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("inProgressSize", stats.getTotalSzInProgress()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("purgeSize", stats.getTotalSzMarkedForPurge()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("objectPartsSize", stats.getTotalSzObjectParts()));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object256Count", stats.getNumObjectsHisto(0)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object4KCount", stats.getNumObjectsHisto(1)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object64KCount", stats.getNumObjectsHisto(2)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object1MCount", stats.getNumObjectsHisto(3)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object16MCount", stats.getNumObjectsHisto(4)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object256MCount", stats.getNumObjectsHisto(5)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object4GCount", stats.getNumObjectsHisto(6)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object64GCount", stats.getNumObjectsHisto(7)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object1TCount", stats.getNumObjectsHisto(8)));
        bucStats.addChild(new CommandOutput.OutputHierarchy.OutputNode("object8TCount", stats.getNumObjectsHisto(9)));
    }

    public String getCliParam(String key) throws IOException {
        return null;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return false;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return null;
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        return null;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite resp) throws CLIProcessingException {
    }
}

