/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.baseutils.ServiceManagingOperation;
import com.mapr.cli.MapRCLIRegistry;
import com.mapr.cli.RemoveNodeTest;
import com.mapr.cli.ZookeeperServerSetup;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class NodeServicesManagementTest {
    private static ZooKeeper s_zk;
    private static String zookeeperAddresses;
    private static final Logger LOG;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ZookeeperServerSetup.setUpZKServer();
        zookeeperAddresses = "localhost:6181";
        try {
            s_zk = new ZooKeeper(zookeeperAddresses, 30000, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ZookeeperServerSetup.tearDownZKServer();
    }

    @Before
    public void setUp() throws Exception {
        try {
            s_zk.create("/servers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            s_zk.create("/servers/server_", "10.10.10.11".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            s_zk.create("/servers/server_", "10.10.10.10".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            s_zk.create("/servers/server_", "127.0.0.1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            s_zk.create("/servers/server_", "10.10.10.12".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            s_zk.create("/servers/server_", "10.10.10.13".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            s_zk.create("/servers/server_", "10.10.10.14".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @After
    public void tearDown() throws Exception {
        List znodes = s_zk.getChildren("/servers", false);
        for (String node : znodes) {
            s_zk.delete("/servers/" + node, -1);
        }
        s_zk.delete("/servers", -1);
    }

    @Test
    public void createZKStructTest() throws Exception {
        String[] args = new String[]{"node", "services", "-zkconnect", zookeeperAddresses, "-filter", "[ hn == mapr-spitfire1* ]", "-cldb", "start", "-nfs", "stop", "-tasktracker", "resume"};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
        Stat stats = s_zk.exists("/nodes", false);
        Assert.assertNotNull((Object)stats);
        stats = s_zk.exists("/nodes/10.10.10.11/services/" + ServicesEnum.cldb + "/" + ServiceManagingOperation.start, false);
        Assert.assertNotNull((Object)stats);
        stats = s_zk.exists("/nodes/10.10.10.11/services/" + ServicesEnum.nfs + "/" + ServiceManagingOperation.stop, false);
        Assert.assertNotNull((Object)stats);
        stats = s_zk.exists("/nodes/10.10.10.11/services/" + ServicesEnum.tasktracker + "/" + ServiceManagingOperation.resume, false);
        Assert.assertNotNull((Object)stats);
        System.out.print(output.toPrettyString());
    }

    @Test
    public void createData() throws Exception {
        String localzookeeperAddresses = "localhost:5181";
        String[] args = new String[]{"node", "services", "-zkconnect", localzookeeperAddresses, "-filter", "[ip==10*11]", "-tasktracker", "start"};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
    }

    static {
        LOG = Logger.getLogger(RemoveNodeTest.class);
        MapRCLIRegistry.getInstance().register();
    }
}

