/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.BillingProto;
import com.mapr.fs.proto.Common;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class VolumeMetricsCommand
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeMetricsCommand.class);
    public static final String FROM_TIME_PARAM = "from";
    public static final String TILL_TIME_PARAM = "till";
    private static final String START_PARAM_NAME = "start";
    private static final String LIMIT_PARAM_NAME = "limit";
    public static final String DURATION_PARAM = "duration";
    public static final String FILE_NAME = "fileName";
    public static final String CLEAR_TEXT = "clearText";
    private static final int NUM_ENTRIES_PER_RPC = 100;
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd,HH:mm";
    private static final String DATE_TIME_OUTPUT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String TIME_ZONE = "UTC";
    private final Charset UTF_8 = StandardCharsets.UTF_8;
    static String[][] processListFieldNames = new String[][]{{"mem", "memory"}, {"pid", "processid"}, {"cpu", "cpu"}, {"euser", "user"}, {"sz", "realmemoryusage"}, {"rss", "virtualmemoryusage"}, {"pri", "priority"}, {"s", "processstatuscode"}, {"cmd", "command"}};
    public static final CLICommand fetchUsageCmd = new CLICommand("getVolumeUsage", "display cumulative storage usage metrics ", VolumeMetricsCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"from", (Object)new TextInputParameter("from", "start_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"till", (Object)new TextInputParameter("till", "end_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"duration", (Object)new IntegerInputParameter("duration", "duration (in minutes. Minimum value is 60 minutes)", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setUsageInVisible(true).setShortUsage("getVolumeUsage -start <start time> -end <end time> [-duration <duration seconds> -events <1|0> -cluster <clustername>]");
    public static final String volumeMetricsCommandsUsage = "getVolumeUsage ";
    public static final CLICommand[] volumeMetricsCommands = new CLICommand[]{fetchUsageCmd};

    public VolumeMetricsCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private static String prefixedInt(int n) {
        return (n < 10 ? "0" : "") + n;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput cmdOp = new CommandOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("getVolumeUsage")) {
            if (this.isParamPresent(FROM_TIME_PARAM) && !this.isParamPresent(TILL_TIME_PARAM) && !this.isParamPresent(DURATION_PARAM)) {
                String msg = "Invalid paramaters. Either till or duration must be included with from";
                LOG.error((Object)msg);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return cmdOp;
            }
            if ((this.isParamPresent(TILL_TIME_PARAM) || this.isParamPresent(DURATION_PARAM)) && !this.isParamPresent(FROM_TIME_PARAM)) {
                String msg = "Invalid paramaters. Parameter from must be included with till and duration";
                LOG.error((Object)msg);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return cmdOp;
            }
            try {
                this.getVolUsage(oh);
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
                return cmdOp;
            }
        } else if (cmd.equalsIgnoreCase("updateSkipList")) {
            // empty if block
        }
        return cmdOp;
    }

    public void getVolUsage(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.VolumeMetricsListRequest req = (CLDBProto.VolumeMetricsListRequest)this.buildNextRequest(null, null);
        byte[] data = null;
        try {
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMetricsFetchProc.getNumber(), (MessageLite)req, CLDBProto.VolumeMetricsListResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMetricsFetchProc.getNumber(), (MessageLite)req, CLDBProto.VolumeMetricsListResponse.class);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception whilt sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response ...check cldb logs"));
            return;
        }
        CLDBProto.VolumeMetricsListResponse resp = null;
        try {
            resp = CLDBProto.VolumeMetricsListResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() == 0) {
            for (CLDBProto.UsageStat stat : resp.getStatsList()) {
                CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
                this.formatVolumeStats(stat, outputNode);
                oh.addNode(outputNode);
            }
        } else if (resp.hasErrMsg()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateMetricUsgaeFile(CommandOutput.OutputHierarchy oh, String file, boolean isFromParamPresent, boolean clearText) throws CLIProcessingException {
        CLDBProto.UsageFileRequest.Builder reqBuilder = CLDBProto.UsageFileRequest.newBuilder();
        if (isFromParamPresent) {
            long endTimeInMillis = 0L;
            Date startDate = this.getValidDate(FROM_TIME_PARAM);
            if (startDate == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for from parameter."));
                return;
            }
            long startTimeInMillis = startDate.getTime();
            if (this.isParamPresent(TILL_TIME_PARAM)) {
                Date endDate = this.getValidDate(TILL_TIME_PARAM);
                if (endDate == null) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid value for till parameter."));
                    return;
                }
                endTimeInMillis = endDate.getTime();
            } else {
                Integer mints = this.getParamIntValue(DURATION_PARAM, 0);
                endTimeInMillis = startTimeInMillis + (long)(mints * 60 * 1000);
            }
            reqBuilder.setFromInMS(startTimeInMillis).setTillInMS(endTimeInMillis);
        }
        reqBuilder.setCreds(this.getUserCredentials()).setClearText(clearText);
        CLDBProto.UsageFileRequest req = reqBuilder.build();
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.GenerateUsageFileProc.getNumber(), (MessageLite)req, CLDBProto.UsageFileResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest " + e));
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response ...check cldb logs"));
            return;
        }
        CLDBProto.UsageFileResponse resp = null;
        try {
            resp = CLDBProto.UsageFileResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() == 0) {
            String usageString = resp.getUsageFile();
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.UTF_8));
                writer.append(usageString);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while writing to file ", (Throwable)e);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Facing issues while writing to file " + e.getMessage()));
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Exception while closing file writer ", (Throwable)ex);
                }
            }
            CommandOutput.OutputHierarchy.OutputNode usageNode = new CommandOutput.OutputHierarchy.OutputNode();
            usageNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("usages", (Object)resp.getUsageFile()));
            oh.addNode(usageNode);
            oh.addMessage("Usage Metric data written to the file " + file);
        } else if (resp.hasErrMsg()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
        }
    }

    private void formatVolumeStats(CLDBProto.UsageStat stat, CommandOutput.OutputHierarchy.OutputNode outputNode) {
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("epoch", stat.getTimestampInMS()));
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("timestamp", (Object)this.getUTCFormattedTime(stat.getTimestampInMS())));
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicaldata", (Object)(stat.getUsageInMb() + " MB")));
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
    }

    private String getUTCFormattedTime(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_OUTPUT_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        return sdf.format(time);
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy oh, MessageLite response) throws CLIProcessingException {
        CLDBProto.VolumeMetricsListResponse resp = (CLDBProto.VolumeMetricsListResponse)response;
        for (CLDBProto.UsageStat stat : resp.getStatsList()) {
            CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
            this.formatVolumeStats(stat, outputNode);
            oh.addNode(outputNode);
        }
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.VolumeMetricsListRequest.Builder newReqBuilder = null;
        int origStart = this.getStartParamValue();
        int origLimit = this.getLimitParamValue();
        if (prevReq == null) {
            CLIProto.Limiter limiter = this.getNextLimiter(origStart, 0, origStart, origLimit, 100);
            long startTimeInMillis = 0L;
            long endTimeInMillis = 0L;
            if (this.isParamPresent(FROM_TIME_PARAM)) {
                Date startDate = this.getValidDate(FROM_TIME_PARAM);
                if (startDate == null) {
                    throw new CLIProcessingException("Invalid from argument.");
                }
                startTimeInMillis = startDate.getTime();
            }
            if (this.isParamPresent(TILL_TIME_PARAM)) {
                Date endDate = this.getValidDate(TILL_TIME_PARAM);
                if (endDate == null) {
                    throw new CLIProcessingException("Invalid till argument.");
                }
                endTimeInMillis = endDate.getTime();
            } else {
                Integer mints = this.getParamIntValue(DURATION_PARAM, 0);
                endTimeInMillis = startTimeInMillis + (long)(mints * 60 * 1000);
            }
            newReqBuilder = CLDBProto.VolumeMetricsListRequest.newBuilder().setCreds(this.getUserCredentials()).setLimiter(limiter).setFromInMS(startTimeInMillis).setTillInMS(endTimeInMillis);
        } else {
            CLDBProto.VolumeMetricsListRequest req = (CLDBProto.VolumeMetricsListRequest)prevReq;
            CLDBProto.VolumeMetricsListResponse resp = (CLDBProto.VolumeMetricsListResponse)prevResp;
            int prevStart = req.getLimiter().getStart();
            int prevCount = resp.getStatsCount();
            CLIProto.Limiter limiter = this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100);
            newReqBuilder = req.toBuilder().setLimiter(limiter);
        }
        return newReqBuilder.build();
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.VolumeMetricsListRequest req = (CLDBProto.VolumeMetricsListRequest)request;
        byte[] replyData = null;
        try {
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMetricsFetchProc.getNumber(), (MessageLite)req, CLDBProto.VolumeMetricsListResponse.class);
            } else {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeMetricsFetchProc.getNumber(), (MessageLite)req, CLDBProto.VolumeMetricsListResponse.class);
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.VolumeMetricsListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into VolumeMetricsListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
        return null;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.VolumeMetricsListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.VolumeMetricsListResponse)prevResp).getStatsCount());
    }

    private Date getValidDate(String param) {
        Date dt = null;
        try {
            String value = this.getParamTextValue(param, 0);
            if (value == null) {
                LOG.error((Object)("Invalid " + param + " time"));
                return null;
            }
            try {
                dt = new Date(Long.parseLong(value));
            }
            catch (NumberFormatException nfe) {
                try {
                    SimpleDateFormat dateInstance = new SimpleDateFormat(DATE_TIME_FORMAT);
                    dateInstance.setLenient(false);
                    dt = dateInstance.parse(value);
                }
                catch (ParseException pe) {
                    LOG.error((Object)("Caught ParseException parsing " + param + " time. " + pe.getMessage()));
                    return null;
                }
            }
            if (dt == null) {
                return null;
            }
            if (!dt.after(DateFormat.getDateInstance(3).parse("1/1/70"))) {
                LOG.error((Object)(param + " time cannot be before Unix epoch (1/1/70)"));
                return null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while parsing " + param + " date " + e.getMessage()));
        }
        return dt;
    }

    private class MetricsDate {
        public int month;
        public int date;
        public int year;
        public int hour;

        MetricsDate(int m, int d, int y, int h) {
            this.month = m;
            this.date = d;
            this.year = y;
            this.hour = h;
        }

        MetricsDate(Date d) {
            this.month = d.getMonth() + 1;
            this.date = d.getDate();
            this.year = 1900 + d.getYear();
            this.hour = d.getHours();
        }
    }
}

