/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsUtil;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class DbCfColumnSecurityPolicyCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCfColumnSecurityPolicyCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String COLNAME_PARAM_NAME = "name";
    private static final String SECURITY_POLICY_PARAM_NAME = "securitypolicy";
    private static final String OUTPUT_PARAM_NAME = "output";
    private List<String> securityPolicyTagList = new ArrayList<String>();
    private TableProperties tableProp;
    private static final String dbCfColumnSecurityPolicyAddUsage = "table cf column securitypolicy add -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ";
    private static final String dbCfColumnSecurityPolicySetUsage = "table cf column securitypolicy set -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ";
    private static final String dbCfColumnSecurityPolicyRemoveUsage = "table cf column securitypolicy remove -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ";
    private static final String dbCfColumnSecurityPolicyListUsage = "table cf column securitypolicy list -path <path> -cfname <column family name> -name <column name> -output verbose|terse ";
    private static final CLICommand dbCfColumnSecurityPolicyAddCommand = new CLICommand("add", "table cf column securitypolicy add -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ", DbCfColumnSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf column securitypolicy add -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ");
    private static final CLICommand dbCfColumnSecurityPolicySetCommand = new CLICommand("set", "table cf column securitypolicy set -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ", DbCfColumnSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf column securitypolicy set -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ");
    private static final CLICommand dbCfColumnSecurityPolicyRemoveCommand = new CLICommand("remove", "table cf column securitypolicy remove -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ", DbCfColumnSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf column securitypolicy remove -path <path> -cfname <column family name> -name <column name> -securitypolicy <policy1,policy2,...> ");
    private static final CLICommand dbCfColumnSecurityPolicyListCommand = new CLICommand("list", "table cf column securitypolicy list -path <path> -cfname <column family name> -name <column name> -output verbose|terse ", DbCfColumnSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).build(), null).setShortUsage("table cf column securitypolicy list -path <path> -cfname <column family name> -name <column name> -output verbose|terse ");
    public static final CLICommand DbCfColumnSecurityPolicyCommands = new CLICommand("securitypolicy", "securitypolicy", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{dbCfColumnSecurityPolicyAddCommand, dbCfColumnSecurityPolicySetCommand, dbCfColumnSecurityPolicyRemoveCommand, dbCfColumnSecurityPolicyListCommand}).setShortUsage("securitypolicy [add|set|remove|list]");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"path", (Object)"p").put((Object)"cfname", (Object)"cfn").put((Object)"name", (Object)"n").put((Object)"securitypolicy", (Object)"sp").build();

    public DbCfColumnSecurityPolicyCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(dbCfColumnSecurityPolicyAddCommand.getCommandName())) {
            this.addDbCfColumnSecurityPolicy(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(dbCfColumnSecurityPolicySetCommand.getCommandName())) {
            this.setDbCfColumnSecurityPolicy(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(dbCfColumnSecurityPolicyRemoveCommand.getCommandName())) {
            this.removeDbCfColumnSecurityPolicy(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(dbCfColumnSecurityPolicyListCommand.getCommandName())) {
            this.listDbCfColumnSecurityPolicy(out);
        }
        return output;
    }

    private void addDbCfColumnSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfColumnSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_ADD, false);
    }

    private void setDbCfColumnSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfColumnSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_SET, true);
    }

    private void removeDbCfColumnSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfColumnSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_REMOVE, false);
    }

    private void listDbCfColumnSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block10: {
            final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            TableProperties tableProp = null;
            boolean isJson = false;
            final ArrayList tablePropList = new ArrayList();
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColumnSecurityPolicyCommands.this.getUserLoginId());
                        try {
                            TableProperties tProp = null;
                            tProp = mfs.getTableProperties(new Path(tablePath));
                            tablePropList.add(tProp);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                return;
            }
            tableProp = (TableProperties)tablePropList.get(0);
            try {
                ByteString colName = null;
                isJson = tableProp.getAttr().getJson();
                Dbserver.ColumnFamilyAttr cfAttr = com.mapr.cli.DbCfColumnSecurityPolicyCommands.getColumnFamily(tablePath, cfName);
                Dbserver.SchemaFamily cf = cfAttr.getSchFamily();
                if (cf != null) {
                    boolean cfPrefix;
                    boolean bl = cfPrefix = isJson && !cfName.equals("default");
                    if (this.isParamPresent(COLNAME_PARAM_NAME)) {
                        String colNameStr = this.getParamTextValue(COLNAME_PARAM_NAME, 0);
                        colName = cfPrefix ? ByteString.copyFromUtf8((String)MapRFsUtil.getPrefixedColName((String)colNameStr)) : ByteString.copyFromUtf8((String)colNameStr);
                    }
                    for (int i = 0; i < cfAttr.getColumnAttrCount(); ++i) {
                        Dbserver.ColumnAttr col = cfAttr.getColumnAttr(i);
                        if (colName != null && !colName.equals((Object)col.getQualifier())) continue;
                        CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                        String postFixCF = cfPrefix ? MapRFsUtil.getUnPrefixedColName((String)col.getQualifier().toStringUtf8()) : col.getQualifier().toStringUtf8();
                        ArrayList<String> securityPolicyTagsList = new ArrayList<String>();
                        if (col != null && col.hasSecurityPolicyIds()) {
                            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                            Dbserver.SecurityPolicyIds spIds = col.getSecurityPolicyIds();
                            for (int j = 0; j < spIds.getIdsCount(); ++j) {
                                String securityPolicyTag = mfs.getSecurityPolicyName(spIds.getIds(j));
                                if (securityPolicyTag == null) continue;
                                securityPolicyTagsList.add(securityPolicyTag);
                            }
                        }
                        if (securityPolicyTagsList.isEmpty()) continue;
                        colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COLNAME_PARAM_NAME), (Object)postFixCF));
                        CommandOutput.OutputHierarchy.OutputNode columnSecurityPolicyTagsNode = new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(SECURITY_POLICY_PARAM_NAME), securityPolicyTagsList);
                        colNode.addChild(columnSecurityPolicyTagsNode);
                        out.addNode(colNode);
                    }
                    break block10;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
        }
    }

    private void _setDbCfColumnSecurityPolicy(CommandOutput.OutputHierarchy out, final Dbserver.SecurityPolicyOperation op, boolean allowNullTags) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            final String tablePath = com.mapr.cli.DbCfColumnSecurityPolicyCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            boolean isJson = false;
            this.getTableProps(new Path(tablePath));
            isJson = this.isJsonTable(tablePath);
            String colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            ByteString colByteName = ByteString.copyFromUtf8((String)colName);
            Dbserver.ColumnFamilyAttr cfAttr = com.mapr.cli.DbCfColumnSecurityPolicyCommands.getColumnFamily(tablePath, cfName);
            if (cfAttr == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            final Dbserver.SchemaFamily schFamily = cfAttr.getSchFamily();
            if (schFamily == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column family " + cfName + " not found under table " + tablePath));
                return;
            }
            String user = this.getUserLoginId();
            if (this.isParamPresent(SECURITY_POLICY_PARAM_NAME)) {
                String securityPolicyTags = this.getParamTextValue(SECURITY_POLICY_PARAM_NAME, 0);
                if (!this.validateAndAddSecurityPolicyTags(this.securityPolicyTagList, securityPolicyTags, allowNullTags)) {
                    if (op == Dbserver.SecurityPolicyOperation.SPOP_SET) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify empty string or comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    } else {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify non-null comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    }
                    return;
                }
                if (!isJson) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Security policy tags are supported for JSON DB tables only").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The -securitypolicy parameter is required").setField(SECURITY_POLICY_PARAM_NAME));
                return;
            }
            List securityPolicyIdTagListToModify = mfs.getSecurityPolicyIds(this.securityPolicyTagList);
            Dbserver.SecurityPolicyIds.Builder securityPolicyIdsBuilder = Dbserver.SecurityPolicyIds.newBuilder();
            securityPolicyIdsBuilder.addAllIds((Iterable)securityPolicyIdTagListToModify);
            Dbserver.ColumnAttr.Builder colAttrBuilder = Dbserver.ColumnAttr.newBuilder();
            colAttrBuilder.setQualifier(colByteName);
            colAttrBuilder.setSecurityPolicyIds(securityPolicyIdsBuilder.build());
            Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = cfAttr.toBuilder();
            if (cfAttrBuilder.getColumnAttrCount() > 0) {
                cfAttrBuilder.clearColumnAttr();
            }
            final Dbserver.ColumnFamilyAttr newCfAttr = cfAttrBuilder.clearAces().clearSchFamily().clearJsonFamilyPath().addColumnAttr(colAttrBuilder.build()).build();
            final DbCfColumnSecurityPolicyCommands self = this;
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    mfs.modifyColumnFamily(new Path(tablePath), schFamily.getName(), newCfAttr, op, self);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void getTableProps(final Path tablePath) throws IOException, CLIProcessingException {
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                TableProperties tableProp = mfs.getTableProperties(tablePath);
                DbCfColumnSecurityPolicyCommands.this.setTableProps(tableProp);
            }
        };
    }

    private void setTableProps(TableProperties tableProp) {
        this.tableProp = tableProp;
    }

    private Dbserver.TableAttr getTableAttr(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            Dbserver.TableAttr attr = this.getTableAttr(path);
            return attr.getJson();
        }
        catch (IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    public static String getTransformedPath(String path, String user) {
        if (((String)path).contains("\\")) {
            path = ((String)path).replace('\\', '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/user/" + user + "/" + (String)path;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query path: " + (String)path + ", User: " + user));
        }
        return path;
    }

    private UserGroupInformation getProxyUser() throws IOException {
        UserGroupInformation currUser = UserGroupInformation.getLoginUser();
        if (currUser.getUserName().equals(this.getUserLoginId())) {
            return currUser;
        }
        return UserGroupInformation.createProxyUser((String)this.getUserLoginId(), (UserGroupInformation)currUser);
    }

    boolean validateAndAddSecurityPolicyTags(List<String> securityPolicyList, String securityPolicies, boolean allowNullTags) {
        if (allowNullTags && (securityPolicies == null || securityPolicies.length() == 0)) {
            return true;
        }
        String[] tokens = securityPolicies.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            String next = tokens[i];
            if (next.length() == 0) {
                return false;
            }
            securityPolicyList.add(next);
        }
        return true;
    }

    private static Dbserver.ColumnFamilyAttr getColumnFamily(String tablePath, String cfName) throws IOException, CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for column family " + cfName));
        }
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        for (Dbserver.ColumnFamilyAttr cf : mfs.listColumnFamily(new Path(tablePath), true)) {
            if (!cf.getSchFamily().getName().equals(cfName)) continue;
            return cf;
        }
        return null;
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? verboseToTerseMap.get(verboseName) : verboseName;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key) && (ret = this.getParamTextValue(key, 0)) != null) {
                ret = ret.trim();
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

