/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsUtil;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DynamicDataMaskCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DynamicDataMaskCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String COLNAME_PARAM_NAME = "name";
    private static final String DATA_MASK_PARAM_NAME = "datamask";
    private List<String> securityPolicyTagList = new ArrayList<String>();
    private TableProperties tableProp;
    private static final String dataMaskSetUsage = "table cf column datamask set -path <path> -cfname <column family name> -name <column name> -datamask <data mask name> ";
    private static final String dataMaskGetUsage = "table cf column datamask get -path <path> -cfname <column family name> -name <column name> ";
    private static final String dataMaskRemoveUsage = "table cf column datamask remove -path <path> -cfname <column family name> -name <column name> ";
    private static final CLICommand dataMaskSetCommand = new CLICommand("set", "table cf column datamask set -path <path> -cfname <column family name> -name <column name> -datamask <data mask name> ", DynamicDataMaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", true, null)).put((Object)"datamask", (Object)new TextInputParameter("datamask", "data mask name", true, null)).build(), null).setShortUsage("table cf column datamask set -path <path> -cfname <column family name> -name <column name> -datamask <data mask name> ");
    private static final CLICommand dataMaskGetCommand = new CLICommand("get", "table cf column datamask get -path <path> -cfname <column family name> -name <column name> ", DynamicDataMaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", false, null)).build(), null).setShortUsage("table cf column datamask get -path <path> -cfname <column family name> -name <column name> ");
    private static final CLICommand dataMaskRemoveCommand = new CLICommand("remove", "table cf column datamask remove -path <path> -cfname <column family name> -name <column name> ", DynamicDataMaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "column name", true, null)).build(), null).setShortUsage("table cf column datamask remove -path <path> -cfname <column family name> -name <column name> ");
    public static final CLICommand DynamicDataMaskCommands = new CLICommand("datamask", "datamask", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{dataMaskSetCommand, dataMaskGetCommand, dataMaskRemoveCommand}).setShortUsage("datamask [set|get|remove]");

    public DynamicDataMaskCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(dataMaskSetCommand.getCommandName())) {
            this.setDataMask(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(dataMaskGetCommand.getCommandName())) {
            this.getDataMask(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(dataMaskRemoveCommand.getCommandName())) {
            this.removeDataMask(out);
        }
        return output;
    }

    private void setDataMask(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (this.isParamPresent(DATA_MASK_PARAM_NAME)) {
            this.editDataMask(out, this.getParamTextValue(DATA_MASK_PARAM_NAME, 0));
        }
    }

    private void getDataMask(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block9: {
            final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            TableProperties tableProp = null;
            boolean isJson = false;
            final ArrayList tablePropList = new ArrayList();
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DynamicDataMaskCommands.this.getUserLoginId());
                        try {
                            TableProperties tProp = null;
                            tProp = mfs.getTableProperties(new Path(tablePath));
                            tablePropList.add(tProp);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                return;
            }
            tableProp = (TableProperties)tablePropList.get(0);
            try {
                ByteString colName = null;
                isJson = tableProp.getAttr().getJson();
                Dbserver.ColumnFamilyAttr cfAttr = com.mapr.cli.DynamicDataMaskCommands.getColumnFamily(tablePath, cfName);
                Dbserver.SchemaFamily cf = cfAttr.getSchFamily();
                if (cf != null) {
                    boolean cfPrefix;
                    boolean bl = cfPrefix = isJson && !cfName.equals("default");
                    if (this.isParamPresent(COLNAME_PARAM_NAME)) {
                        String colNameStr = this.getParamTextValue(COLNAME_PARAM_NAME, 0);
                        colName = cfPrefix ? ByteString.copyFromUtf8((String)MapRFsUtil.getPrefixedColName((String)colNameStr)) : ByteString.copyFromUtf8((String)colNameStr);
                    }
                    for (int i = 0; i < cfAttr.getColumnAttrCount(); ++i) {
                        Dbserver.ColumnAttr col = cfAttr.getColumnAttr(i);
                        if (!col.hasDataMaskId() || colName != null && !colName.equals((Object)col.getQualifier())) continue;
                        CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                        String postFixCF = cfPrefix ? MapRFsUtil.getUnPrefixedColName((String)col.getQualifier().toStringUtf8()) : col.getQualifier().toStringUtf8();
                        String dataMaskName = "";
                        int dataMaskId = 0;
                        if (col != null && col.hasDataMaskId()) {
                            dataMaskId = col.getDataMaskId();
                            dataMaskName = mfs.getDataMaskNameFromId(dataMaskId);
                        }
                        colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COLNAME_PARAM_NAME, (Object)postFixCF));
                        CommandOutput.OutputHierarchy.OutputNode columnDataMaskNode = new CommandOutput.OutputHierarchy.OutputNode(DATA_MASK_PARAM_NAME, (Object)dataMaskName);
                        colNode.addChild(columnDataMaskNode);
                        out.addNode(colNode);
                    }
                    break block9;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
        }
    }

    private void removeDataMask(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this.editDataMask(out, "");
    }

    private void editDataMask(CommandOutput.OutputHierarchy out, String dataMaskName) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            final String tablePath = com.mapr.cli.DynamicDataMaskCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            boolean isJson = false;
            this.getTableProps(new Path(tablePath));
            isJson = this.isJsonTable(tablePath);
            String colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            ByteString colByteName = ByteString.copyFromUtf8((String)colName);
            Dbserver.ColumnFamilyAttr cfAttr = com.mapr.cli.DynamicDataMaskCommands.getColumnFamily(tablePath, cfName);
            if (cfAttr == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            final Dbserver.SchemaFamily schFamily = cfAttr.getSchFamily();
            if (schFamily == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column family " + cfName + " not found under table " + tablePath));
                return;
            }
            String user = this.getUserLoginId();
            if (!isJson) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Data Masks are supported for JSON DB tables only").setField(DATA_MASK_PARAM_NAME));
                return;
            }
            if (!dataMaskName.equals("")) {
                final HashSet dmNames = new HashSet();
                try {
                    new FileclientRun(this.getUserLoginId()){

                        @Override
                        public void runAsProxyUser() throws CLIProcessingException, IOException {
                            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                            List dms = mfs.getAllDataMasks();
                            for (Dbserver.DataMask dm : dms) {
                                dmNames.add(dm.getName());
                            }
                        }
                    };
                }
                catch (IOException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                }
                catch (CLIProcessingException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
                if (dmNames.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not retrieve data masks for validation"));
                    return;
                }
                if (!dmNames.contains(dataMaskName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, dataMaskName + " is not a valid data mask"));
                    return;
                }
            }
            Dbserver.ColumnAttr.Builder colAttrBuilder = Dbserver.ColumnAttr.newBuilder();
            colAttrBuilder.setQualifier(colByteName);
            if (!dataMaskName.equals("")) {
                Dbserver.DataMask dm = mfs.getDataMask(dataMaskName);
                colAttrBuilder.setDataMaskId(dm.getId());
            } else {
                colAttrBuilder.setDataMaskId(0);
            }
            Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = cfAttr.toBuilder();
            if (cfAttrBuilder.getColumnAttrCount() > 0) {
                cfAttrBuilder.clearColumnAttr();
            }
            final Dbserver.ColumnFamilyAttr newCfAttr = cfAttrBuilder.clearAces().clearSchFamily().clearJsonFamilyPath().addColumnAttr(colAttrBuilder.build()).build();
            final DynamicDataMaskCommands self = this;
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    mfs.modifyColumnFamily(new Path(tablePath), schFamily.getName(), newCfAttr, Dbserver.SecurityPolicyOperation.SPOP_NONE, self);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void getTableProps(final Path tablePath) throws IOException, CLIProcessingException {
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                TableProperties tableProp = mfs.getTableProperties(tablePath);
                DynamicDataMaskCommands.this.setTableProps(tableProp);
            }
        };
    }

    private void setTableProps(TableProperties tableProp) {
        this.tableProp = tableProp;
    }

    private Dbserver.TableAttr getTableAttr(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            Dbserver.TableAttr attr = this.getTableAttr(path);
            return attr.getJson();
        }
        catch (IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    public static String getTransformedPath(String path, String user) {
        if (((String)path).contains("\\")) {
            path = ((String)path).replace('\\', '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/user/" + user + "/" + (String)path;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query path: " + (String)path + ", User: " + user));
        }
        return path;
    }

    private static Dbserver.ColumnFamilyAttr getColumnFamily(String tablePath, String cfName) throws IOException, CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for column family " + cfName));
        }
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        for (Dbserver.ColumnFamilyAttr cf : mfs.listColumnFamily(new Path(tablePath), true)) {
            if (!cf.getSchFamily().getName().equals(cfName)) continue;
            return cf;
        }
        return null;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key) && (ret = this.getParamTextValue(key, 0)) != null) {
                ret = ret.trim();
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

