/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.MapRCLIRegistry;
import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import org.apache.log4j.Logger;
import org.junit.Test;

public class ScheduleProcessingTests {
    private static final Logger LOG = Logger.getLogger(ScheduleProcessingTests.class);

    @Test
    public void schedulePolicyCreateTest() throws Exception {
        String jsonCreate = "{ id:7, name:\"combo schedule\", rules: [ { frequency:\"hourly\", retain:\"4h\" }, { frequency:\"daily\", time:0, retain:\"7d\" }, { frequency:\"daily\", time:12, retain:\"7d\" }, { frequency:\"weekly\", date:\"sun\", time:0, retain:\"4w\" } ] }";
        String[] args = new String[]{"schedule", "create", "-schedule", jsonCreate};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
        System.out.print(output.toPrettyString());
    }

    @Test
    public void schedulePolicyListTest() throws Exception {
        String[] args = new String[]{"schedule", "list"};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
        System.out.print(output.toPrettyString());
    }

    @Test
    public void schedulePolicyModifyTest() throws Exception {
        String rules = "[ { frequency:\"hourly\", retain:\"4h\" }, { frequency:\"daily\", time:0, retain:\"7d\" }, { frequency:\"daily\", time:12, retain:\"7d\" }, { frequency:\"weekly\", date:\"sun\", time:0, retain:\"10w\" },  { frequency:\"once\", date:\"12/31/2010\", time:23, retain:\"12y\" }]";
        String[] args = new String[]{"schedule", "modify", "-id", "0", "-name", "new name", "-rules", rules};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
        System.out.print(output.toPrettyString());
    }

    @Test
    public void schedulePolicyRemoveTest() throws Exception {
        String[] args = new String[]{"schedule", "remove", "-id", "4"};
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            System.out.print(CLICommandFactory.getInstance().getUsage(false));
            return;
        }
        if (!commandIFace.validateInput()) {
            System.out.print(commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree());
            return;
        }
        CommandOutput output = commandIFace.executeCommand();
        System.out.print(output.toPrettyString());
    }

    static {
        MapRCLIRegistry.getInstance().register();
    }
}

