/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class DbCfSecurityPolicyCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCfSecurityPolicyCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String USER_PARAM_NAME = "user";
    private static final String SECURITY_POLICY_PARAM_NAME = "securitypolicy";
    private List<String> securityPolicyTagList = new ArrayList<String>();
    private TableProperties tableProp;
    private static final String cfSecurityPolicyAddUsage = "table cf securitypolicy add -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ";
    private static final String cfSecurityPolicySetUsage = "table cf securitypolicy set -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ";
    private static final String cfSecurityPolicyRemoveUsage = "table cf securitypolicy remove -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ";
    private static final CLICommand cfSecurityPolicyAddCommand = new CLICommand("add", "table cf securitypolicy add -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ", DbCfSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "cfname", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf securitypolicy add -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ");
    private static final CLICommand cfSecurityPolicySetCommand = new CLICommand("set", "table cf securitypolicy add -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ", DbCfSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "cfname", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf securitypolicy set -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ");
    private static final CLICommand cfSecurityPolicyRemoveCommand = new CLICommand("remove", "table cf securitypolicy remove -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ", DbCfSecurityPolicyCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "cfname", true, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Comma-separated list of security policy tags", true, null)).build(), null).setShortUsage("table cf securitypolicy remove -path <path> -cfname <cfname> -securitypolicy <policy1,policy2,...> ");
    public static final CLICommand DbCfSecurityPolicyCommands = new CLICommand("securitypolicy", "securitypolicy", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{cfSecurityPolicyAddCommand, cfSecurityPolicySetCommand, cfSecurityPolicyRemoveCommand}).setShortUsage("securitypolicy [add|set|remove]");

    public DbCfSecurityPolicyCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(cfSecurityPolicyAddCommand.getCommandName())) {
            this.addDbCfSecurityPolicy(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(cfSecurityPolicySetCommand.getCommandName())) {
            this.setDbCfSecurityPolicy(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(cfSecurityPolicyRemoveCommand.getCommandName())) {
            this.removeDbCfSecurityPolicy(out);
        }
        return output;
    }

    private void addDbCfSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_ADD, false);
    }

    private void setDbCfSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_SET, true);
    }

    private void removeDbCfSecurityPolicy(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        this._setDbCfSecurityPolicy(out, Dbserver.SecurityPolicyOperation.SPOP_REMOVE, false);
    }

    private void _setDbCfSecurityPolicy(CommandOutput.OutputHierarchy out, final Dbserver.SecurityPolicyOperation op, boolean allowNullTags) throws CLIProcessingException {
        try {
            String user;
            final String path = com.mapr.cli.DbCfSecurityPolicyCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            final String cfname = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            String string = user = this.isParamPresent(USER_PARAM_NAME) ? this.getParamTextValue(USER_PARAM_NAME, 0) : this.getUserLoginId();
            if (this.isParamPresent(SECURITY_POLICY_PARAM_NAME)) {
                String securityPolicyTags = this.getParamTextValue(SECURITY_POLICY_PARAM_NAME, 0);
                if (!this.validateAndAddSecurityPolicyTags(this.securityPolicyTagList, securityPolicyTags, allowNullTags)) {
                    if (op == Dbserver.SecurityPolicyOperation.SPOP_SET) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify empty string or comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    } else {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify non-null comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    }
                    return;
                }
                this.getTableProps(new Path(path));
                if (!this.isJsonTable(path)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Security policy tags are supported for JSON DB tables only").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
            }
            final DbCfSecurityPolicyCommands self = this;
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    mfs.modifyDbCfSecurityPolicy(new Path(path), self, DbCfSecurityPolicyCommands.this.securityPolicyTagList, op, cfname);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void getTableProps(final Path tablePath) throws IOException, CLIProcessingException {
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                TableProperties tableProp = mfs.getTableProperties(tablePath);
                DbCfSecurityPolicyCommands.this.setTableProps(tableProp);
            }
        };
    }

    private void setTableProps(TableProperties tableProp) {
        this.tableProp = tableProp;
    }

    private Dbserver.TableAttr getTableAttr(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            Dbserver.TableAttr attr = this.getTableAttr(path);
            return attr.getJson();
        }
        catch (IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    public static String getTransformedPath(String path, String user) {
        if (((String)path).contains("\\")) {
            path = ((String)path).replace('\\', '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/user/" + user + "/" + (String)path;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query path: " + (String)path + ", User: " + user));
        }
        return path;
    }

    private UserGroupInformation getProxyUser() throws IOException {
        UserGroupInformation currUser = UserGroupInformation.getLoginUser();
        if (currUser.getUserName().equals(this.getUserLoginId())) {
            return currUser;
        }
        return UserGroupInformation.createProxyUser((String)this.getUserLoginId(), (UserGroupInformation)currUser);
    }

    boolean validateAndAddSecurityPolicyTags(List<String> securityPolicyList, String securityPolicies, boolean allowNullTags) {
        if (allowNullTags && (securityPolicies == null || securityPolicies.length() == 0)) {
            return true;
        }
        String[] tokens = securityPolicies.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            String next = tokens[i];
            if (next.length() == 0) {
                return false;
            }
            securityPolicyList.add(next);
        }
        return true;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key) && (ret = this.getParamTextValue(key, 0)) != null) {
                ret = ret.trim();
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

