/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FileFilterCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(FileFilterCommands.class);
    private static final int NUM_FILTERS_PER_RPC = 100;
    private final int FILTER_NAME_MAX_LEN = 128;
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMNS_PARAM = "columns";
    public static final String FILTER_PARAM = "filter";
    public static final String START_PARAM = "start";
    public static final String LIMIT_PARAM = "limit";
    public static final String FILTER_NAME_PARAM = "name";
    public static final String FILTER_DESCRIPTION_PARAM = "description";
    public static final String FILTER_EXTENSIONS_PARAM = "fileextensions";
    public static final String SORTBY_PARAM = "sortby";
    public static final String SORTING_ORDER_PARAM = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM = "desc";
    public static final String OUTPUT_PARAM = "output";
    public static final String validCharRegEx = "[a-zA-Z0-9\\-_]*";
    public static final Pattern validNamePattern = Pattern.compile("[a-zA-Z0-9\\-_]*");
    public static final String validCharRegExWithSpace = "[a-zA-Z0-9\\-_\\s]*";
    public static final Pattern validDescPattern = Pattern.compile("[a-zA-Z0-9\\-_\\s]*");
    private static int MAX_FILTER_FIELDINFO = 0;
    private static int totalFilters = 0;
    UnixUserGroupHelper userInfo;
    private static Map<CLDBProto.FileFilterInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.FileFilterInfoFields.filterName, (Object)new FieldInfo(CLDBProto.FileFilterInfoFields.filterName.getNumber(), "n", "filtername", String.class, CLDBProto.ListSortKey.FilterName)).put((Object)CLDBProto.FileFilterInfoFields.filterId, (Object)new FieldInfo(CLDBProto.FileFilterInfoFields.filterId.getNumber(), "id", "filterid", Integer.class, CLDBProto.ListSortKey.FilterID)).put((Object)CLDBProto.FileFilterInfoFields.description, (Object)new FieldInfo(CLDBProto.FileFilterInfoFields.description.getNumber(), "desc", "description", String.class)).put((Object)CLDBProto.FileFilterInfoFields.fileExtension, (Object)new FieldInfo(CLDBProto.FileFilterInfoFields.fileExtension.getNumber(), "fe", "fileExtention", Long.class, null)).build();
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static String filterCreateUsage;
    public static String filterModifyUsage;
    public static String filterRemoveUsage;
    public static String filterInfoUsage;
    public static String filterListUsage;
    static final CLICommand filterCreateCommand;
    static final CLICommand filterModifyCommand;
    static final CLICommand filterListCommand;
    static final CLICommand filterInfoCommand;
    static final CLICommand filterRemoveCommand;
    public static CLICommand[] filefilterCommandsArray;
    public static final CLICommand filefilterCommands;
    UnixUserGroupHelper uInfo = null;

    public FileFilterCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        this.uInfo = new UnixUserGroupHelper();
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while initializing RPC " + e));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        LOG.debug((Object)"Processing::executeRealCommand");
        this.init();
        this.userInfo = new UnixUserGroupHelper();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
                return this.filterList();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
                return this.filterCreate();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
                return this.filterModify();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
                return this.filterInfo();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
                return this.filterRemove();
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return new TextCommandOutput("Filter command failed".getBytes());
    }

    CommandOutput filterInfo() throws Exception {
        String opParam;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(FILTER_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing filter name in the command to create filter").setField(FILTER_NAME_PARAM));
            return output;
        }
        String filterName = this.getParamTextValue(FILTER_NAME_PARAM, 0);
        if (filterName == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Filter name argument missing."));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String string = opParam = this.isParamPresent(OUTPUT_PARAM) ? this.getParamTextValue(OUTPUT_PARAM, 0) : "verbose";
        if (!opParam.equals("terse") && !opParam.equals("verbose")) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The output parameter must be either verbose or terse (default verbose). "));
            return output;
        }
        LOG.info((Object)("filterInfo: Looking up filter " + filterName));
        CLDBProto.FileFilterLookupResponse resp = FileFilterCommands.filterLookupByName(cluster, this.getUserCredentials(), filterName);
        if (resp.getStatus() != 0) {
            LOG.info((Object)("filterInfo: Lookup of filtername " + filterName + " failed, status=" + Errno.toString((int)resp.getStatus())));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Filter lookup of " + filterName + " failed, " + (resp.getStatus() == 2 ? "No such Filter" : resp.getErrMsg())));
            return output;
        }
        LOG.info((Object)("filterInfo: Lookup of filter " + filterName + " successful"));
        boolean terse = opParam.equals("terse");
        BitSet columns = this.getColumns();
        CommandOutput.OutputHierarchy.OutputNode filterInfo = this.formatFileFilterProperties(resp.getProperties(), terse, columns);
        out.addNode(filterInfo);
        return output;
    }

    public static CLDBProto.FileFilterLookupResponse filterLookupById(String cluster, Security.CredentialsMsg creds, int filterId) throws CLIProcessingException, MaprSecurityException {
        return FileFilterCommands.filterLookup(cluster, creds, null, filterId);
    }

    public static CLDBProto.FileFilterLookupResponse filterLookupByName(String cluster, Security.CredentialsMsg creds, String filtername) throws CLIProcessingException, MaprSecurityException {
        return FileFilterCommands.filterLookup(cluster, creds, filtername, 0);
    }

    public static CLDBProto.FileFilterLookupResponse filterLookup(String cluster, Security.CredentialsMsg creds, String filtername, int filterId) throws CLIProcessingException, MaprSecurityException {
        byte[] data = null;
        CLDBProto.FileFilterLookupRequest.Builder filterInfoBuilder = CLDBProto.FileFilterLookupRequest.newBuilder().setCreds(creds);
        if (filtername != null) {
            if (filterId != 0) {
                LOG.error((Object)"Found both id and name in lookup request, terminating.");
                CLDBProto.FileFilterLookupResponse.Builder resp = CLDBProto.FileFilterLookupResponse.newBuilder();
                return resp.setStatus(22).build();
            }
            filterInfoBuilder.addFilterNames(filtername);
        } else if (filterId != 0) {
            filterInfoBuilder.addFilterIds(filterId);
        } else {
            LOG.error((Object)"Found neither id nor name in lookup request, terminating.");
            CLDBProto.FileFilterLookupResponse.Builder resp = CLDBProto.FileFilterLookupResponse.newBuilder();
            return resp.setStatus(22).build();
        }
        try {
            if (cluster != null) {
                LOG.info((Object)("filterLookup(): Sending request to cluster " + cluster));
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterLookupProc.getNumber(), (MessageLite)filterInfoBuilder.build(), CLDBProto.FileFilterLookupResponse.class);
            } else {
                LOG.info((Object)"filterLookup(): Sending request to current cluster");
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterLookupProc.getNumber(), (MessageLite)filterInfoBuilder.build(), CLDBProto.FileFilterLookupResponse.class);
            }
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.FileFilterLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing filter lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    CommandOutput filterCreate() throws CLIProcessingException, MaprSecurityException {
        byte[] data = null;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Common.FileFilterProperties.Builder propB = Common.FileFilterProperties.newBuilder();
        CLDBProto.FileFilterCreateRequest.Builder reqB = CLDBProto.FileFilterCreateRequest.newBuilder().setCreds(this.getUserCredentials());
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String filtername = null;
        if (this.isParamPresent(FILTER_NAME_PARAM)) {
            filtername = this.getParamTextValue(FILTER_NAME_PARAM, 0);
        }
        StringBuilder sbErr = new StringBuilder();
        if (filtername == null || !this.isValidFileFilterName(filtername, sbErr)) {
            LOG.error((Object)"Invalid Value for param name");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Value for param name" + sbErr.toString()));
            return output;
        }
        CLDBProto.FileFilterLookupResponse filterLookupResp = FileFilterCommands.filterLookupByName(cluster, this.getUserCredentials(), filtername);
        if (filterLookupResp.hasStatus() && filterLookupResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Filter: " + filtername + " already exists"));
            return output;
        }
        propB.setFilterName(filtername);
        if (this.isParamPresent(FILTER_DESCRIPTION_PARAM)) {
            propB.setDescription(this.getParamTextValue(FILTER_DESCRIPTION_PARAM, 0));
        }
        if (this.isParamPresent(FILTER_EXTENSIONS_PARAM)) {
            String extString = this.getParamTextValue(FILTER_EXTENSIONS_PARAM, 0).trim();
            extString = extString.replaceAll("\\s+", "");
            Scanner s = new Scanner(extString).useDelimiter(MULTI_ARG_SEP);
            HashSet<String> set = new HashSet<String>();
            while (s.hasNext()) {
                String ext = s.next().trim();
                if (ext.isEmpty() || ext.isBlank()) continue;
                set.add(ext);
            }
            propB.setFileExtensions(String.join((CharSequence)MULTI_ARG_SEP, set));
        }
        reqB.setProperties(propB.build());
        try {
            if (cluster != null) {
                LOG.info((Object)("filterCreate(): Sending request to cluster " + cluster));
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterCreateProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterCreateResponse.class);
            } else {
                LOG.info((Object)"filterCreate(): Sending request to current cluster");
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterCreateProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterCreateResponse.class);
            }
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.FileFilterCreateResponse resp = CLDBProto.FileFilterCreateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)("Created filter " + filtername));
                out.addMessage("Filter Created successfully");
            } else {
                LOG.info((Object)("Error creation filter " + filtername + ":" + resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Filter creation failed"));
            }
            output.setOutput(out);
            return output;
        }
        catch (MaprSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing filter create, " + e.getLocalizedMessage());
        }
    }

    CommandOutput filterModify() throws CLIProcessingException, MaprSecurityException {
        byte[] data = null;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Common.FileFilterProperties.Builder propB = Common.FileFilterProperties.newBuilder();
        CLDBProto.FileFilterUpdateRequest.Builder reqB = CLDBProto.FileFilterUpdateRequest.newBuilder().setCreds(this.getUserCredentials());
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String filtername = null;
        if (this.isParamPresent(FILTER_NAME_PARAM)) {
            filtername = this.getParamTextValue(FILTER_NAME_PARAM, 0);
        }
        if (filtername == null) {
            LOG.error((Object)"Missing or invalid Value for param name");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing or invalid Value for param name"));
            return output;
        }
        CLDBProto.FileFilterLookupResponse filterLookupResp = FileFilterCommands.filterLookupByName(cluster, this.getUserCredentials(), filtername);
        if (filterLookupResp.hasStatus() && filterLookupResp.getStatus() != 0) {
            if (filterLookupResp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Non-existent filter name"));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(filterLookupResp.getStatus(), filterLookupResp.getErrMsg()));
            }
            return output;
        }
        propB.setFilterName(filtername);
        if (this.isParamPresent(FILTER_DESCRIPTION_PARAM)) {
            propB.setDescription(this.getParamTextValue(FILTER_DESCRIPTION_PARAM, 0));
        }
        if (this.isParamPresent(FILTER_EXTENSIONS_PARAM)) {
            String extString = this.getParamTextValue(FILTER_EXTENSIONS_PARAM, 0).trim();
            extString = extString.replaceAll("\\s+", "");
            Scanner s = new Scanner(extString).useDelimiter(MULTI_ARG_SEP);
            HashSet<String> set = new HashSet<String>();
            while (s.hasNext()) {
                String ext = s.next().trim();
                if (ext.isEmpty() || ext.isBlank()) continue;
                set.add(ext);
            }
            if (set.size() == 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Filter: " + filtername + " have invalid file extensions list"));
                return output;
            }
            propB.setFileExtensions(String.join((CharSequence)MULTI_ARG_SEP, set));
        }
        reqB.setProperties(propB.build());
        try {
            if (cluster != null) {
                LOG.info((Object)("filterModify(): Sending request to cluster " + cluster));
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterUpdateProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterUpdateResponse.class);
            } else {
                LOG.info((Object)"filterModify(): Sending request to current cluster");
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterUpdateProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterUpdateResponse.class);
            }
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.FileFilterUpdateResponse resp = CLDBProto.FileFilterUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)("Updated filter " + filtername));
                out.addMessage("Filter Updated successfully");
            } else {
                LOG.info((Object)("Error updating filter " + filtername + ":" + resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Filter updation failed: " + resp.getErrMsg()));
            }
            output.setOutput(out);
            return output;
        }
        catch (MaprSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing filter modify, " + e.getLocalizedMessage());
        }
    }

    CommandOutput filterRemove() throws CLIProcessingException, MaprSecurityException {
        byte[] data = null;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.FileFilterRemoveRequest.Builder reqB = CLDBProto.FileFilterRemoveRequest.newBuilder().setCreds(this.getUserCredentials());
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String filtername = null;
        if (this.isParamPresent(FILTER_NAME_PARAM)) {
            filtername = this.getParamTextValue(FILTER_NAME_PARAM, 0);
        }
        if (filtername == null) {
            LOG.error((Object)"Invalid Value for param name");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Value for param name"));
            return output;
        }
        reqB.setName(filtername);
        try {
            if (cluster != null) {
                LOG.info((Object)("filterRemove(): Sending request to cluster " + cluster));
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterRemoveProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterRemoveResponse.class);
            } else {
                LOG.info((Object)"filterRemove(): Sending request to current cluster");
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterRemoveProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.FileFilterRemoveResponse.class);
            }
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.FileFilterRemoveResponse resp = CLDBProto.FileFilterRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)("Removed filter " + filtername));
                out.addMessage("Filter Removed successfully");
            } else {
                LOG.info((Object)("Error Removing filter " + filtername + ":" + resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Filter Removing failed"));
            }
            output.setOutput(out);
            return output;
        }
        catch (MaprSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing filter remove, " + e.getLocalizedMessage());
        }
    }

    CommandOutput filterList() throws CLIProcessingException {
        try {
            String opParam;
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            if (this.isParamPresent(SORTBY_PARAM) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to list sorted filters, " + sortbyStr + " is not a valid keyword to sort filters."));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr + ". Supported Keys are " + supportedSortKeys));
                return output;
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM)) {
                if (!this.isParamPresent(SORTBY_PARAM)) {
                    String msg = "Invalid use of sortorder. Must be used with sortby";
                    LOG.error((Object)msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM, 0);
                if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM)) {
                    String msg = "Invalid value for sortorder. Valid values are asc and desc";
                    LOG.error((Object)msg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            String string = opParam = this.isParamPresent(OUTPUT_PARAM) ? this.getParamTextValue(OUTPUT_PARAM, 0) : "verbose";
            if (!opParam.equals("terse") && !opParam.equals("verbose")) {
                out.addMessage(this.getCommandUsage());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "The output parameter must be either verbose or terse (default verbose). "));
                return output;
            }
            this.list(out);
            return output;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request exception", (Throwable)e);
        }
    }

    boolean isValidFileFilterName(String name, StringBuilder errmsg) {
        if (name == null) {
            errmsg.append("Filter Name not found.");
            return false;
        }
        if (name.length() < 0 || name.length() > 128) {
            errmsg.append("Invalid filter name length " + name.length() + ", valid range is between 0 and 128");
            return false;
        }
        Matcher m = validNamePattern.matcher(name);
        if (!m.matches()) {
            errmsg.append("Invalid characters in filter name '" + name + "'. Only alphanumeric, hyphen(-) and underscore(_) are allowed.");
            return false;
        }
        return true;
    }

    CommandOutput.OutputHierarchy.OutputNode formatFileFilterProperties(Common.FileFilterProperties filterProps, boolean terse, BitSet columns) throws CLIProcessingException {
        LOG.debug((Object)("formatFileFilterProperties, formatting filter " + filterProps.getFilterName()));
        CommandOutput.OutputHierarchy.OutputNode filterProperties = new CommandOutput.OutputHierarchy.OutputNode();
        if (columns.get(CLDBProto.FileFilterInfoFields.filterId.getNumber())) {
            filterProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.FileFilterInfoFields.filterId).getName(terse), filterProps.getFilterId()));
        }
        if (columns.get(CLDBProto.FileFilterInfoFields.filterName.getNumber())) {
            filterProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.FileFilterInfoFields.filterName).getName(terse), (Object)filterProps.getFilterName()));
        }
        if (columns.get(CLDBProto.FileFilterInfoFields.description.getNumber()) && filterProps.hasDescription()) {
            filterProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.FileFilterInfoFields.description).getName(terse), (Object)filterProps.getDescription()));
        }
        if (columns.get(CLDBProto.FileFilterInfoFields.fileExtension.getNumber())) {
            filterProperties.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.FileFilterInfoFields.fileExtension).getName(terse), (Object)filterProps.getFileExtensions()));
        }
        return filterProperties;
    }

    private BitSet getColumns() throws CLIProcessingException {
        String columnsString;
        BitSet columns = new BitSet(fieldTable.size());
        columns.set(0, MAX_FILTER_FIELDINFO + 1);
        String string = columnsString = this.isParamPresent(COLUMNS_PARAM) ? this.getParamTextValue(COLUMNS_PARAM, 0) : null;
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.FileFilterListResponse resp = (CLDBProto.FileFilterListResponse)response;
        boolean terse = false;
        BitSet columns = this.getColumns();
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        for (Common.FileFilterProperties s : resp.getPropertiesList()) {
            try {
                CommandOutput.OutputHierarchy.OutputNode filterProperties = this.formatFileFilterProperties(s, terse, columns);
                out.addNode(filterProperties);
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while trying to list filters", (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while trying to list filters"));
            }
        }
        if (resp.getPropertiesList().size() > 0) {
            LOG.info((Object)("Total number of filters from list response is " + resp.getPropertiesList().size()));
            LOG.info((Object)("Total number of filters so far is " + (totalFilters += resp.getPropertiesList().size())));
            out.setTotal(totalFilters);
        }
    }

    public CLDBProto.FileFilterListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.FileFilterListRequest req = (CLDBProto.FileFilterListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterListProc.getNumber(), (MessageLite)req, CLDBProto.FileFilterListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileFilterListProc.getNumber(), (MessageLite)req, CLDBProto.FileFilterListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.FileFilterListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into FileFilterListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list filters failed. No data returned");
        return null;
    }

    private CLDBProto.FileFilterListRequest.Builder getFileFilterListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        CLDBProto.FileFilterListRequest.Builder req = CLDBProto.FileFilterListRequest.newBuilder();
        if (this.isParamPresent(SORTBY_PARAM)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            req.setSortKey(sortKey);
            if (this.isParamPresent(SORTING_ORDER_PARAM)) {
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM, 0);
                boolean order = false;
                if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM)) {
                    order = true;
                }
                req.setSortDescending(order);
            }
        }
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 100);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumnsAdd(bString).setLimiter(limiter);
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM) ? this.getParamIntValue(LIMIT_PARAM, 0) : Integer.MAX_VALUE;
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM) ? this.getParamIntValue(START_PARAM, 0) : 0;
    }

    public CLDBProto.FileFilterListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.FileFilterListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.FileFilterListRequest.newBuilder((CLDBProto.FileFilterListRequest)((CLDBProto.FileFilterListRequest)prevReq)) : this.getFileFilterListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.FileFilterListResponse)prevResp).getPropertiesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        } else {
            totalFilters = 0;
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.FileFilterListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.FileFilterListResponse)prevResp).getPropertiesCount());
    }

    static {
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        CLDBProto.FileFilterInfoFields[] values = CLDBProto.FileFilterInfoFields.values();
        int max = 0;
        for (CLDBProto.FileFilterInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_FILTER_FIELDINFO = max;
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Filter")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        for (FieldInfo fInfo : fieldTable.values()) {
            CLDBProto.ListSortKey sKey = fInfo.getListSortKey();
            if (sKey == null) continue;
            nameToEnumMap.put(fInfo.getShortName().toLowerCase(), sKey);
            nameToEnumMap.put(fInfo.getLongName().toLowerCase(), sKey);
        }
        filterCreateUsage = "maprcli filter create-name<filter-name>[-description<filter description>]-fileextensions<filter extension>";
        filterModifyUsage = "maprcli filter modify-name<filter-name>[-description<filter description>][-fileextensions<filter extension>]";
        filterRemoveUsage = "maprcli filter remove-name<filter-name>";
        filterInfoUsage = "maprcli filter info-name<filter-name>";
        filterListUsage = "maprcli filter modify";
        filterCreateCommand = new CLICommand("create", "usage : " + filterCreateUsage, FileFilterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILTER_NAME_PARAM, (Object)new TextInputParameter(FILTER_NAME_PARAM, FILTER_NAME_PARAM, true, null)).put((Object)FILTER_DESCRIPTION_PARAM, (Object)new TextInputParameter(FILTER_DESCRIPTION_PARAM, FILTER_DESCRIPTION_PARAM, false, null)).put((Object)FILTER_EXTENSIONS_PARAM, (Object)new TextInputParameter(FILTER_EXTENSIONS_PARAM, "extension", true, null)).build(), null).setShortUsage(filterCreateUsage);
        filterModifyCommand = new CLICommand("modify", "usage : " + filterModifyUsage, FileFilterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILTER_NAME_PARAM, (Object)new TextInputParameter(FILTER_NAME_PARAM, FILTER_NAME_PARAM, true, null)).put((Object)FILTER_DESCRIPTION_PARAM, (Object)new TextInputParameter(FILTER_DESCRIPTION_PARAM, FILTER_DESCRIPTION_PARAM, false, null)).put((Object)FILTER_EXTENSIONS_PARAM, (Object)new TextInputParameter(FILTER_EXTENSIONS_PARAM, "extension", false, null)).build(), null).setShortUsage(filterModifyUsage);
        filterListCommand = new CLICommand("list", "usage : " + filterListUsage, FileFilterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)START_PARAM, (Object)new IntegerInputParameter(START_PARAM, START_PARAM, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM, (Object)new IntegerInputParameter(LIMIT_PARAM, LIMIT_PARAM, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)OUTPUT_PARAM, (Object)new TextInputParameter(OUTPUT_PARAM, "verbose", false, "verbose")).put((Object)FILTER_PARAM, (Object)new FilterInputParameter(FILTER_PARAM, "none", false, "none")).put((Object)COLUMNS_PARAM, (Object)new TextInputParameter(COLUMNS_PARAM, "all", false, "all")).put((Object)SORTING_ORDER_PARAM, (Object)new TextInputParameter(SORTING_ORDER_PARAM, "<asc|desc>", false, null)).put((Object)SORTBY_PARAM, (Object)new TextInputParameter(SORTBY_PARAM, supportedSortKeys + ", column names of supported fields.", false, null)).build(), null).setShortUsage(filterListUsage);
        filterInfoCommand = new CLICommand("info", "usage : " + filterInfoUsage, FileFilterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILTER_NAME_PARAM, (Object)new TextInputParameter(FILTER_NAME_PARAM, "filterName", true, null)).build(), null).setShortUsage(filterInfoUsage);
        filterRemoveCommand = new CLICommand("remove", "usage : " + filterRemoveUsage, FileFilterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)FILTER_NAME_PARAM, (Object)new TextInputParameter(FILTER_NAME_PARAM, FILTER_NAME_PARAM, true, null)).build(), null).setShortUsage(filterRemoveUsage);
        filefilterCommandsArray = new CLICommand[]{filterCreateCommand, filterModifyCommand, filterListCommand, filterInfoCommand, filterRemoveCommand};
        filefilterCommands = new CLICommand("filefilter", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, filefilterCommandsArray).setShortUsage("filefilter [create|modify|info|list|remove]");
    }
}

