/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.jni.MapRCLINative;
import java.util.Map;
import org.apache.log4j.Logger;

public class RoleCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(RoleCommands.class);
    static final String ROLE_PARAM_NAME = "role";
    static final String OBJECT_PARAM_NAME = "object";
    static final String SET_VALUE_PARAM_NAME = "setValue";
    static final Map<String, BaseInputParameter> baseparams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand validateCommand = new CLICommand("validate", "validate the presence of role", RoleCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"role", (Object)new TextInputParameter("role", "role which need to be validate", true, null)).build(), null).setShortUsage("validate -acerole <role_name>");
    static final CLICommand[] subCommandList = new CLICommand[]{validateCommand};
    static final String usageStr = "acerole [validate] -role [role_name]";
    public static final CLICommand roleCommandList = new CLICommand("acerole", "usage: acerole [validate] -role [role_name]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, subCommandList).setShortUsage("acerole [validate] -role [role_name]");

    public RoleCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    CommandOutput validateRolePresence() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        boolean rolePresent = false;
        rolePresent = MapRCLINative.validateRolePresence((String)this.getParamTextValue(ROLE_PARAM_NAME, 0));
        if (rolePresent) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("maprcli acerole validate command returned : true"));
        } else {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("maprcli acerole validate command returned : false"));
        }
        output.setOutput(out);
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("validate")) {
            return this.validateRolePresence();
        }
        return new TextCommandOutput(("maprcli acerole command failed: unknown command " + command + " received.").getBytes());
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

