/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.audit;

import com.mapr.audit.ConcurrentFIFOHashMap;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class DeleteRecordHandling {
    private ConcurrentHashMap<String, String> deleteMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LinkedList<UnresolvedEntry>> unresolvedMap = new ConcurrentHashMap();
    private ConcurrentFIFOHashMap<String, String> fidMap;
    private MapRFileSystem fs;
    private static final Logger LOG = Logger.getLogger(DeleteRecordHandling.class);

    void LogErrorAndContinue(String string) {
        LOG.error((Object)string);
        System.out.println(string);
    }

    DeleteRecordHandling(ConcurrentFIFOHashMap fidMap, MapRFileSystem fs) {
        this.fidMap = fidMap;
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessDeleteRecord(String pFid, String cFid, String name, String ipathStr) throws Exception {
        String expPFid;
        if (this.fidMap.get(pFid) != null) {
            expPFid = this.fidMap.get(pFid).toString();
        } else if (this.deleteMap.get(pFid) != null) {
            expPFid = this.deleteMap.get(pFid).toString();
        } else {
            try {
                expPFid = this.fs.getMountPathFid(pFid);
            }
            catch (IOException e) {
                this.LogErrorAndContinue("getMountPath failed for invalid fid = " + pFid + " in log file = " + ipathStr);
                return;
            }
            if (expPFid != null) {
                this.fidMap.put(pFid, expPFid);
            }
        }
        if (expPFid != null) {
            String expCFid = expPFid.charAt(expPFid.length() - 1) != '/' ? expPFid + "/" + name : expPFid + name;
            this.deleteMap.put(cFid, expCFid);
            LinkedList<ResolvedFid> resolvedFids = new LinkedList<ResolvedFid>();
            resolvedFids.add(new ResolvedFid(cFid, expCFid));
            while (resolvedFids.size() != 0) {
                ResolvedFid tmpFid = (ResolvedFid)resolvedFids.removeFirst();
                String fslash = "";
                if (tmpFid.path.charAt(tmpFid.path.length() - 1) != '/') {
                    fslash = "/";
                }
                DeleteRecordHandling deleteRecordHandling = this;
                synchronized (deleteRecordHandling) {
                    LinkedList<UnresolvedEntry> list = this.unresolvedMap.get(tmpFid.fid);
                    if (list == null) {
                        continue;
                    }
                    for (UnresolvedEntry uentry : list) {
                        expCFid = tmpFid.path + fslash + uentry.name;
                        this.deleteMap.putIfAbsent(uentry.cFid, expCFid);
                        resolvedFids.add(new ResolvedFid(uentry.cFid, expCFid));
                    }
                }
                this.unresolvedMap.remove(tmpFid.fid);
            }
        } else {
            DeleteRecordHandling deleteRecordHandling = this;
            synchronized (deleteRecordHandling) {
                LinkedList<UnresolvedEntry> tmp;
                LinkedList<UnresolvedEntry> list = this.unresolvedMap.get(pFid);
                if (list == null && (tmp = this.unresolvedMap.putIfAbsent(pFid, list = new LinkedList())) != null) {
                    list = tmp;
                }
                list.add(new UnresolvedEntry(cFid, name));
            }
        }
    }

    public String get(String fid) {
        return this.deleteMap.get(fid);
    }

    class ResolvedFid {
        String fid;
        String path;

        ResolvedFid(String fid, String path) {
            this.fid = fid;
            this.path = path;
        }
    }

    private class UnresolvedEntry {
        String cFid;
        String name;

        UnresolvedEntry(String cFid, String name) {
            this.cFid = cFid;
            this.name = name;
        }
    }
}

